/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tranql.connector.jdbc.PreparedStatementKey;
import org.tranql.connector.jdbc.PreparedStatementWrapper;

public class ConnectionWrapper
implements Connection {
    private static final Log log = LogFactory.getLog((Class)Log.class);
    private boolean ISOLATION_CACHING_ENABLED = false;
    static final int DEFAULT_STMT_CACHE_SIZE = 0;
    Connection connection;
    private HashMap pStmtCache;
    private int maxCacheSize = 0;
    private boolean caching = false;
    private int cacheSize = 0;
    private int isolationLevel = 0;

    public ConnectionWrapper(Connection connection) {
        this(connection, 0);
    }

    public ConnectionWrapper(Connection connection, int cacheSize) {
        this.connection = connection;
        int n = this.maxCacheSize = cacheSize <= 0 ? 0 : cacheSize;
        if (this.maxCacheSize > 0) {
            this.caching = true;
            this.pStmtCache = new HashMap(this.maxCacheSize * 2);
        }
        try {
            this.isolationLevel = connection.getTransactionIsolation();
            this.ISOLATION_CACHING_ENABLED = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (!this.caching) {
            return this.connection.prepareStatement(sql);
        }
        PreparedStatementKey psk = new PreparedStatementKey(this, sql);
        PreparedStatementWrapper psw = (PreparedStatementWrapper)this.pStmtCache.get(psk);
        if (psw == null) {
            long startTime = System.currentTimeMillis();
            PreparedStatement ps = this.connection.prepareStatement(sql);
            long endTime = System.currentTimeMillis();
            psw = new PreparedStatementWrapper(this, sql, ps, endTime - startTime);
            psk.setPreparedStatementWrapper(psw);
            this.addStatementToCache(psk, psw);
        }
        psw.checkOutStatement();
        return psw;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (!this.caching) {
            return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        PreparedStatementKey psk = new PreparedStatementKey(this, sql, resultSetType, resultSetConcurrency);
        PreparedStatementWrapper psw = (PreparedStatementWrapper)this.pStmtCache.get(psk);
        if (psw == null) {
            long startTime = System.currentTimeMillis();
            PreparedStatement ps = this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
            long endTime = System.currentTimeMillis();
            psw = new PreparedStatementWrapper(this, sql, ps, endTime - startTime);
            psk.setPreparedStatementWrapper(psw);
            this.addStatementToCache(psk, psw);
        }
        psw.checkOutStatement();
        return psw;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (!this.caching) {
            return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        PreparedStatementKey psk = new PreparedStatementKey(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        PreparedStatementWrapper psw = (PreparedStatementWrapper)this.pStmtCache.get(psk);
        if (psw == null) {
            long startTime = System.currentTimeMillis();
            PreparedStatement ps = this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            long endTime = System.currentTimeMillis();
            psw = new PreparedStatementWrapper(this, sql, ps, endTime - startTime);
            psk.setPreparedStatementWrapper(psw);
            this.addStatementToCache(psk, psw);
        }
        psw.checkOutStatement();
        return psw;
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatementKey psk = new PreparedStatementKey(this, sql, autoGeneratedKeys);
        PreparedStatementWrapper psw = (PreparedStatementWrapper)this.pStmtCache.get(psk);
        if (psw == null) {
            long startTime = System.currentTimeMillis();
            PreparedStatement ps = this.connection.prepareStatement(sql, autoGeneratedKeys);
            long endTime = System.currentTimeMillis();
            psw = new PreparedStatementWrapper(this, sql, ps, endTime - startTime);
            psk.setPreparedStatementWrapper(psw);
            this.addStatementToCache(psk, psw);
        }
        psw.checkOutStatement();
        return psw;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (!this.caching) {
            return this.connection.prepareStatement(sql, columnIndexes);
        }
        PreparedStatementKey psk = new PreparedStatementKey(this, sql, columnIndexes);
        PreparedStatementWrapper psw = (PreparedStatementWrapper)this.pStmtCache.get(psk);
        if (psw == null) {
            long startTime = System.currentTimeMillis();
            PreparedStatement ps = this.connection.prepareStatement(sql, columnIndexes);
            long endTime = System.currentTimeMillis();
            psw = new PreparedStatementWrapper(this, sql, ps, endTime - startTime);
            psk.setPreparedStatementWrapper(psw);
            this.addStatementToCache(psk, psw);
        }
        psw.checkOutStatement();
        return psw;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (!this.caching) {
            return this.connection.prepareStatement(sql, columnNames);
        }
        PreparedStatementKey psk = new PreparedStatementKey(this, sql, columnNames);
        PreparedStatementWrapper psw = (PreparedStatementWrapper)this.pStmtCache.get(psk);
        if (psw == null) {
            long startTime = System.currentTimeMillis();
            PreparedStatement ps = this.connection.prepareStatement(sql, columnNames);
            long endTime = System.currentTimeMillis();
            psw = new PreparedStatementWrapper(this, sql, ps, endTime - startTime);
            psk.setPreparedStatementWrapper(psw);
            this.addStatementToCache(psk, psw);
        }
        psw.checkOutStatement();
        return psw;
    }

    void addStatementToCache(PreparedStatementKey psk, PreparedStatementWrapper psw) {
        if (!this.caching) {
            return;
        }
        if (this.cacheSize >= this.maxCacheSize) {
            this.evictStatement();
        }
        this.pStmtCache.put(psk, psw);
        ++this.cacheSize;
    }

    private void evictStatement() {
        Iterator keyList = this.pStmtCache.keySet().iterator();
        PreparedStatementKey oldestPsk = null;
        PreparedStatementKey currentPsk = null;
        PreparedStatementWrapper oldestPsw = null;
        PreparedStatementWrapper currentPsw = null;
        while (true) {
            if (keyList.hasNext()) {
                currentPsk = (PreparedStatementKey)keyList.next();
            } else if (oldestPsk != null) break;
            if (oldestPsk == null) {
                oldestPsk = currentPsk;
                continue;
            }
            oldestPsw = oldestPsk.getPreparedStatementWrapper();
            currentPsw = currentPsk.getPreparedStatementWrapper();
            if (oldestPsw.getTimesUsed() > currentPsw.getTimesUsed()) {
                oldestPsk = currentPsk;
                continue;
            }
            if (oldestPsw.getTimesUsed() != currentPsw.getTimesUsed() || oldestPsw.getLastTimeUsed() <= currentPsw.getLastTimeUsed()) continue;
            oldestPsk = currentPsk;
        }
        this.pStmtCache.remove(oldestPsk);
        oldestPsw.closeStatement();
    }

    public void returnStatementToCache(PreparedStatementWrapper psw) {
        if (psw.decrementUseCount() < 0L) {
            log.error((Object)("Counting error in PreparedStatementCaching System.\n" + psw.toString()));
        }
    }

    public void setTransactionIsolation(int isolationLevel) throws SQLException {
        if (this.ISOLATION_CACHING_ENABLED && this.isolationLevel == isolationLevel) {
            return;
        }
        this.connection.setTransactionIsolation(isolationLevel);
        this.isolationLevel = isolationLevel;
    }

    public int getTransactionIsolation() throws SQLException {
        return this.ISOLATION_CACHING_ENABLED ? this.isolationLevel : this.connection.getTransactionIsolation();
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public Statement createStatement() throws SQLException {
        return this.connection.createStatement();
    }

    public CallableStatement prepareCall(String arg0) throws SQLException {
        return this.connection.prepareCall(arg0);
    }

    public String nativeSQL(String arg0) throws SQLException {
        return this.connection.nativeSQL(arg0);
    }

    public void setAutoCommit(boolean arg0) throws SQLException {
        this.connection.setAutoCommit(arg0);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    public void close() throws SQLException {
        this.connection.close();
    }

    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    public void setReadOnly(boolean arg0) throws SQLException {
        this.connection.setReadOnly(arg0);
    }

    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    public void setCatalog(String arg0) throws SQLException {
        this.connection.setCatalog(arg0);
    }

    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    public Statement createStatement(int arg0, int arg1) throws SQLException {
        return this.connection.createStatement(arg0, arg1);
    }

    public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
        return this.connection.prepareCall(arg0, arg1, arg2);
    }

    public Map getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    public void setTypeMap(Map arg0) throws SQLException {
        this.connection.setTypeMap(arg0);
    }

    public void setHoldability(int arg0) throws SQLException {
        this.connection.setHoldability(arg0);
    }

    public int getHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.connection.setSavepoint();
    }

    public Savepoint setSavepoint(String arg0) throws SQLException {
        return this.connection.setSavepoint(arg0);
    }

    public void rollback(Savepoint arg0) throws SQLException {
        this.connection.rollback();
    }

    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        this.connection.releaseSavepoint(arg0);
    }

    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        return this.connection.createStatement(arg0, arg1, arg2);
    }

    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        return this.connection.prepareCall(arg0, arg1, arg2, arg3);
    }
}

