/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tranql.connector.jdbc.ConnectionWrapper;

public class PreparedStatementWrapper
implements PreparedStatement {
    private static final Log log = LogFactory.getLog((Class)Log.class);
    PreparedStatement ps = null;
    ConnectionWrapper cw = null;
    Statement s = null;
    String sql = null;
    boolean statementClosed = false;
    private long lastTimeUsed = 0L;
    private long timesUsed = 0L;
    private long useCount = 0L;
    private long actualPrepareTime = 0L;

    public PreparedStatementWrapper(ConnectionWrapper cw, String sql, PreparedStatement ps, long prepareTime) {
        this.ps = ps;
        this.cw = cw;
        this.sql = sql;
        this.setActualPrepareTime(prepareTime);
    }

    public void close() throws SQLException {
        this.ps.clearWarnings();
        this.ps.clearBatch();
        this.ps.clearParameters();
        this.cw.returnStatementToCache(this);
    }

    protected void closeStatement() {
        try {
            if (!this.statementClosed) {
                this.ps.close();
                this.statementClosed = true;
            }
        }
        catch (SQLException e) {
            log.error((Object)("TRANQL DB2 EmbeddedXA Driver. Error closing PreparedStatement in closeStatement.\n  Error message = " + e.getMessage() + "\n" + "     Error code = " + Integer.toString(e.getErrorCode()) + "       SQLState = " + e.getSQLState()));
            e.printStackTrace();
        }
    }

    public long getActualPrepareTime() {
        return this.actualPrepareTime;
    }

    protected void setActualPrepareTime(long actualPrepareTime) {
        this.actualPrepareTime = actualPrepareTime;
    }

    public long getLastTimeUsed() {
        return this.lastTimeUsed;
    }

    protected void updateLastTimeUsed() {
        this.lastTimeUsed = System.currentTimeMillis();
    }

    public long getTimesUsed() {
        return this.timesUsed;
    }

    protected long incrementTimesUsed() {
        return ++this.timesUsed;
    }

    protected void setTimesUsed(long timesUsed) {
        this.timesUsed = timesUsed;
    }

    public long getUseCount() {
        return this.useCount;
    }

    protected long incrementUseCount() {
        return ++this.useCount;
    }

    protected long decrementUseCount() {
        return --this.useCount;
    }

    protected synchronized void setUseCount(long useCount) {
        this.useCount = useCount;
    }

    public String toString() {
        String details = "                     SQL: " + this.sql + "\n" + "          Last time used: " + new Date(this.lastTimeUsed).toString() + "\n" + "    Number of times used: " + this.timesUsed + "\n" + "    Current in Use Count: " + this.useCount + "\n" + "\t Initial Prepare time: " + this.actualPrepareTime + " milliseconds\n";
        return details;
    }

    public synchronized void checkOutStatement() {
        this.incrementTimesUsed();
        this.incrementUseCount();
        this.updateLastTimeUsed();
    }

    public ResultSet executeQuery() throws SQLException {
        return this.ps.executeQuery();
    }

    public int executeUpdate() throws SQLException {
        return this.ps.executeUpdate();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.ps.setNull(parameterIndex, sqlType);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.ps.setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.ps.setByte(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.ps.setShort(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.ps.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.ps.setLong(parameterIndex, x);
    }

    public void setFloat(int arg0, float arg1) throws SQLException {
        this.ps.setFloat(arg0, arg1);
    }

    public void setDouble(int arg0, double arg1) throws SQLException {
        this.ps.setDouble(arg0, arg1);
    }

    public void setBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        this.ps.setBigDecimal(arg0, arg1);
    }

    public void setString(int arg0, String arg1) throws SQLException {
        this.ps.setString(arg0, arg1);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.ps.setBytes(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.ps.setDate(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.ps.setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.ps.setTimestamp(parameterIndex, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setAsciiStream(parameterIndex, x, length);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setUnicodeStream(parameterIndex, x, length);
    }

    public void setBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.ps.setBinaryStream(arg0, arg1, arg2);
    }

    public void clearParameters() throws SQLException {
        this.ps.clearParameters();
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.ps.setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.ps.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.ps.setObject(parameterIndex, x);
    }

    public boolean execute() throws SQLException {
        return this.ps.execute();
    }

    public void addBatch() throws SQLException {
        this.ps.addBatch();
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.ps.setCharacterStream(parameterIndex, reader, length);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.ps.setRef(i, x);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.ps.setBlob(i, x);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.ps.setClob(i, x);
    }

    public void setArray(int i, Array x) throws SQLException {
        this.ps.setArray(i, x);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.ps.getMetaData();
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.ps.setDate(parameterIndex, x, cal);
    }

    public void setTime(int parameterIndex, Time time, Calendar cal) throws SQLException {
        this.ps.setTime(parameterIndex, time, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.ps.setTimestamp(parameterIndex, x, cal);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.ps.setNull(paramIndex, sqlType, typeName);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.ps.setURL(parameterIndex, x);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.ps.getParameterMetaData();
    }

    public ResultSet executeQuery(String arg0) throws SQLException {
        return this.ps.executeQuery(arg0);
    }

    public int executeUpdate(String arg0) throws SQLException {
        return this.ps.executeUpdate(arg0);
    }

    public int getMaxFieldSize() throws SQLException {
        return this.ps.getMaxFieldSize();
    }

    public void setMaxFieldSize(int arg0) throws SQLException {
        this.ps.setMaxFieldSize(arg0);
    }

    public int getMaxRows() throws SQLException {
        return this.ps.getMaxRows();
    }

    public void setMaxRows(int arg0) throws SQLException {
        this.ps.setMaxRows(arg0);
    }

    public void setEscapeProcessing(boolean arg0) throws SQLException {
        this.ps.setEscapeProcessing(arg0);
    }

    public int getQueryTimeout() throws SQLException {
        return this.ps.getQueryTimeout();
    }

    public void setQueryTimeout(int arg0) throws SQLException {
        this.ps.setQueryTimeout(arg0);
    }

    public void cancel() throws SQLException {
        this.ps.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.ps.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.ps.clearWarnings();
    }

    public void setCursorName(String arg0) throws SQLException {
        this.ps.setCursorName(arg0);
    }

    public boolean execute(String arg0) throws SQLException {
        return this.ps.execute(arg0);
    }

    public ResultSet getResultSet() throws SQLException {
        return this.ps.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        return this.ps.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.ps.getMoreResults();
    }

    public void setFetchDirection(int arg0) throws SQLException {
        this.ps.setFetchDirection(arg0);
    }

    public int getFetchDirection() throws SQLException {
        return this.ps.getFetchDirection();
    }

    public void setFetchSize(int arg0) throws SQLException {
        this.ps.setFetchSize(arg0);
    }

    public int getFetchSize() throws SQLException {
        return this.ps.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.ps.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.ps.getResultSetType();
    }

    public void addBatch(String arg0) throws SQLException {
        this.ps.addBatch(arg0);
    }

    public void clearBatch() throws SQLException {
        this.ps.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        return this.ps.executeBatch();
    }

    public Connection getConnection() throws SQLException {
        return this.ps.getConnection();
    }

    public boolean getMoreResults(int arg0) throws SQLException {
        return this.ps.getMoreResults(arg0);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.ps.getGeneratedKeys();
    }

    public int executeUpdate(String arg0, int arg1) throws SQLException {
        return this.ps.executeUpdate(arg0, arg1);
    }

    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        return this.ps.executeUpdate(arg0, arg1);
    }

    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        return this.ps.executeUpdate(arg0, arg1);
    }

    public boolean execute(String arg0, int arg1) throws SQLException {
        return this.ps.execute(arg0, arg1);
    }

    public boolean execute(String arg0, int[] arg1) throws SQLException {
        return this.ps.execute(arg0, arg1);
    }

    public boolean execute(String arg0, String[] arg1) throws SQLException {
        return this.ps.execute(arg0, arg1);
    }

    public int getResultSetHoldability() throws SQLException {
        return this.ps.getResultSetHoldability();
    }
}

