/*
 * Decompiled with CFR 0.152.
 */
package travel.izi.sdk;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import retrofit.RetrofitError;
import retrofit.client.Response;

public class IZITravelError
extends RuntimeException {
    private final String url;
    private final Response response;
    private final HttpError httpError;
    private final RetrofitError.Kind kind;

    public static IZITravelError from(RetrofitError error) {
        HttpError httpError = (HttpError)error.getBodyAs(HttpError.class);
        String message = httpError != null ? httpError.toString() : error.getMessage();
        return new IZITravelError(message, error.getUrl(), error.getResponse(), httpError, error.getKind(), error.getCause());
    }

    private IZITravelError(String message, String url, Response response, HttpError httpError, RetrofitError.Kind kind, Throwable exception) {
        super(message, exception);
        this.url = url;
        this.response = response;
        this.httpError = httpError;
        this.kind = kind;
    }

    public String getUrl() {
        return this.url;
    }

    public Response getResponse() {
        return this.response;
    }

    public HttpError getHttpError() {
        return this.httpError;
    }

    public RetrofitError.Kind getKind() {
        return this.kind;
    }

    public static class HttpError
    implements Serializable {
        private static final long serialVersionUID = 1942575303158771456L;
        public int code;
        @SerializedName(value="error")
        public String message;

        public String toString() {
            return this.code + " " + this.message;
        }
    }
}

