/*
 * Decompiled with CFR 0.152.
 */
package travel.izi.sdk.util;

public class MediaHelper {
    private static final String IMAGE_URL_PATTERN = "%1$s/%2$s/%3$s.jpg";
    private static final String FEATURED_IMAGE_URL_PATTERN = "%1$s/featured/%2$s";
    private static final String IMAGE_WITH_SIZE_URL_PATTERN = "%1$s/%2$s/%3$s_%4$s.jpg";
    private static final String AUDIO_URL_PATTERN = "%1$s/%2$s/%3$s.m4a";
    private static final String VIDEO_URL_PATTERN = "%1$s/%2$s/%3$s.mp4";
    private final String mMediaUrl;

    public MediaHelper(String mediaUrl) {
        this.mMediaUrl = mediaUrl;
    }

    public String buildImageUrl(String cpId, String mediaId, ImageSize size) {
        return String.format(IMAGE_WITH_SIZE_URL_PATTERN, new Object[]{this.mMediaUrl, cpId, mediaId, size});
    }

    public String buildImageUrl(String cpId, String mediaId) {
        return String.format(IMAGE_URL_PATTERN, this.mMediaUrl, cpId, mediaId);
    }

    public String buildFeaturedImageUrl(String mediaId) {
        return String.format(FEATURED_IMAGE_URL_PATTERN, this.mMediaUrl, mediaId);
    }

    public String buildAudioUrl(String cpId, String mediaId) {
        return String.format(AUDIO_URL_PATTERN, this.mMediaUrl, cpId, mediaId);
    }

    public String buildVideoUrl(String cpId, String mediaId) {
        return String.format(VIDEO_URL_PATTERN, this.mMediaUrl, cpId, mediaId);
    }

    public static enum ImageSize {
        Small("120x90"),
        Medium("240x180"),
        Large("480x360"),
        XLarge("800x600");

        private final String value;

        private ImageSize(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

