/*
 * Decompiled with CFR 0.152.
 */
package trust.nccgroup.readablethrift;

import java.util.Scanner;
import org.apache.thrift.TException;
import org.json.JSONObject;
import trust.nccgroup.readablethrift.ThriftCodec;

public class InteractiveCodec {
    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        while (true) {
            String input;
            System.out.print("Enter Base64 encoded message or JSON object (or q to quit): ");
            if (!scanner.hasNextLine()) {
                scanner = new Scanner(System.in);
            }
            if ((input = scanner.nextLine()).equals("q")) break;
            if (input.startsWith("{")) {
                StringBuilder inputJsonBuilder = new StringBuilder();
                inputJsonBuilder.append(input);
                while (scanner.hasNextLine()) {
                    inputJsonBuilder.append(scanner.nextLine());
                }
                String concatted = inputJsonBuilder.toString();
                JSONObject inputJson = new JSONObject(concatted);
                try {
                    System.out.println(ThriftCodec.b64encodeJson(inputJson));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                JSONObject result = ThriftCodec.decodeB64String(input);
                System.out.println(result.toString(4));
            }
            catch (TException e) {
                e.printStackTrace();
            }
        }
        scanner.close();
    }
}

