/*
 * Decompiled with CFR 0.152.
 */
package trust.nccgroup.readablethrift;

import org.apache.commons.codec.binary.Base64;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.transport.AutoExpandingBufferWriteTransport;
import org.apache.thrift.transport.TMemoryBuffer;
import org.apache.thrift.transport.TTransport;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import trust.nccgroup.readablethrift.TypeUtils;

public class ThriftCodec {
    private TTransport thriftTransport;
    private TProtocol thriftProtocol;

    protected TTransport getThriftTransport() {
        return this.getThriftProtocol().getTransport();
    }

    protected TProtocol getThriftProtocol() {
        return this.thriftProtocol;
    }

    protected void setThriftProtocol(TProtocol thriftProtocol) {
        this.thriftProtocol = thriftProtocol;
    }

    protected Object readFieldValue(byte fieldType) throws TException {
        TProtocol prot = this.getThriftProtocol();
        switch (fieldType) {
            case 2: {
                return prot.readBool();
            }
            case 3: {
                return prot.readByte();
            }
            case 4: {
                return prot.readDouble();
            }
            case 6: {
                return prot.readI16();
            }
            case 8: {
                return prot.readI32();
            }
            case 10: {
                return prot.readI64();
            }
            case 11: {
                return prot.readString();
            }
            case 12: {
                return this.readStruct();
            }
            case 13: {
                return this.readMap();
            }
            case 14: {
                return this.readSet();
            }
            case 15: {
                return this.readList();
            }
            case 16: {
                throw new UnsupportedOperationException("Enum type reads not supported");
            }
            case 1: {
                throw new UnsupportedOperationException("Void type reads not supported");
            }
            case 0: {
                throw new IllegalArgumentException("Stop type has no value");
            }
        }
        throw new IllegalArgumentException("Unknown type with value " + fieldType);
    }

    protected void writeFieldValue(byte fieldType, Object value) throws TException {
        TProtocol prot = this.getThriftProtocol();
        switch (fieldType) {
            case 2: {
                if (value instanceof String) {
                    value = Boolean.valueOf((String)value);
                }
                prot.writeBool(((Boolean)value).booleanValue());
                break;
            }
            case 3: {
                if (value instanceof String) {
                    String stringRep = (String)value;
                    if (stringRep.length() != 1) {
                        throw new IllegalArgumentException("More than one byte in string representation of byte field");
                    }
                    value = stringRep.getBytes()[0];
                }
                prot.writeByte(((Byte)value).byteValue());
                break;
            }
            case 4: {
                if (value instanceof String) {
                    value = new Double((String)value);
                }
                prot.writeDouble(((Double)value).doubleValue());
                break;
            }
            case 6: {
                if (value instanceof String) {
                    value = new Integer((String)value);
                }
                prot.writeI16(((Short)value).shortValue());
                break;
            }
            case 8: {
                if (value instanceof String) {
                    value = new Integer((String)value);
                }
                prot.writeI32(((Integer)value).intValue());
                break;
            }
            case 10: {
                if (value instanceof String) {
                    value = Long.valueOf((String)value);
                } else if (value instanceof Integer) {
                    value = ((Integer)value).longValue();
                }
                prot.writeI64(((Long)value).longValue());
                break;
            }
            case 11: {
                prot.writeString((String)value);
                break;
            }
            case 12: {
                if (value instanceof String) {
                    throw new UnsupportedOperationException("Struct from String not implemented");
                }
                this.writeStruct((JSONArray)value);
                break;
            }
            case 13: {
                if (value instanceof String) {
                    throw new UnsupportedOperationException("Map from String not implemented");
                }
                this.writeMap((JSONObject)value);
                break;
            }
            case 14: {
                if (value instanceof String) {
                    throw new UnsupportedOperationException("Set from String not implemented");
                }
                this.writeSet((JSONObject)value);
                break;
            }
            case 15: {
                if (value instanceof String) {
                    throw new UnsupportedOperationException("List from String not implemented");
                }
                this.writeList((JSONObject)value);
                break;
            }
            case 16: {
                throw new UnsupportedOperationException("Enum type writes not supported");
            }
            case 1: {
                throw new UnsupportedOperationException("Void type writes not supported");
            }
            case 0: {
                throw new IllegalArgumentException("Stop type has no value");
            }
            default: {
                throw new IllegalArgumentException("Unknown type with value " + fieldType);
            }
        }
    }

    protected JSONArray readFields() throws TException {
        TField field;
        TProtocol prot = this.getThriftProtocol();
        JSONArray fields = new JSONArray();
        do {
            field = prot.readFieldBegin();
            JSONObject curField = new JSONObject();
            curField.put("id", (int)field.id);
            curField.put("type", (Object)TypeUtils.getTypeName(field.type));
            if (field.type != 0) {
                curField.put("value", this.readFieldValue(field.type));
            }
            prot.readFieldEnd();
            if (field.type == 0) continue;
            fields.put((Object)curField);
        } while (field.type != 0);
        return fields;
    }

    protected void writeFields(JSONArray fields) throws TException {
        TProtocol prot = this.getThriftProtocol();
        for (int i = 0; i < fields.length(); ++i) {
            JSONObject fieldJson = fields.getJSONObject(i);
            TField field = new TField("", TypeUtils.getTypeCode(fieldJson.getString("type")), (short)fieldJson.getInt("id"));
            prot.writeFieldBegin(field);
            this.writeFieldValue(field.type, fieldJson.get("value"));
            prot.writeFieldEnd();
        }
        prot.writeByte((byte)0);
    }

    protected JSONObject readMap() throws TException {
        TProtocol prot = this.getThriftProtocol();
        TMap map = prot.readMapBegin();
        JSONObject keyVals = new JSONObject();
        for (int i = 0; i < map.size; ++i) {
            Object key = this.readFieldValue(map.keyType);
            Object value = this.readFieldValue(map.valueType);
            keyVals.put(key.toString(), value);
        }
        prot.readMapEnd();
        JSONObject result = new JSONObject();
        result.put("keyType", (Object)TypeUtils.getTypeName(map.keyType));
        result.put("valueType", (Object)TypeUtils.getTypeName(map.valueType));
        result.put("map", (Object)keyVals);
        return result;
    }

    protected void writeMap(JSONObject mapJson) throws TException {
        TProtocol prot = this.getThriftProtocol();
        JSONObject keyVals = mapJson.getJSONObject("map");
        TMap map = new TMap(TypeUtils.getTypeCode(mapJson.getString("keyType")), TypeUtils.getTypeCode(mapJson.getString("valueType")), keyVals.length());
        prot.writeMapBegin(map);
        byte keyType = TypeUtils.getTypeCode(mapJson.getString("keyType"));
        byte valueType = TypeUtils.getTypeCode(mapJson.getString("valueType"));
        for (String key : keyVals.keySet()) {
            this.writeFieldValue(keyType, key);
            this.writeFieldValue(valueType, keyVals.get(key));
        }
        prot.writeMapEnd();
    }

    protected JSONObject readList() throws TException {
        TProtocol prot = this.getThriftProtocol();
        TList list = prot.readListBegin();
        JSONArray listJson = new JSONArray();
        for (int i = 0; i < list.size; ++i) {
            listJson.put(this.readFieldValue(list.elemType));
        }
        prot.readListEnd();
        JSONObject result = new JSONObject();
        result.put("elemType", (Object)TypeUtils.getTypeName(list.elemType));
        result.put("list", (Object)listJson);
        return result;
    }

    protected void writeList(JSONObject listJson) throws TException {
        TProtocol prot = this.getThriftProtocol();
        byte elemType = TypeUtils.getTypeCode(listJson.getString("elemType"));
        JSONArray actualList = listJson.getJSONArray("list");
        TList list = new TList(elemType, actualList.length());
        prot.writeListBegin(list);
        for (int i = 0; i < list.size; ++i) {
            this.writeFieldValue(list.elemType, actualList.get(i));
        }
        prot.writeListEnd();
    }

    protected JSONObject readSet() throws TException {
        TProtocol prot = this.getThriftProtocol();
        TSet set = prot.readSetBegin();
        JSONArray setJson = new JSONArray();
        for (int i = 0; i < set.size; ++i) {
            setJson.put(this.readFieldValue(set.elemType));
        }
        prot.readSetEnd();
        JSONObject result = new JSONObject();
        result.put("elemType", (Object)TypeUtils.getTypeName(set.elemType));
        result.put("set", (Object)setJson);
        return result;
    }

    protected void writeSet(JSONObject setJson) throws TException {
        TProtocol prot = this.getThriftProtocol();
        byte elemType = TypeUtils.getTypeCode(setJson.getString("elemType"));
        JSONArray actualSet = setJson.getJSONArray("set");
        TSet set = new TSet(elemType, actualSet.length());
        prot.writeSetBegin(set);
        for (int i = 0; i < set.size; ++i) {
            this.writeFieldValue(set.elemType, actualSet.get(i));
        }
        prot.writeSetEnd();
    }

    protected JSONArray readStruct() throws TException {
        TProtocol prot = this.getThriftProtocol();
        prot.readStructBegin();
        JSONArray structJson = this.readFields();
        prot.readStructEnd();
        return structJson;
    }

    protected void writeStruct(JSONArray structJson) throws TException {
        TProtocol prot = this.getThriftProtocol();
        prot.writeStructBegin(new TStruct());
        this.writeFields(structJson);
        prot.writeStructEnd();
    }

    protected JSONObject readMessage() throws TException {
        TProtocol prot = this.getThriftProtocol();
        JSONObject messageJson = new JSONObject();
        TMessage msg = prot.readMessageBegin();
        messageJson.put("name", (Object)msg.name);
        messageJson.put("seqid", msg.seqid);
        messageJson.put("type", (Object)TypeUtils.getMessageTypeName(msg.type));
        messageJson.put("fields", (Object)this.readFields());
        prot.readMessageEnd();
        return messageJson;
    }

    protected void writeMessage(JSONObject msgJson) throws TException {
        TProtocol prot = this.getThriftProtocol();
        TMessage msg = new TMessage(msgJson.getString("name"), TypeUtils.getMessageTypeCode(msgJson.getString("type")), msgJson.getInt("seqid"));
        prot.writeMessageBegin(msg);
        this.writeFields(msgJson.getJSONArray("fields"));
        prot.writeMessageEnd();
    }

    public JSONObject decode(byte[] binaryBuffer) throws TException, JSONException {
        TMemoryBuffer byteBuffer = new TMemoryBuffer(binaryBuffer.length);
        this.setThriftProtocol((TProtocol)new TBinaryProtocol((TTransport)byteBuffer));
        byteBuffer.write(binaryBuffer);
        JSONObject messageJson = this.readMessage();
        JSONObject result = new JSONObject();
        result.put("message", (Object)messageJson);
        return result;
    }

    public byte[] encode(JSONObject thriftJson) throws TException, JSONException {
        AutoExpandingBufferWriteTransport transportBuffer = new AutoExpandingBufferWriteTransport(32000, 1.5);
        this.setThriftProtocol((TProtocol)new TBinaryProtocol((TTransport)transportBuffer));
        this.writeMessage(thriftJson.getJSONObject("message"));
        transportBuffer.flush();
        transportBuffer.close();
        byte[] finalBuf = transportBuffer.getBuf().array();
        int resultSize = transportBuffer.getPos();
        byte[] result = new byte[resultSize];
        System.arraycopy(finalBuf, 0, result, 0, resultSize);
        return result;
    }

    public static JSONObject decodeB64String(String input) throws TException, JSONException {
        byte[] binaryBuffer = Base64.decodeBase64((String)input);
        ThriftCodec codec = new ThriftCodec();
        return codec.decode(binaryBuffer);
    }

    public static String b64encodeJson(JSONObject thriftJson) throws TException, JSONException {
        ThriftCodec codec = new ThriftCodec();
        return Base64.encodeBase64String((byte[])codec.encode(thriftJson));
    }
}

