/*
 * Decompiled with CFR 0.152.
 */
package trust.nccgroup.readablethrift;

import java.util.HashMap;
import java.util.Map;

final class TypeUtils {
    static final int SIZEOF_I32 = 4;
    private static final Map<Byte, String> messageTypeMap = new HashMap<Byte, String>();
    private static final Map<Byte, String> typeMap;

    TypeUtils() {
    }

    static String getTypeName(byte type) {
        return typeMap.get(type);
    }

    static byte getTypeCode(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must be non-null");
        }
        for (byte b : typeMap.keySet()) {
            if (!typeMap.get(b).equalsIgnoreCase(name)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unknown type '" + name + "'");
    }

    static String getMessageTypeName(byte messageType) {
        return messageTypeMap.get(messageType);
    }

    static byte getMessageTypeCode(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must be non-null");
        }
        for (byte b : messageTypeMap.keySet()) {
            if (!messageTypeMap.get(b).equalsIgnoreCase(name)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unknown type '" + name + "'");
    }

    static {
        messageTypeMap.put((byte)1, "call");
        messageTypeMap.put((byte)3, "exception");
        messageTypeMap.put((byte)4, "oneway");
        messageTypeMap.put((byte)2, "reply");
        typeMap = new HashMap<Byte, String>();
        typeMap.put((byte)0, "stop");
        typeMap.put((byte)1, "void");
        typeMap.put((byte)2, "bool");
        typeMap.put((byte)3, "byte");
        typeMap.put((byte)4, "double");
        typeMap.put((byte)6, "i16");
        typeMap.put((byte)8, "i32");
        typeMap.put((byte)10, "i64");
        typeMap.put((byte)11, "string");
        typeMap.put((byte)12, "struct");
        typeMap.put((byte)13, "map");
        typeMap.put((byte)14, "set");
        typeMap.put((byte)15, "list");
        typeMap.put((byte)16, "enum");
    }
}

