/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.annovention;

import com.impetus.annovention.Discoverer;
import com.impetus.annovention.Filter;
import com.impetus.annovention.FilterImpl;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class ClasspathDiscoverer
extends Discoverer {
    private Filter filter = new FilterImpl();

    public final URL[] findResources() {
        URL[] ret = this.getUrlsForCurrentClasspath();
        if (ret.length == 0) {
            ret = this.getUrlsForSystemClasspath();
        }
        return ret;
    }

    public final Filter getFilter() {
        return this.filter;
    }

    public final void setFilter(Filter filter) {
        this.filter = filter;
    }

    private URL[] getUrlsForCurrentClasspath() {
        ArrayList<URL> list = new ArrayList<URL>();
        for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            URL[] urlArray = ((URLClassLoader)loader).getURLs();
            List<URL> urlList = Arrays.asList(urlArray);
            list.addAll(urlList);
        }
        return list.toArray(new URL[list.size()]);
    }

    private URL[] getUrlsForSystemClasspath() {
        ArrayList<URL> list = new ArrayList<URL>();
        String classpath = System.getProperty("java.class.path");
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            File fp = new File(path);
            if (!fp.exists()) {
                throw new RuntimeException("File in java.class.path does not exist: " + fp);
            }
            try {
                list.add(fp.toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return list.toArray(new URL[list.size()]);
    }
}

