/*
 * Decompiled with CFR 0.152.
 */
package jauter;

import jauter.Pattern;
import jauter.Routed;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonorderedRouter<T> {
    protected final List<Pattern<T>> patterns = new ArrayList<Pattern<T>>();
    protected final Map<T, List<Pattern<T>>> reverse = new HashMap<T, List<Pattern<T>>>();
    protected T notFound;

    public NonorderedRouter<T> pattern(String string, T t) {
        Pattern<T> pattern = new Pattern<T>(string, t);
        this.patterns.add(pattern);
        List<Pattern<T>> list = this.reverse.get(t);
        if (list == null) {
            list = new ArrayList<Pattern<T>>();
            list.add(pattern);
            this.reverse.put(t, list);
        } else {
            list.add(pattern);
        }
        return this;
    }

    public NonorderedRouter<T> notFound(T t) {
        this.notFound = t;
        return this;
    }

    public void removeTarget(T t) {
        Iterator<Pattern<T>> iterator = this.patterns.iterator();
        while (iterator.hasNext()) {
            Pattern<T> pattern = iterator.next();
            if (!pattern.target().equals(t)) continue;
            iterator.remove();
        }
        this.reverse.remove(t);
    }

    public void removePath(String string) {
        String string2 = Pattern.removeSlashAtBothEnds(string);
        this.removePatternByPath(this.patterns, string2);
        for (Map.Entry<T, List<Pattern<T>>> entry : this.reverse.entrySet()) {
            List<Pattern<T>> list = entry.getValue();
            this.removePatternByPath(list, string2);
        }
    }

    private void removePatternByPath(List<Pattern<T>> list, String string) {
        Iterator<Pattern<T>> iterator = list.iterator();
        while (iterator.hasNext()) {
            Pattern<T> pattern = iterator.next();
            if (!pattern.path().equals(string)) continue;
            iterator.remove();
        }
    }

    public Routed<T> route(String string) {
        String[] stringArray = Pattern.removeSlashAtBothEnds(string).split("/");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean bl = true;
        for (Pattern<T> pattern : this.patterns) {
            String string2;
            String[] stringArray2 = pattern.tokens();
            T t = pattern.target();
            bl = true;
            hashMap.clear();
            if (stringArray.length == stringArray2.length) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    String string3 = stringArray[i];
                    string2 = stringArray2[i];
                    if (string2.length() > 0 && string2.charAt(0) == ':') {
                        hashMap.put(string2.substring(1), string3);
                        continue;
                    }
                    if (string2.equals(string3)) continue;
                    bl = false;
                    break;
                }
            } else if (stringArray2.length > 0 && stringArray2[stringArray2.length - 1].equals(":*") && stringArray.length >= stringArray2.length) {
                for (int i = 0; i < stringArray2.length - 1; ++i) {
                    String string4 = stringArray[i];
                    string2 = stringArray2[i];
                    if (string2.length() > 0 && string2.charAt(0) == ':') {
                        hashMap.put(string2.substring(1), string4);
                        continue;
                    }
                    if (string4.equals(string4)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    StringBuilder stringBuilder = new StringBuilder(stringArray[stringArray2.length - 1]);
                    for (int i = stringArray2.length; i < stringArray.length; ++i) {
                        stringBuilder.append('/');
                        stringBuilder.append(stringArray[i]);
                    }
                    hashMap.put("*", stringBuilder.toString());
                }
            } else {
                bl = false;
            }
            if (!bl) continue;
            return new Routed<T>(t, false, hashMap);
        }
        if (this.notFound != null) {
            hashMap.clear();
            return new Routed<T>(this.notFound, true, hashMap);
        }
        return null;
    }

    public String path(T t, Object ... objectArray) {
        if (objectArray.length == 0) {
            return this.path(t, Collections.emptyMap());
        }
        if (objectArray.length == 1 && objectArray[0] instanceof Map) {
            return this.pathMap(t, (Map)objectArray[0]);
        }
        if (objectArray.length % 2 == 1) {
            throw new RuntimeException("Missing value for param: " + objectArray[objectArray.length - 1]);
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (int i = 0; i < objectArray.length; i += 2) {
            String string = objectArray[i].toString();
            String string2 = objectArray[i + 1].toString();
            hashMap.put(string, string2);
        }
        return this.pathMap(t, hashMap);
    }

    private String pathMap(T t, Map<Object, Object> map) {
        List<Pattern<T>> list;
        List<Pattern<T>> list2 = list = t instanceof Class ? this.getPatternsByTargetClass((Class)t) : this.reverse.get(t);
        if (list == null) {
            return null;
        }
        try {
            String string = null;
            int n = Integer.MAX_VALUE;
            boolean bl = true;
            HashSet<String> hashSet = new HashSet<String>();
            for (Pattern<T> pattern : list) {
                int n2;
                Object object;
                String string2;
                bl = true;
                hashSet.clear();
                StringBuilder stringBuilder = new StringBuilder();
                for (String string3 : pattern.tokens()) {
                    stringBuilder.append('/');
                    if (string3.length() > 0 && string3.charAt(0) == ':') {
                        string2 = string3.substring(1);
                        object = map.get(string2);
                        if (object == null) {
                            bl = false;
                            break;
                        }
                        hashSet.add(string2);
                        stringBuilder.append(object.toString());
                        continue;
                    }
                    stringBuilder.append(string3);
                }
                if (!bl || (n2 = map.size() - hashSet.size()) >= n) continue;
                if (n2 > 0) {
                    int n3 = 1;
                    for (Map.Entry<Object, Object> entry : map.entrySet()) {
                        string2 = entry.getKey().toString();
                        if (hashSet.contains(string2)) continue;
                        if (n3 != 0) {
                            stringBuilder.append('?');
                            n3 = 0;
                        } else {
                            stringBuilder.append('&');
                        }
                        object = entry.getValue().toString();
                        stringBuilder.append(URLEncoder.encode(string2, "UTF-8"));
                        stringBuilder.append('=');
                        stringBuilder.append(URLEncoder.encode((String)object, "UTF-8"));
                    }
                }
                string = stringBuilder.toString();
                n = n2;
            }
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private List<Pattern<T>> getPatternsByTargetClass(Class<?> clazz) {
        ArrayList arrayList = null;
        for (Map.Entry<T, List<Pattern<T>>> entry : this.reverse.entrySet()) {
            Class<?> clazz2;
            T t = entry.getKey();
            boolean bl = false;
            if (t == clazz) {
                bl = true;
            } else if (!(t instanceof Class) && clazz.isAssignableFrom(clazz2 = t.getClass())) {
                bl = true;
            }
            if (!bl) continue;
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            arrayList.addAll(entry.getValue());
        }
        return arrayList;
    }
}

