/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.router;

import io.netty.handler.codec.http.router.OrderlessRouter;
import io.netty.handler.codec.http.router.Path;
import io.netty.handler.codec.http.router.RouteResult;
import io.netty.util.internal.StringUtil;

final class MethodlessRouter<T> {
    private final OrderlessRouter<T> first = new OrderlessRouter();
    private final OrderlessRouter<T> other = new OrderlessRouter();
    private final OrderlessRouter<T> last = new OrderlessRouter();

    MethodlessRouter() {
    }

    public OrderlessRouter<T> first() {
        return this.first;
    }

    public OrderlessRouter<T> other() {
        return this.other;
    }

    public OrderlessRouter<T> last() {
        return this.last;
    }

    public int size() {
        return this.first.routes().size() + this.other.routes().size() + this.last.routes().size();
    }

    public MethodlessRouter<T> addRouteFirst(String string, T t) {
        this.first.addRoute(string, t);
        return this;
    }

    public MethodlessRouter<T> addRoute(String string, T t) {
        this.other.addRoute(string, t);
        return this;
    }

    public MethodlessRouter<T> addRouteLast(String string, T t) {
        this.last.addRoute(string, t);
        return this;
    }

    public void removePath(String string) {
        this.first.removePath(string);
        this.other.removePath(string);
        this.last.removePath(string);
    }

    public void removeTarget(T t) {
        this.first.removeTarget(t);
        this.other.removeTarget(t);
        this.last.removeTarget(t);
    }

    public RouteResult<T> route(String string) {
        return this.route(StringUtil.split((String)Path.removeSlashesAtBothEnds(string), (char)'/'));
    }

    public RouteResult<T> route(String[] stringArray) {
        RouteResult<T> routeResult = this.first.route(stringArray);
        if (routeResult != null) {
            return routeResult;
        }
        routeResult = this.other.route(stringArray);
        if (routeResult != null) {
            return routeResult;
        }
        routeResult = this.last.route(stringArray);
        if (routeResult != null) {
            return routeResult;
        }
        return null;
    }

    public boolean anyMatched(String[] stringArray) {
        return this.first.anyMatched(stringArray) || this.other.anyMatched(stringArray) || this.last.anyMatched(stringArray);
    }

    public String path(T t, Object ... objectArray) {
        String string = this.first.path(t, objectArray);
        if (string != null) {
            return string;
        }
        string = this.other.path(t, objectArray);
        if (string != null) {
            return string;
        }
        return this.last.path(t, objectArray);
    }
}

