/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.router;

import io.netty.handler.codec.http.router.Path;
import io.netty.handler.codec.http.router.RouteResult;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class OrderlessRouter<T> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(OrderlessRouter.class);
    private final Map<Path, T> routes = new HashMap<Path, T>();
    private final Map<T, Set<Path>> reverseRoutes = new HashMap<T, Set<Path>>();

    OrderlessRouter() {
    }

    public Map<Path, T> routes() {
        return Collections.unmodifiableMap(this.routes);
    }

    public OrderlessRouter<T> addRoute(String string, T t) {
        Path path = new Path(string);
        if (this.routes.containsKey(string)) {
            return this;
        }
        this.routes.put(path, t);
        this.addReverseRoute(t, path);
        return this;
    }

    private void addReverseRoute(T t, Path path) {
        Set<Path> set = this.reverseRoutes.get(t);
        if (set == null) {
            set = new HashSet<Path>();
            set.add(path);
            this.reverseRoutes.put(t, set);
        } else {
            set.add(path);
        }
    }

    public void removePath(String string) {
        Path path = new Path(string);
        T t = this.routes.remove(path);
        if (t == null) {
            return;
        }
        Set<Path> set = this.reverseRoutes.remove(t);
        set.remove(path);
    }

    public void removeTarget(T t) {
        Set<Path> set = this.reverseRoutes.remove(ObjectUtil.checkNotNull(t, (String)"target"));
        if (set == null) {
            return;
        }
        for (Path path : set) {
            this.routes.remove(path);
        }
    }

    public RouteResult<T> route(String string) {
        return this.route(StringUtil.split((String)Path.removeSlashesAtBothEnds(string), (char)'/'));
    }

    public RouteResult<T> route(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<Path, T> entry : this.routes.entrySet()) {
            Path path = entry.getKey();
            if (path.match(stringArray, hashMap)) {
                T t = entry.getValue();
                return new RouteResult<T>(t, hashMap, Collections.<String, List<String>>emptyMap());
            }
            hashMap.clear();
        }
        return null;
    }

    public boolean anyMatched(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Path path : this.routes.keySet()) {
            if (path.match(stringArray, hashMap)) {
                return true;
            }
            hashMap.clear();
        }
        return false;
    }

    public String path(T t, Object ... objectArray) {
        if (objectArray.length == 0) {
            return this.path(t, Collections.emptyMap());
        }
        if (objectArray.length == 1 && objectArray[0] instanceof Map) {
            return this.pathMap(t, (Map)objectArray[0]);
        }
        if (objectArray.length % 2 == 1) {
            throw new IllegalArgumentException("Missing value for param: " + objectArray[objectArray.length - 1]);
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(objectArray.length / 2);
        for (int i = 0; i < objectArray.length; i += 2) {
            String string = objectArray[i].toString();
            String string2 = objectArray[i + 1].toString();
            hashMap.put(string, string2);
        }
        return this.pathMap(t, hashMap);
    }

    private String pathMap(T t, Map<Object, Object> map) {
        Set<Path> set = this.reverseRoutes.get(t);
        if (set == null) {
            return null;
        }
        try {
            String string = null;
            int n = Integer.MAX_VALUE;
            boolean bl = true;
            HashSet<String> hashSet = new HashSet<String>();
            for (Path path : set) {
                int n2;
                Object object;
                String string2;
                bl = true;
                hashSet.clear();
                int n3 = path.path().length() + 20 * map.size() + 16;
                StringBuilder stringBuilder = new StringBuilder(n3);
                for (String string3 : path.tokens()) {
                    stringBuilder.append('/');
                    if (string3.length() > 0 && string3.charAt(0) == ':') {
                        string2 = string3.substring(1);
                        object = map.get(string2);
                        if (object == null) {
                            bl = false;
                            break;
                        }
                        hashSet.add(string2);
                        stringBuilder.append(object.toString());
                        continue;
                    }
                    stringBuilder.append(string3);
                }
                if (!bl || (n2 = map.size() - hashSet.size()) >= n) continue;
                if (n2 > 0) {
                    int n4 = 1;
                    for (Map.Entry<Object, Object> entry : map.entrySet()) {
                        string2 = entry.getKey().toString();
                        if (hashSet.contains(string2)) continue;
                        if (n4 != 0) {
                            stringBuilder.append('?');
                            n4 = 0;
                        } else {
                            stringBuilder.append('&');
                        }
                        object = entry.getValue().toString();
                        stringBuilder.append(URLEncoder.encode(string2, "UTF-8"));
                        stringBuilder.append('=');
                        stringBuilder.append(URLEncoder.encode((String)object, "UTF-8"));
                    }
                }
                string = stringBuilder.toString();
                n = n2;
            }
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.warn("Params can't be UTF-8 encoded: " + map);
            return null;
        }
    }
}

