/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.router;

import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.util.Map;

final class Path {
    private final String path;
    private final String[] tokens;

    public static String removeSlashesAtBothEnds(String string) {
        int n;
        int n2;
        ObjectUtil.checkNotNull((Object)string, (String)"path");
        if (string.isEmpty()) {
            return string;
        }
        for (n2 = 0; n2 < string.length() && string.charAt(n2) == '/'; ++n2) {
        }
        if (n2 == string.length()) {
            return "";
        }
        for (n = string.length() - 1; n > n2 && string.charAt(n) == '/'; --n) {
        }
        return string.substring(n2, n + 1);
    }

    public Path(String string) {
        this.path = Path.removeSlashesAtBothEnds((String)ObjectUtil.checkNotNull((Object)string, (String)"path"));
        this.tokens = StringUtil.split((String)this.path, (char)'/');
    }

    public String path() {
        return this.path;
    }

    public String[] tokens() {
        return this.tokens;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return ((Path)object).path.equals(this.path);
    }

    public boolean match(String[] stringArray, Map<String, String> map) {
        if (this.tokens.length == stringArray.length) {
            for (int i = 0; i < this.tokens.length; ++i) {
                String string = this.tokens[i];
                String string2 = stringArray[i];
                if (string.length() > 0 && string.charAt(0) == ':') {
                    map.put(string.substring(1), string2);
                    continue;
                }
                if (string.equals(string2)) continue;
                return false;
            }
            return true;
        }
        if (this.tokens.length > 0 && this.tokens[this.tokens.length - 1].equals(":*") && this.tokens.length <= stringArray.length) {
            for (int i = 0; i < this.tokens.length - 2; ++i) {
                String string = this.tokens[i];
                String string3 = stringArray[i];
                if (string.length() > 0 && string.charAt(0) == ':') {
                    map.put(string.substring(1), string3);
                    continue;
                }
                if (string.equals(string3)) continue;
                return false;
            }
            StringBuilder stringBuilder = new StringBuilder(stringArray[this.tokens.length - 1]);
            for (int i = this.tokens.length; i < stringArray.length; ++i) {
                stringBuilder.append('/');
                stringBuilder.append(stringArray[i]);
            }
            map.put("*", stringBuilder.toString());
            return true;
        }
        return false;
    }
}

