/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.router;

import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RouteResult<T> {
    private final T target;
    private final Map<String, String> pathParams;
    private final Map<String, List<String>> queryParams;

    public RouteResult(T t, Map<String, String> map, Map<String, List<String>> map2) {
        this.target = ObjectUtil.checkNotNull(t, (String)"target");
        this.pathParams = Collections.unmodifiableMap((Map)ObjectUtil.checkNotNull(map, (String)"pathParams"));
        this.queryParams = Collections.unmodifiableMap((Map)ObjectUtil.checkNotNull(map2, (String)"queryParams"));
    }

    public T target() {
        return this.target;
    }

    public Map<String, String> pathParams() {
        return this.pathParams;
    }

    public Map<String, List<String>> queryParams() {
        return this.queryParams;
    }

    public String queryParam(String string) {
        List<String> list = this.queryParams.get(string);
        return list == null ? null : list.get(0);
    }

    public String param(String string) {
        String string2 = this.pathParams.get(string);
        return string2 == null ? this.queryParam(string) : string2;
    }

    public List<String> params(String string) {
        List<String> list = this.queryParams.get(string);
        String string2 = this.pathParams.get(string);
        if (list == null) {
            return string2 == null ? Collections.emptyList() : Arrays.asList(string2);
        }
        if (string2 == null) {
            return Collections.unmodifiableList(list);
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size() + 1);
        arrayList.addAll(list);
        arrayList.add(string2);
        return Collections.unmodifiableList(arrayList);
    }
}

