/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.router;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.router.MethodlessRouter;
import io.netty.handler.codec.http.router.Path;
import io.netty.handler.codec.http.router.RouteResult;
import io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Router<T> {
    private final Map<HttpMethod, MethodlessRouter<T>> routers = new HashMap<HttpMethod, MethodlessRouter<T>>();
    private final MethodlessRouter<T> anyMethodRouter = new MethodlessRouter();
    private T notFound;

    public T notFound() {
        return this.notFound;
    }

    public int size() {
        int n = this.anyMethodRouter.size();
        for (MethodlessRouter<T> methodlessRouter : this.routers.values()) {
            n += methodlessRouter.size();
        }
        return n;
    }

    public Router addRouteFirst(HttpMethod httpMethod, String string, T t) {
        this.getMethodlessRouter(httpMethod).addRouteFirst(string, t);
        return this;
    }

    public Router addRoute(HttpMethod httpMethod, String string, T t) {
        this.getMethodlessRouter(httpMethod).addRoute(string, t);
        return this;
    }

    public Router addRouteLast(HttpMethod httpMethod, String string, T t) {
        this.getMethodlessRouter(httpMethod).addRouteLast(string, t);
        return this;
    }

    public Router notFound(T t) {
        this.notFound = t;
        return this;
    }

    private MethodlessRouter<T> getMethodlessRouter(HttpMethod httpMethod) {
        if (httpMethod == null) {
            return this.anyMethodRouter;
        }
        MethodlessRouter<T> methodlessRouter = this.routers.get(httpMethod);
        if (methodlessRouter == null) {
            methodlessRouter = new MethodlessRouter();
            this.routers.put(httpMethod, methodlessRouter);
        }
        return methodlessRouter;
    }

    public void removePath(String string) {
        for (MethodlessRouter<T> methodlessRouter : this.routers.values()) {
            methodlessRouter.removePath(string);
        }
        this.anyMethodRouter.removePath(string);
    }

    public void removeTarget(T t) {
        for (MethodlessRouter<T> methodlessRouter : this.routers.values()) {
            methodlessRouter.removeTarget(t);
        }
        this.anyMethodRouter.removeTarget(t);
    }

    public RouteResult<T> route(HttpMethod httpMethod, String string) {
        RouteResult<T> routeResult;
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(string);
        String[] stringArray = StringUtil.split((String)Path.removeSlashesAtBothEnds(queryStringDecoder.path()), (char)'/');
        MethodlessRouter<T> methodlessRouter = this.routers.get(httpMethod);
        if (methodlessRouter == null) {
            methodlessRouter = this.anyMethodRouter;
        }
        if ((routeResult = methodlessRouter.route(stringArray)) != null) {
            return new RouteResult<T>(routeResult.target(), routeResult.pathParams(), queryStringDecoder.parameters());
        }
        if (methodlessRouter != this.anyMethodRouter && (routeResult = this.anyMethodRouter.route(stringArray)) != null) {
            return new RouteResult<T>(routeResult.target(), routeResult.pathParams(), queryStringDecoder.parameters());
        }
        if (this.notFound != null) {
            return new RouteResult<T>(this.notFound, new HashMap<String, String>(), queryStringDecoder.parameters());
        }
        return null;
    }

    public Set<HttpMethod> allowedMethods(String string) {
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(string);
        String[] stringArray = StringUtil.split((String)Path.removeSlashesAtBothEnds(queryStringDecoder.path()), (char)'/');
        if (this.anyMethodRouter.anyMatched(stringArray)) {
            return this.allAllowedMethods();
        }
        HashSet<HttpMethod> hashSet = new HashSet<HttpMethod>(this.routers.size());
        for (Map.Entry<HttpMethod, MethodlessRouter<T>> entry : this.routers.entrySet()) {
            MethodlessRouter<T> methodlessRouter = entry.getValue();
            if (!methodlessRouter.anyMatched(stringArray)) continue;
            HttpMethod httpMethod = entry.getKey();
            hashSet.add(httpMethod);
        }
        return hashSet;
    }

    public Set<HttpMethod> allAllowedMethods() {
        if (this.anyMethodRouter.size() > 0) {
            HashSet<HttpMethod> hashSet = new HashSet<HttpMethod>(9);
            hashSet.add(HttpMethod.CONNECT);
            hashSet.add(HttpMethod.DELETE);
            hashSet.add(HttpMethod.GET);
            hashSet.add(HttpMethod.HEAD);
            hashSet.add(HttpMethod.OPTIONS);
            hashSet.add(HttpMethod.PATCH);
            hashSet.add(HttpMethod.POST);
            hashSet.add(HttpMethod.PUT);
            hashSet.add(HttpMethod.TRACE);
            return hashSet;
        }
        return new HashSet<HttpMethod>(this.routers.keySet());
    }

    public String path(HttpMethod httpMethod, T t, Object ... objectArray) {
        String string;
        MethodlessRouter<T> methodlessRouter;
        MethodlessRouter<T> methodlessRouter2 = methodlessRouter = httpMethod == null ? this.anyMethodRouter : this.routers.get(httpMethod);
        if (methodlessRouter == null) {
            methodlessRouter = this.anyMethodRouter;
        }
        if ((string = methodlessRouter.path(t, objectArray)) != null) {
            return string;
        }
        return methodlessRouter != this.anyMethodRouter ? this.anyMethodRouter.path(t, objectArray) : null;
    }

    public String path(T t, Object ... objectArray) {
        Collection<MethodlessRouter<T>> collection = this.routers.values();
        for (MethodlessRouter<T> methodlessRouter : collection) {
            String string = methodlessRouter.path(t, objectArray);
            if (string == null) continue;
            return string;
        }
        return this.anyMethodRouter.path(t, objectArray);
    }

    public String toString() {
        Object object;
        int n = this.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        ArrayList<String> arrayList3 = new ArrayList<String>(n);
        for (Map.Entry<HttpMethod, MethodlessRouter<T>> entry : this.routers.entrySet()) {
            object = entry.getKey();
            MethodlessRouter<T> methodlessRouter = entry.getValue();
            Router.aggregateRoutes(object.toString(), methodlessRouter.first().routes(), arrayList, arrayList2, arrayList3);
            Router.aggregateRoutes(object.toString(), methodlessRouter.other().routes(), arrayList, arrayList2, arrayList3);
            Router.aggregateRoutes(object.toString(), methodlessRouter.last().routes(), arrayList, arrayList2, arrayList3);
        }
        Router.aggregateRoutes("*", this.anyMethodRouter.first().routes(), arrayList, arrayList2, arrayList3);
        Router.aggregateRoutes("*", this.anyMethodRouter.other().routes(), arrayList, arrayList2, arrayList3);
        Router.aggregateRoutes("*", this.anyMethodRouter.last().routes(), arrayList, arrayList2, arrayList3);
        if (this.notFound != null) {
            arrayList.add("*");
            arrayList2.add("*");
            arrayList3.add(Router.targetToString(this.notFound));
        }
        int n2 = Router.maxLength(arrayList);
        int n3 = Router.maxLength(arrayList2);
        object = "%-" + n2 + "s  %-" + n3 + "s  %s\n";
        int n4 = (n2 + 1 + n3 + 1 + 20) * arrayList.size();
        StringBuilder stringBuilder = new StringBuilder(n4);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            String string2 = (String)arrayList2.get(i);
            String string3 = (String)arrayList3.get(i);
            stringBuilder.append(String.format((String)object, string, string2, string3));
        }
        return stringBuilder.toString();
    }

    private static <T> void aggregateRoutes(String string, Map<Path, T> map, List<String> list, List<String> list2, List<String> list3) {
        for (Map.Entry<Path, T> entry : map.entrySet()) {
            list.add(string);
            list2.add("/" + entry.getKey().path());
            list3.add(Router.targetToString(entry.getValue()));
        }
    }

    private static int maxLength(List<String> list) {
        int n = 0;
        for (String string : list) {
            int n2 = string.length();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private static String targetToString(Object object) {
        if (object instanceof Class) {
            String string = ((Class)object).getName();
            return string;
        }
        return object.toString();
    }

    public Router CONNECT(String string, T t) {
        return this.addRoute(HttpMethod.CONNECT, string, t);
    }

    public Router DELETE(String string, T t) {
        return this.addRoute(HttpMethod.DELETE, string, t);
    }

    public Router GET(String string, T t) {
        return this.addRoute(HttpMethod.GET, string, t);
    }

    public Router HEAD(String string, T t) {
        return this.addRoute(HttpMethod.HEAD, string, t);
    }

    public Router OPTIONS(String string, T t) {
        return this.addRoute(HttpMethod.OPTIONS, string, t);
    }

    public Router PATCH(String string, T t) {
        return this.addRoute(HttpMethod.PATCH, string, t);
    }

    public Router POST(String string, T t) {
        return this.addRoute(HttpMethod.POST, string, t);
    }

    public Router PUT(String string, T t) {
        return this.addRoute(HttpMethod.PUT, string, t);
    }

    public Router TRACE(String string, T t) {
        return this.addRoute(HttpMethod.TRACE, string, t);
    }

    public Router ANY(String string, T t) {
        return this.addRoute(null, string, t);
    }

    public Router CONNECT_FIRST(String string, T t) {
        return this.addRouteFirst(HttpMethod.CONNECT, string, t);
    }

    public Router DELETE_FIRST(String string, T t) {
        return this.addRouteFirst(HttpMethod.DELETE, string, t);
    }

    public Router GET_FIRST(String string, T t) {
        return this.addRouteFirst(HttpMethod.GET, string, t);
    }

    public Router HEAD_FIRST(String string, T t) {
        return this.addRouteFirst(HttpMethod.HEAD, string, t);
    }

    public Router OPTIONS_FIRST(String string, T t) {
        return this.addRouteFirst(HttpMethod.OPTIONS, string, t);
    }

    public Router PATCH_FIRST(String string, T t) {
        return this.addRouteFirst(HttpMethod.PATCH, string, t);
    }

    public Router POST_FIRST(String string, T t) {
        return this.addRouteFirst(HttpMethod.POST, string, t);
    }

    public Router PUT_FIRST(String string, T t) {
        return this.addRouteFirst(HttpMethod.PUT, string, t);
    }

    public Router TRACE_FIRST(String string, T t) {
        return this.addRouteFirst(HttpMethod.TRACE, string, t);
    }

    public Router ANY_FIRST(String string, T t) {
        return this.addRouteFirst(null, string, t);
    }

    public Router CONNECT_LAST(String string, T t) {
        return this.addRouteLast(HttpMethod.CONNECT, string, t);
    }

    public Router DELETE_LAST(String string, T t) {
        return this.addRouteLast(HttpMethod.DELETE, string, t);
    }

    public Router GET_LAST(String string, T t) {
        return this.addRouteLast(HttpMethod.GET, string, t);
    }

    public Router HEAD_LAST(String string, T t) {
        return this.addRouteLast(HttpMethod.HEAD, string, t);
    }

    public Router OPTIONS_LAST(String string, T t) {
        return this.addRouteLast(HttpMethod.OPTIONS, string, t);
    }

    public Router PATCH_LAST(String string, T t) {
        return this.addRouteLast(HttpMethod.PATCH, string, t);
    }

    public Router POST_LAST(String string, T t) {
        return this.addRouteLast(HttpMethod.POST, string, t);
    }

    public Router PUT_LAST(String string, T t) {
        return this.addRouteLast(HttpMethod.PUT, string, t);
    }

    public Router TRACE_LAST(String string, T t) {
        return this.addRouteLast(HttpMethod.TRACE, string, t);
    }

    public Router ANY_LAST(String string, T t) {
        return this.addRouteLast(null, string, t);
    }
}

