/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.NotSslRecordException;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import javax.net.ssl.SSLException;

@ChannelHandler.Sharable
public class BadClientSilencer
extends SimpleChannelInboundHandler<Object> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(BadClientSilencer.class);

    protected void onUnknownMessage(Object object) {
        log.warn("Unknown msg: " + object);
    }

    protected void onBadClient(Throwable throwable) {
        log.warn("Caught exception (maybe client is bad)", throwable);
    }

    protected void onBadServer(Throwable throwable) {
        log.warn("Caught exception (maybe server is bad)", throwable);
    }

    public void channelRead0(ChannelHandlerContext channelHandlerContext, Object object) {
        channelHandlerContext.close();
        if (object != LastHttpContent.EMPTY_LAST_CONTENT) {
            this.onUnknownMessage(object);
        }
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        channelHandlerContext.close();
        if (throwable instanceof IOException || throwable instanceof ClosedChannelException || throwable instanceof DecoderException || throwable instanceof CorruptedFrameException || throwable instanceof IllegalArgumentException || throwable instanceof SSLException || throwable instanceof NotSslRecordException) {
            this.onBadClient(throwable);
        } else {
            this.onBadServer(throwable);
        }
    }
}

