/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.router;

import io.netty.handler.codec.http.router.PathPattern;
import io.netty.handler.codec.http.router.RouteResult;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class OrderlessRouter<T> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(OrderlessRouter.class);
    private final Map<PathPattern, T> routes = new HashMap<PathPattern, T>();
    private final Map<T, Set<PathPattern>> reverseRoutes = new HashMap<T, Set<PathPattern>>();

    OrderlessRouter() {
    }

    public Map<PathPattern, T> routes() {
        return Collections.unmodifiableMap(this.routes);
    }

    public OrderlessRouter<T> addRoute(String string, T t) {
        PathPattern pathPattern = new PathPattern(string);
        if (this.routes.containsKey(pathPattern)) {
            return this;
        }
        this.routes.put(pathPattern, t);
        this.addReverseRoute(t, pathPattern);
        return this;
    }

    private void addReverseRoute(T t, PathPattern pathPattern) {
        Set<PathPattern> set = this.reverseRoutes.get(t);
        if (set == null) {
            set = new HashSet<PathPattern>();
            set.add(pathPattern);
            this.reverseRoutes.put(t, set);
        } else {
            set.add(pathPattern);
        }
    }

    public void removePathPattern(String string) {
        PathPattern pathPattern = new PathPattern(string);
        T t = this.routes.remove(pathPattern);
        if (t == null) {
            return;
        }
        Set<PathPattern> set = this.reverseRoutes.remove(t);
        set.remove(pathPattern);
    }

    public void removeTarget(T t) {
        Set<PathPattern> set = this.reverseRoutes.remove(ObjectUtil.checkNotNull(t, (String)"target"));
        if (set == null) {
            return;
        }
        for (PathPattern pathPattern : set) {
            this.routes.remove(pathPattern);
        }
    }

    public RouteResult<T> route(String string, String string2, String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<PathPattern, T> entry : this.routes.entrySet()) {
            PathPattern pathPattern = entry.getKey();
            if (pathPattern.match(stringArray, hashMap)) {
                T t = entry.getValue();
                return new RouteResult<T>(string, string2, hashMap, Collections.<String, List<String>>emptyMap(), t);
            }
            hashMap.clear();
        }
        return null;
    }

    public boolean anyMatched(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (PathPattern pathPattern : this.routes.keySet()) {
            if (pathPattern.match(stringArray, hashMap)) {
                return true;
            }
            hashMap.clear();
        }
        return false;
    }

    public String uri(T t, Object ... objectArray) {
        if (objectArray.length == 0) {
            return this.uri(t, Collections.emptyMap());
        }
        if (objectArray.length == 1 && objectArray[0] instanceof Map) {
            return this.pathMap(t, (Map)objectArray[0]);
        }
        if (objectArray.length % 2 == 1) {
            throw new IllegalArgumentException("Missing value for param: " + objectArray[objectArray.length - 1]);
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(objectArray.length / 2);
        for (int i = 0; i < objectArray.length; i += 2) {
            String string = objectArray[i].toString();
            String string2 = objectArray[i + 1].toString();
            hashMap.put(string, string2);
        }
        return this.pathMap(t, hashMap);
    }

    private String pathMap(T t, Map<Object, Object> map) {
        Set<PathPattern> set = this.reverseRoutes.get(t);
        if (set == null) {
            return null;
        }
        try {
            String string = null;
            int n = Integer.MAX_VALUE;
            boolean bl = true;
            HashSet<String> hashSet = new HashSet<String>();
            for (PathPattern pathPattern : set) {
                int n2;
                Object object;
                String string2;
                bl = true;
                hashSet.clear();
                int n3 = pathPattern.pattern().length() + 20 * map.size() + 16;
                StringBuilder stringBuilder = new StringBuilder(n3);
                for (String string3 : pathPattern.tokens()) {
                    stringBuilder.append('/');
                    if (string3.length() > 0 && string3.charAt(0) == ':') {
                        string2 = string3.substring(1);
                        object = map.get(string2);
                        if (object == null) {
                            bl = false;
                            break;
                        }
                        hashSet.add(string2);
                        stringBuilder.append(object.toString());
                        continue;
                    }
                    stringBuilder.append(string3);
                }
                if (!bl || (n2 = map.size() - hashSet.size()) >= n) continue;
                if (n2 > 0) {
                    int n4 = 1;
                    for (Map.Entry<Object, Object> entry : map.entrySet()) {
                        string2 = entry.getKey().toString();
                        if (hashSet.contains(string2)) continue;
                        if (n4 != 0) {
                            stringBuilder.append('?');
                            n4 = 0;
                        } else {
                            stringBuilder.append('&');
                        }
                        object = entry.getValue().toString();
                        stringBuilder.append(URLEncoder.encode(string2, "UTF-8"));
                        stringBuilder.append('=');
                        stringBuilder.append(URLEncoder.encode((String)object, "UTF-8"));
                    }
                }
                string = stringBuilder.toString();
                n = n2;
            }
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.warn("Params can't be UTF-8 encoded: " + map);
            return null;
        }
    }
}

