/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.router;

import io.netty.util.internal.ObjectUtil;
import java.util.Map;

final class PathPattern {
    private final String pattern;
    private final String[] tokens;

    public static String removeSlashesAtBothEnds(String string) {
        int n;
        int n2;
        ObjectUtil.checkNotNull((Object)string, (String)"path");
        if (string.isEmpty()) {
            return string;
        }
        for (n2 = 0; n2 < string.length() && string.charAt(n2) == '/'; ++n2) {
        }
        if (n2 == string.length()) {
            return "";
        }
        for (n = string.length() - 1; n > n2 && string.charAt(n) == '/'; --n) {
        }
        return string.substring(n2, n + 1);
    }

    public PathPattern(String string) {
        if (string.contains("?")) {
            throw new IllegalArgumentException("Path pattern must not contain query");
        }
        this.pattern = PathPattern.removeSlashesAtBothEnds((String)ObjectUtil.checkNotNull((Object)string, (String)"pattern"));
        this.tokens = this.pattern.split("/");
    }

    public String pattern() {
        return this.pattern;
    }

    public String[] tokens() {
        return this.tokens;
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PathPattern)) {
            return false;
        }
        PathPattern pathPattern = (PathPattern)object;
        return this.pattern.equals(pathPattern.pattern);
    }

    public boolean match(String[] stringArray, Map<String, String> map) {
        if (this.tokens.length == stringArray.length) {
            for (int i = 0; i < this.tokens.length; ++i) {
                String string = this.tokens[i];
                String string2 = stringArray[i];
                if (string.length() > 0 && string.charAt(0) == ':') {
                    map.put(string.substring(1), string2);
                    continue;
                }
                if (string.equals(string2)) continue;
                return false;
            }
            return true;
        }
        if (this.tokens.length > 0 && this.tokens[this.tokens.length - 1].equals(":*") && this.tokens.length <= stringArray.length) {
            for (int i = 0; i < this.tokens.length - 2; ++i) {
                String string = this.tokens[i];
                String string3 = stringArray[i];
                if (string.length() > 0 && string.charAt(0) == ':') {
                    map.put(string.substring(1), string3);
                    continue;
                }
                if (string.equals(string3)) continue;
                return false;
            }
            StringBuilder stringBuilder = new StringBuilder(stringArray[this.tokens.length - 1]);
            for (int i = this.tokens.length; i < stringArray.length; ++i) {
                stringBuilder.append('/');
                stringBuilder.append(stringArray[i]);
            }
            map.put("*", stringBuilder.toString());
            return true;
        }
        return false;
    }
}

