/*
 * Decompiled with CFR 0.152.
 */
package tv.mycujoo.mcls.di;

import android.content.Context;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import javax.inject.Provider;
import kotlinx.coroutines.CoroutineScope;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;
import tv.mycujoo.domain.repository.EventsRepository;
import tv.mycujoo.mcls.api.MLS;
import tv.mycujoo.mcls.api.MLSBuilder;
import tv.mycujoo.mcls.core.InternalBuilder;
import tv.mycujoo.mcls.core.InternalBuilder_MembersInjector;
import tv.mycujoo.mcls.data.IDataManager;
import tv.mycujoo.mcls.di.AppModule;
import tv.mycujoo.mcls.di.AppModule_ProvideCoroutineScopeFactory;
import tv.mycujoo.mcls.di.AppModule_ProvideDataManagerFactory;
import tv.mycujoo.mcls.di.AppModule_ProvidePrefManagerFactory;
import tv.mycujoo.mcls.di.MlsComponent;
import tv.mycujoo.mcls.di.NetworkModule;
import tv.mycujoo.mcls.di.NetworkModule_ProvideContextFactory;
import tv.mycujoo.mcls.di.NetworkModule_ProvideMlsApiFactory;
import tv.mycujoo.mcls.di.NetworkModule_ProvideMlsApiRetrofitFactory;
import tv.mycujoo.mcls.di.NetworkModule_ProvideOkHttpFactory;
import tv.mycujoo.mcls.di.RepositoryModule;
import tv.mycujoo.mcls.di.RepositoryModule_ProvideEventsRepositoryFactory;
import tv.mycujoo.mcls.manager.IPrefManager;
import tv.mycujoo.mcls.network.MlsApi;
import tv.mycujoo.mcls.tv.api.MLSTvInternalBuilder;
import tv.mycujoo.mcls.tv.api.MLSTvInternalBuilder_MembersInjector;

public final class DaggerMlsComponent
implements MlsComponent {
    private Provider<Context> provideContextProvider;
    private Provider<IPrefManager> providePrefManagerProvider;
    private Provider<OkHttpClient> provideOkHttpProvider;
    private Provider<Retrofit> provideMlsApiRetrofitProvider;
    private Provider<MlsApi> provideMlsApiProvider;
    private Provider<EventsRepository> provideEventsRepositoryProvider;
    private Provider<CoroutineScope> provideCoroutineScopeProvider;
    private Provider<IDataManager> provideDataManagerProvider;

    private DaggerMlsComponent(AppModule appModuleParam, NetworkModule networkModuleParam, RepositoryModule repositoryModuleParam) {
        this.initialize(appModuleParam, networkModuleParam, repositoryModuleParam);
    }

    public static Builder builder() {
        return new Builder();
    }

    private void initialize(AppModule appModuleParam, NetworkModule networkModuleParam, RepositoryModule repositoryModuleParam) {
        this.provideContextProvider = DoubleCheck.provider((Provider)NetworkModule_ProvideContextFactory.create(networkModuleParam));
        this.providePrefManagerProvider = DoubleCheck.provider((Provider)AppModule_ProvidePrefManagerFactory.create(appModuleParam, this.provideContextProvider));
        this.provideOkHttpProvider = DoubleCheck.provider((Provider)NetworkModule_ProvideOkHttpFactory.create(networkModuleParam, this.providePrefManagerProvider));
        this.provideMlsApiRetrofitProvider = DoubleCheck.provider((Provider)NetworkModule_ProvideMlsApiRetrofitFactory.create(networkModuleParam, this.provideOkHttpProvider));
        this.provideMlsApiProvider = DoubleCheck.provider((Provider)NetworkModule_ProvideMlsApiFactory.create(networkModuleParam, this.provideMlsApiRetrofitProvider));
        this.provideEventsRepositoryProvider = DoubleCheck.provider((Provider)RepositoryModule_ProvideEventsRepositoryFactory.create(repositoryModuleParam, this.provideMlsApiProvider));
        this.provideCoroutineScopeProvider = DoubleCheck.provider((Provider)AppModule_ProvideCoroutineScopeFactory.create(appModuleParam));
        this.provideDataManagerProvider = DoubleCheck.provider((Provider)AppModule_ProvideDataManagerFactory.create(appModuleParam, this.provideCoroutineScopeProvider, this.provideEventsRepositoryProvider, this.provideMlsApiProvider));
    }

    @Override
    public void inject(MLS MLS2) {
    }

    @Override
    public void inject(MLSBuilder MLS2) {
    }

    @Override
    public void inject(InternalBuilder internalBuilder) {
        this.injectInternalBuilder(internalBuilder);
    }

    @Override
    public void inject(MLSTvInternalBuilder mlsTvInternalBuilder) {
        this.injectMLSTvInternalBuilder(mlsTvInternalBuilder);
    }

    private InternalBuilder injectInternalBuilder(InternalBuilder instance) {
        InternalBuilder_MembersInjector.injectEventsRepository(instance, (EventsRepository)this.provideEventsRepositoryProvider.get());
        InternalBuilder_MembersInjector.injectDispatcher(instance, (CoroutineScope)this.provideCoroutineScopeProvider.get());
        InternalBuilder_MembersInjector.injectOkHttpClient(instance, (OkHttpClient)this.provideOkHttpProvider.get());
        InternalBuilder_MembersInjector.injectDataManager(instance, (IDataManager)this.provideDataManagerProvider.get());
        InternalBuilder_MembersInjector.injectPrefManager(instance, (IPrefManager)this.providePrefManagerProvider.get());
        return instance;
    }

    private MLSTvInternalBuilder injectMLSTvInternalBuilder(MLSTvInternalBuilder instance) {
        MLSTvInternalBuilder_MembersInjector.injectEventsRepository(instance, (EventsRepository)this.provideEventsRepositoryProvider.get());
        MLSTvInternalBuilder_MembersInjector.injectDispatcher(instance, (CoroutineScope)this.provideCoroutineScopeProvider.get());
        MLSTvInternalBuilder_MembersInjector.injectOkHttpClient(instance, (OkHttpClient)this.provideOkHttpProvider.get());
        MLSTvInternalBuilder_MembersInjector.injectDataManager(instance, (IDataManager)this.provideDataManagerProvider.get());
        MLSTvInternalBuilder_MembersInjector.injectPrefManager(instance, (IPrefManager)this.providePrefManagerProvider.get());
        return instance;
    }

    public static final class Builder {
        private AppModule appModule;
        private NetworkModule networkModule;
        private RepositoryModule repositoryModule;

        private Builder() {
        }

        public Builder appModule(AppModule appModule) {
            this.appModule = (AppModule)Preconditions.checkNotNull((Object)appModule);
            return this;
        }

        public Builder networkModule(NetworkModule networkModule) {
            this.networkModule = (NetworkModule)Preconditions.checkNotNull((Object)networkModule);
            return this;
        }

        public Builder repositoryModule(RepositoryModule repositoryModule) {
            this.repositoryModule = (RepositoryModule)Preconditions.checkNotNull((Object)repositoryModule);
            return this;
        }

        public MlsComponent build() {
            if (this.appModule == null) {
                this.appModule = new AppModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.networkModule, NetworkModule.class);
            if (this.repositoryModule == null) {
                this.repositoryModule = new RepositoryModule();
            }
            return new DaggerMlsComponent(this.appModule, this.networkModule, this.repositoryModule);
        }
    }
}

