/*
 * Decompiled with CFR 0.152.
 */
package tv.mycujoo.mcls.player;

import android.content.Context;
import android.os.Handler;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.source.DefaultMediaSourceFactory;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSourceFactory;
import com.google.android.exoplayer2.util.Util;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.mycujoo.mcls.ima.IIma;
import tv.mycujoo.mcls.ima.ImaCustomParams;
import tv.mycujoo.mcls.player.IPlayer;
import tv.mycujoo.mcls.player.MediaDatum;
import tv.mycujoo.mcls.player.MediaFactory;
import tv.mycujoo.mcls.player.MediaOnLoadCompletedListener;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 :2\u00020\u0001:\u0001:B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J2\u0010\u001a\u001a\u00020\u00172\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u001b\u001a\u00020\u0012H\u0016J\b\u0010\u001c\u001a\u00020\u0012H\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0016J\b\u0010\u001e\u001a\u00020\u0012H\u0016J\b\u0010\u001f\u001a\u00020\u0012H\u0016J\b\u0010 \u001a\u00020\u0012H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\b\u0010%\u001a\u00020\u0010H\u0016J\b\u0010&\u001a\u00020\u0010H\u0016J\b\u0010'\u001a\u00020\u0010H\u0016J\b\u0010(\u001a\u00020\u0010H\u0016J\u0017\u0010)\u001a\u0004\u0018\u00010\u00102\u0006\u0010*\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020\u0017H\u0016J\b\u0010-\u001a\u00020\u0017H\u0016J\b\u0010.\u001a\u00020\u0017H\u0016J\u0018\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0010H\u0002J\u0010\u0010.\u001a\u00020\u00172\u0006\u00102\u001a\u000203H\u0016J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010\t\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u00106\u001a\u00020\u0017H\u0016J\u0010\u00107\u001a\u00020\u00172\u0006\u00108\u001a\u00020\u0012H\u0016J\b\u00109\u001a\u00020\u0017H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Ltv/mycujoo/mcls/player/Player;", "Ltv/mycujoo/mcls/player/IPlayer;", "()V", "exoPlayer", "Lcom/google/android/exoplayer2/SimpleExoPlayer;", "handler", "Landroid/os/Handler;", "ima", "Ltv/mycujoo/mcls/ima/IIma;", "mediaData", "Ltv/mycujoo/mcls/player/MediaDatum;", "mediaFactory", "Ltv/mycujoo/mcls/player/MediaFactory;", "mediaOnLoadCompletedListener", "Ltv/mycujoo/mcls/player/MediaOnLoadCompletedListener;", "playWhenReady", "", "playbackPosition", "", "resumePosition", "resumeWindow", "", "addListener", "", "eventListener", "Lcom/google/android/exoplayer2/Player$EventListener;", "create", "currentAbsoluteTime", "currentPosition", "destroy", "duration", "dvrWindowSize", "dvrWindowStartTime", "getDirectInstance", "Lcom/google/android/exoplayer2/ExoPlayer;", "getPlayer", "Lcom/google/android/exoplayer2/Player;", "isLive", "isPlaying", "isPlayingAd", "isReady", "isWithinValidSegment", "targetAbsoluteTime", "(J)Ljava/lang/Boolean;", "loadLastVideo", "pause", "play", "mediaItem", "Lcom/google/android/exoplayer2/MediaItem;", "autoPlay", "drmMediaData", "Ltv/mycujoo/mcls/player/MediaDatum$DRMMediaData;", "Ltv/mycujoo/mcls/player/MediaDatum$MediaData;", "reInit", "release", "seekTo", "offset", "updateResumePosition", "Companion", "mls_release"})
public final class Player
implements IPlayer {
    private SimpleExoPlayer exoPlayer;
    private IIma ima;
    private MediaFactory mediaFactory;
    private Handler handler;
    private MediaOnLoadCompletedListener mediaOnLoadCompletedListener;
    private long resumePosition = -1;
    private int resumeWindow = -1;
    private boolean playWhenReady;
    private long playbackPosition = -1L;
    private MediaDatum mediaData;
    public static final Companion Companion = new Companion(null);

    @Override
    public void create(@Nullable IIma ima, @NotNull MediaFactory mediaFactory, @NotNull SimpleExoPlayer exoPlayer, @NotNull Handler handler, @NotNull MediaOnLoadCompletedListener mediaOnLoadCompletedListener) {
        Intrinsics.checkParameterIsNotNull((Object)mediaFactory, (String)"mediaFactory");
        Intrinsics.checkParameterIsNotNull((Object)exoPlayer, (String)"exoPlayer");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        Intrinsics.checkParameterIsNotNull((Object)mediaOnLoadCompletedListener, (String)"mediaOnLoadCompletedListener");
        this.ima = ima;
        this.mediaFactory = mediaFactory;
        this.exoPlayer = exoPlayer;
        this.handler = handler;
        this.mediaOnLoadCompletedListener = mediaOnLoadCompletedListener;
    }

    @Override
    public void reInit(@NotNull SimpleExoPlayer exoPlayer) {
        Intrinsics.checkParameterIsNotNull((Object)exoPlayer, (String)"exoPlayer");
        this.exoPlayer = exoPlayer;
        this.mediaOnLoadCompletedListener = new MediaOnLoadCompletedListener(exoPlayer);
    }

    @Override
    public boolean isReady() {
        return this.exoPlayer != null;
    }

    @Override
    @Nullable
    public ExoPlayer getDirectInstance() {
        return (ExoPlayer)this.exoPlayer;
    }

    @Override
    @Nullable
    public com.google.android.exoplayer2.Player getPlayer() {
        return (com.google.android.exoplayer2.Player)this.exoPlayer;
    }

    @Override
    public void addListener(@NotNull Player.EventListener eventListener) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)eventListener, (String)"eventListener");
            SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
            if (simpleExoPlayer == null) break block0;
            simpleExoPlayer.addListener(eventListener);
        }
    }

    @Override
    public void seekTo(long offset) {
        block0: {
            SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
            if (simpleExoPlayer == null) break block0;
            simpleExoPlayer.seekTo(offset);
        }
    }

    @Override
    public long currentPosition() {
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        return simpleExoPlayer != null ? simpleExoPlayer.getCurrentPosition() : -1L;
    }

    @Override
    public long currentAbsoluteTime() {
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer != null) {
            long dvrWindowStartTime;
            SimpleExoPlayer simpleExoPlayer2 = simpleExoPlayer;
            boolean bl = false;
            boolean bl2 = false;
            SimpleExoPlayer exoplayer = simpleExoPlayer2;
            boolean bl3 = false;
            MediaOnLoadCompletedListener mediaOnLoadCompletedListener = this.mediaOnLoadCompletedListener;
            if (mediaOnLoadCompletedListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mediaOnLoadCompletedListener");
            }
            if ((dvrWindowStartTime = mediaOnLoadCompletedListener.getWindowStartTime()) == -1L) {
                return -1L;
            }
            return dvrWindowStartTime + exoplayer.getCurrentPosition();
        }
        return -1L;
    }

    @Override
    public long duration() {
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        return simpleExoPlayer != null ? simpleExoPlayer.getDuration() : -1L;
    }

    @Override
    public boolean isLive() {
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer != null) {
            SimpleExoPlayer simpleExoPlayer2 = simpleExoPlayer;
            boolean bl = false;
            boolean bl2 = false;
            SimpleExoPlayer it = simpleExoPlayer2;
            boolean bl3 = false;
            return it.isCurrentWindowDynamic() && it.getContentPosition() != 0L;
        }
        return false;
    }

    @Override
    public boolean isPlaying() {
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer != null) {
            SimpleExoPlayer simpleExoPlayer2 = simpleExoPlayer;
            boolean bl = false;
            boolean bl2 = false;
            SimpleExoPlayer it = simpleExoPlayer2;
            boolean bl3 = false;
            return it.isPlaying();
        }
        return false;
    }

    @Override
    public boolean isPlayingAd() {
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer != null) {
            SimpleExoPlayer simpleExoPlayer2 = simpleExoPlayer;
            boolean bl = false;
            boolean bl2 = false;
            SimpleExoPlayer it = simpleExoPlayer2;
            boolean bl3 = false;
            return it.isPlayingAd();
        }
        return false;
    }

    private final void updateResumePosition() {
        long l;
        if (this.exoPlayer == null) {
            return;
        }
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer == null) {
            Intrinsics.throwNpe();
        }
        this.resumeWindow = simpleExoPlayer.getCurrentWindowIndex();
        SimpleExoPlayer simpleExoPlayer2 = this.exoPlayer;
        if (simpleExoPlayer2 == null) {
            Intrinsics.throwNpe();
        }
        if (simpleExoPlayer2.isCurrentWindowSeekable()) {
            SimpleExoPlayer simpleExoPlayer3 = this.exoPlayer;
            if (simpleExoPlayer3 == null) {
                Intrinsics.throwNpe();
            }
            l = Math.max(0L, simpleExoPlayer3.getCurrentPosition());
        } else {
            l = -1;
        }
        this.resumePosition = l;
    }

    @Override
    public void release() {
        block0: {
            SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
            if (simpleExoPlayer == null) break block0;
            SimpleExoPlayer simpleExoPlayer2 = simpleExoPlayer;
            boolean bl = false;
            boolean bl2 = false;
            SimpleExoPlayer it = simpleExoPlayer2;
            boolean bl3 = false;
            this.updateResumePosition();
            this.playWhenReady = it.getPlayWhenReady();
            this.playbackPosition = it.getCurrentPosition();
            it.release();
            this.exoPlayer = null;
        }
    }

    @Override
    public void destroy() {
        this.resumePosition = -1;
        this.resumeWindow = -1;
        this.playWhenReady = false;
        this.playbackPosition = -1L;
        this.mediaData = null;
    }

    @Override
    public void play(@NotNull MediaDatum.DRMMediaData drmMediaData) {
        Intrinsics.checkParameterIsNotNull((Object)drmMediaData, (String)"drmMediaData");
        this.mediaData = drmMediaData;
        MediaItem mediaItem = new MediaItem.Builder().setDrmUuid(Util.getDrmUuid((String)"widevine")).setDrmLicenseUri(drmMediaData.getLicenseUrl()).setUri(drmMediaData.getFullUrl()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)mediaItem, (String)"MediaItem.Builder()\n    \u2026Url)\n            .build()");
        MediaItem mediaItem2 = mediaItem;
        this.play(mediaItem2, drmMediaData.getAutoPlay());
    }

    @Override
    public void play(@NotNull MediaDatum.MediaData mediaData) {
        Intrinsics.checkParameterIsNotNull((Object)mediaData, (String)"mediaData");
        this.mediaData = mediaData;
        MediaFactory mediaFactory = this.mediaFactory;
        if (mediaFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mediaFactory");
        }
        MediaItem mediaItem = mediaFactory.createMediaItem(mediaData.getFullUrl());
        this.play(mediaItem, mediaData.getAutoPlay());
    }

    private final void play(MediaItem mediaItem, boolean autoPlay) {
        block18: {
            block17: {
                boolean haveResumePosition;
                if (this.playbackPosition != -1L) {
                    SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
                    if (simpleExoPlayer == null) {
                        Intrinsics.throwNpe();
                    }
                    simpleExoPlayer.seekTo(this.playbackPosition);
                }
                boolean bl = haveResumePosition = this.resumeWindow != -1;
                if (!haveResumePosition) break block17;
                SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
                if (simpleExoPlayer == null) break block18;
                SimpleExoPlayer simpleExoPlayer2 = simpleExoPlayer;
                boolean bl2 = false;
                boolean bl3 = false;
                SimpleExoPlayer it = simpleExoPlayer2;
                boolean bl4 = false;
                it.seekTo(this.resumeWindow, this.resumePosition);
                SimpleExoPlayer simpleExoPlayer3 = this.exoPlayer;
                if (simpleExoPlayer3 != null) {
                    SimpleExoPlayer simpleExoPlayer4 = simpleExoPlayer3;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    SimpleExoPlayer it2 = simpleExoPlayer4;
                    boolean bl7 = false;
                    MediaFactory mediaFactory = this.mediaFactory;
                    if (mediaFactory == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mediaFactory");
                    }
                    MediaSource hlsMediaSource = mediaFactory.createHlsMediaSource(mediaItem);
                    Handler handler = this.handler;
                    if (handler == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"handler");
                    }
                    MediaOnLoadCompletedListener mediaOnLoadCompletedListener = this.mediaOnLoadCompletedListener;
                    if (mediaOnLoadCompletedListener == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mediaOnLoadCompletedListener");
                    }
                    hlsMediaSource.addEventListener(handler, (MediaSourceEventListener)mediaOnLoadCompletedListener);
                    if (this.ima != null) {
                        IIma iIma = this.ima;
                        if (iIma == null) {
                            Intrinsics.throwNpe();
                        }
                        MediaFactory mediaFactory2 = this.mediaFactory;
                        if (mediaFactory2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"mediaFactory");
                        }
                        MediaDatum mediaDatum = this.mediaData;
                        MediaDatum mediaDatum2 = this.mediaData;
                        MediaDatum mediaDatum3 = this.mediaData;
                        MediaSource adsMediaSource = iIma.createMediaSource(mediaFactory2.getDefaultMediaSourceFactory(), hlsMediaSource, new ImaCustomParams(mediaDatum != null ? mediaDatum.getEventId() : null, mediaDatum2 != null ? mediaDatum2.getStreamId() : null, mediaDatum3 != null ? mediaDatum3.getEventStatus() : null));
                        it2.setMediaSource(adsMediaSource, false);
                    } else {
                        it2.setMediaSource(hlsMediaSource, false);
                    }
                    it2.prepare();
                    it2.setPlayWhenReady(autoPlay);
                    this.resumePosition = -1;
                    this.resumeWindow = -1;
                }
                break block18;
            }
            SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
            if (simpleExoPlayer == null) break block18;
            SimpleExoPlayer simpleExoPlayer5 = simpleExoPlayer;
            boolean bl = false;
            boolean bl8 = false;
            SimpleExoPlayer it = simpleExoPlayer5;
            boolean bl9 = false;
            MediaFactory mediaFactory = this.mediaFactory;
            if (mediaFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mediaFactory");
            }
            MediaSource hlsMediaSource = mediaFactory.createHlsMediaSource(mediaItem);
            Handler handler = this.handler;
            if (handler == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"handler");
            }
            MediaOnLoadCompletedListener mediaOnLoadCompletedListener = this.mediaOnLoadCompletedListener;
            if (mediaOnLoadCompletedListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mediaOnLoadCompletedListener");
            }
            hlsMediaSource.addEventListener(handler, (MediaSourceEventListener)mediaOnLoadCompletedListener);
            if (this.ima != null) {
                IIma iIma = this.ima;
                if (iIma == null) {
                    Intrinsics.throwNpe();
                }
                MediaFactory mediaFactory3 = this.mediaFactory;
                if (mediaFactory3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mediaFactory");
                }
                MediaDatum mediaDatum = this.mediaData;
                MediaDatum mediaDatum4 = this.mediaData;
                MediaDatum mediaDatum5 = this.mediaData;
                MediaSource adsMediaSource = iIma.createMediaSource(mediaFactory3.getDefaultMediaSourceFactory(), hlsMediaSource, new ImaCustomParams(mediaDatum != null ? mediaDatum.getEventId() : null, mediaDatum4 != null ? mediaDatum4.getStreamId() : null, mediaDatum5 != null ? mediaDatum5.getEventStatus() : null));
                it.setMediaSource(adsMediaSource, true);
            } else {
                it.setMediaSource(hlsMediaSource, true);
            }
            it.prepare();
            it.setPlayWhenReady(autoPlay);
        }
    }

    @Override
    public void play() {
        block0: {
            SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
            if (simpleExoPlayer == null) break block0;
            SimpleExoPlayer simpleExoPlayer2 = simpleExoPlayer;
            boolean bl = false;
            boolean bl2 = false;
            SimpleExoPlayer it = simpleExoPlayer2;
            boolean bl3 = false;
            it.setPlayWhenReady(true);
        }
    }

    @Override
    public void pause() {
        block0: {
            SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
            if (simpleExoPlayer == null) break block0;
            SimpleExoPlayer simpleExoPlayer2 = simpleExoPlayer;
            boolean bl = false;
            boolean bl2 = false;
            SimpleExoPlayer it = simpleExoPlayer2;
            boolean bl3 = false;
            it.setPlayWhenReady(false);
        }
    }

    @Override
    public void loadLastVideo() {
        block2: {
            MediaDatum mediaDatum;
            MediaDatum it;
            block3: {
                MediaDatum mediaDatum2 = this.mediaData;
                if (mediaDatum2 == null) break block2;
                MediaDatum mediaDatum3 = mediaDatum2;
                boolean bl = false;
                boolean bl2 = false;
                it = mediaDatum3;
                boolean bl3 = false;
                mediaDatum = this.mediaData;
                if (!(mediaDatum instanceof MediaDatum.MediaData)) break block3;
                MediaDatum mediaDatum4 = it;
                if (mediaDatum4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type tv.mycujoo.mcls.player.MediaDatum.MediaData");
                }
                this.play((MediaDatum.MediaData)mediaDatum4);
                break block2;
            }
            if (!(mediaDatum instanceof MediaDatum.DRMMediaData)) break block2;
            MediaDatum mediaDatum5 = it;
            if (mediaDatum5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type tv.mycujoo.mcls.player.MediaDatum.DRMMediaData");
            }
            this.play((MediaDatum.DRMMediaData)mediaDatum5);
        }
    }

    @Override
    @Nullable
    public Boolean isWithinValidSegment(long targetAbsoluteTime) {
        boolean bl;
        block6: {
            if (this.exoPlayer == null) {
                return null;
            }
            if (targetAbsoluteTime == -1L) {
                return null;
            }
            MediaOnLoadCompletedListener mediaOnLoadCompletedListener = this.mediaOnLoadCompletedListener;
            if (mediaOnLoadCompletedListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mediaOnLoadCompletedListener");
            }
            Iterable $this$none$iv = mediaOnLoadCompletedListener.getDiscontinuityBoundaries();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    if (!(((Number)it.getFirst()).longValue() <= targetAbsoluteTime && ((Number)it.getFirst()).longValue() + ((Number)it.getSecond()).longValue() >= targetAbsoluteTime)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public long dvrWindowSize() {
        MediaDatum mediaDatum = this.mediaData;
        return mediaDatum != null ? mediaDatum.getDvrWindowSize() : -1L;
    }

    @Override
    public long dvrWindowStartTime() {
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer != null) {
            SimpleExoPlayer simpleExoPlayer2 = simpleExoPlayer;
            boolean bl = false;
            boolean bl2 = false;
            SimpleExoPlayer $noName_0 = simpleExoPlayer2;
            boolean bl3 = false;
            MediaOnLoadCompletedListener mediaOnLoadCompletedListener = this.mediaOnLoadCompletedListener;
            if (mediaOnLoadCompletedListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mediaOnLoadCompletedListener");
            }
            return mediaOnLoadCompletedListener.getWindowStartTime();
        }
        return -1L;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"Ltv/mycujoo/mcls/player/Player$Companion;", "", "()V", "createDefaultMediaSourceFactory", "Lcom/google/android/exoplayer2/source/DefaultMediaSourceFactory;", "context", "Landroid/content/Context;", "createExoPlayer", "Lcom/google/android/exoplayer2/SimpleExoPlayer;", "createMediaFactory", "Lcom/google/android/exoplayer2/source/hls/HlsMediaSource$Factory;", "mls_release"})
    public static final class Companion {
        @NotNull
        public final SimpleExoPlayer createExoPlayer(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            SimpleExoPlayer simpleExoPlayer = new SimpleExoPlayer.Builder(context).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleExoPlayer, (String)"SimpleExoPlayer.Builder(context).build()");
            return simpleExoPlayer;
        }

        @NotNull
        public final HlsMediaSource.Factory createMediaFactory(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            return new HlsMediaSource.Factory((DataSource.Factory)new DefaultHttpDataSourceFactory(Util.getUserAgent((Context)context, (String)"mls")));
        }

        @NotNull
        public final DefaultMediaSourceFactory createDefaultMediaSourceFactory(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            return new DefaultMediaSourceFactory(context);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

