/*
 * Decompiled with CFR 0.152.
 */
package tv.mycujoo.mcls.tv.internal.presenter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Build;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.leanback.widget.Action;
import androidx.leanback.widget.ControlButtonPresenterSelector;
import androidx.leanback.widget.ObjectAdapter;
import androidx.leanback.widget.OnActionClickedListener;
import androidx.leanback.widget.PlaybackControlsRow;
import androidx.leanback.widget.PlaybackRowPresenter;
import androidx.leanback.widget.PlaybackSeekDataProvider;
import androidx.leanback.widget.PlaybackSeekUi;
import androidx.leanback.widget.Presenter;
import androidx.leanback.widget.RowPresenter;
import java.util.Arrays;
import tv.mycujoo.mcls.R;
import tv.mycujoo.mcls.api.MLSTVConfiguration;
import tv.mycujoo.mcls.entity.msc.TVVideoPlayerConfig;
import tv.mycujoo.mcls.manager.TvTimelineMarkerManager;
import tv.mycujoo.mcls.tv.internal.controller.ControllerAgent;
import tv.mycujoo.mcls.tv.internal.presenter.MLSControlBarPresenter;
import tv.mycujoo.mcls.tv.internal.presenter.MLSPlaybackControlPresenter;
import tv.mycujoo.mcls.tv.widgets.MLSPlaybackTransportRowView;
import tv.mycujoo.mcls.tv.widgets.MLSSeekBar;
import tv.mycujoo.mcls.tv.widgets.MLSThumbsBar;
import tv.mycujoo.mcls.widgets.MLSPlayerView;
import tv.mycujoo.mcls.widgets.mlstimebar.TimelineMarkerWidget;

public class MLSPlaybackTransportRowPresenter
extends PlaybackRowPresenter {
    private final MLSTVConfiguration config;
    private final ControllerAgent controllerAgent;
    float mDefaultSeekIncrement = 0.01f;
    int mProgressColor = 0;
    int mSecondaryProgressColor = 0;
    boolean mProgressColorSet;
    boolean mSecondaryProgressColorSet;
    Presenter mDescriptionPresenter;
    MLSControlBarPresenter mPlaybackControlsPresenter;
    MLSControlBarPresenter mSecondaryControlsPresenter;
    OnActionClickedListener mOnActionClickedListener;
    private final MLSControlBarPresenter.OnControlSelectedListener mOnControlSelectedListener = new MLSControlBarPresenter.OnControlSelectedListener(){

        @Override
        public void onControlSelected(Presenter.ViewHolder itemViewHolder, Object item, MLSControlBarPresenter.BoundData data) {
            ViewHolder vh = ((BoundData)data).mRowViewHolder;
            if (vh.mSelectedViewHolder != itemViewHolder || vh.mSelectedItem != item) {
                vh.mSelectedViewHolder = itemViewHolder;
                vh.mSelectedItem = item;
                vh.dispatchItemSelection();
            }
        }
    };
    private final MLSControlBarPresenter.OnControlClickedListener mOnControlClickedListener = new MLSControlBarPresenter.OnControlClickedListener(){

        @Override
        public void onControlClicked(Presenter.ViewHolder itemViewHolder, Object item, MLSControlBarPresenter.BoundData data) {
            ViewHolder vh = ((BoundData)data).mRowViewHolder;
            if (vh.getOnItemViewClickedListener() != null) {
                vh.getOnItemViewClickedListener().onItemClicked(itemViewHolder, item, (RowPresenter.ViewHolder)vh, (Object)vh.getRow());
            }
            if (MLSPlaybackTransportRowPresenter.this.mOnActionClickedListener != null && item instanceof Action) {
                MLSPlaybackTransportRowPresenter.this.mOnActionClickedListener.onActionClicked((Action)item);
            }
        }
    };

    static void formatTime(long ms, StringBuilder sb) {
        sb.setLength(0);
        if (ms < 0L) {
            sb.append("--");
            return;
        }
        long seconds = ms / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        seconds -= minutes * 60L;
        minutes -= hours * 60L;
        if (hours > 0L) {
            sb.append(hours).append(':');
            if (minutes < 10L) {
                sb.append('0');
            }
        }
        sb.append(minutes).append(':');
        if (seconds < 10L) {
            sb.append('0');
        }
        sb.append(seconds);
    }

    public MLSPlaybackTransportRowPresenter(ControllerAgent controllerAgent, MLSTVConfiguration config2) {
        this.setHeaderPresenter(null);
        this.setSelectEffectEnabled(false);
        this.config = config2;
        this.controllerAgent = controllerAgent;
        this.mPlaybackControlsPresenter = new MLSControlBarPresenter(R.layout.layout_mls_control_bar);
        this.mPlaybackControlsPresenter.setDefaultFocusToMiddle(false);
        this.mSecondaryControlsPresenter = new MLSControlBarPresenter(R.layout.layout_mls_control_bar);
        this.mSecondaryControlsPresenter.setDefaultFocusToMiddle(false);
        this.mPlaybackControlsPresenter.setOnControlSelectedListener(this.mOnControlSelectedListener);
        this.mSecondaryControlsPresenter.setOnControlSelectedListener(this.mOnControlSelectedListener);
        this.mPlaybackControlsPresenter.setOnControlClickedListener(this.mOnControlClickedListener);
        this.mSecondaryControlsPresenter.setOnControlClickedListener(this.mOnControlClickedListener);
    }

    public void setDescriptionPresenter(Presenter descriptionPresenter) {
        this.mDescriptionPresenter = descriptionPresenter;
    }

    public void setOnActionClickedListener(OnActionClickedListener listener) {
        this.mOnActionClickedListener = listener;
    }

    public OnActionClickedListener getOnActionClickedListener() {
        return this.mOnActionClickedListener;
    }

    public void setProgressColor(@ColorInt int color2) {
        this.mProgressColor = color2;
        this.mProgressColorSet = true;
    }

    @ColorInt
    public int getProgressColor() {
        return this.mProgressColor;
    }

    public void setSecondaryProgressColor(@ColorInt int color2) {
        this.mSecondaryProgressColor = color2;
        this.mSecondaryProgressColorSet = true;
    }

    @ColorInt
    public int getSecondaryProgressColor() {
        return this.mSecondaryProgressColor;
    }

    public void onReappear(RowPresenter.ViewHolder rowViewHolder) {
        ViewHolder vh = (ViewHolder)rowViewHolder;
        if (vh.view.hasFocus()) {
            vh.mProgressBar.requestFocus();
        }
    }

    private static int getDefaultProgressColor(Context context) {
        TypedValue outValue = new TypedValue();
        if (context.getTheme().resolveAttribute(R.attr.playbackProgressPrimaryColor, outValue, true)) {
            return context.getResources().getColor(outValue.resourceId);
        }
        return context.getResources().getColor(R.color.lb_playback_progress_color_no_theme);
    }

    private static int getDefaultSecondaryProgressColor(Context context) {
        TypedValue outValue = new TypedValue();
        if (context.getTheme().resolveAttribute(R.attr.playbackProgressSecondaryColor, outValue, true)) {
            return context.getResources().getColor(outValue.resourceId);
        }
        return context.getResources().getColor(R.color.lb_playback_progress_secondary_color_no_theme);
    }

    protected RowPresenter.ViewHolder createRowViewHolder(ViewGroup parent) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_mls_playback_transport_controls_row, parent, false);
        ViewHolder vh = new ViewHolder(v, this.mDescriptionPresenter);
        this.initRow(vh);
        return vh;
    }

    private void initRow(final ViewHolder vh) {
        vh.mControlsVh = (MLSControlBarPresenter.ViewHolder)this.mPlaybackControlsPresenter.onCreateViewHolder(vh.mControlsDock);
        vh.mProgressBar.setProgressColor(this.mProgressColorSet ? this.mProgressColor : MLSPlaybackTransportRowPresenter.getDefaultProgressColor(vh.mControlsDock.getContext()));
        vh.mProgressBar.setSecondaryProgressColor(this.mSecondaryProgressColorSet ? this.mSecondaryProgressColor : MLSPlaybackTransportRowPresenter.getDefaultSecondaryProgressColor(vh.mControlsDock.getContext()));
        vh.mControlsDock.addView(vh.mControlsVh.view);
        vh.mSecondaryControlsVh = (MLSControlBarPresenter.ViewHolder)this.mSecondaryControlsPresenter.onCreateViewHolder(vh.mSecondaryControlsDock);
        vh.mSecondaryControlsDock.addView(vh.mSecondaryControlsVh.view);
        ((MLSPlaybackTransportRowView)vh.view.findViewById(R.id.transport_row)).setOnUnhandledKeyListener(new MLSPlaybackTransportRowView.OnUnhandledKeyListener(){

            @Override
            public boolean onUnhandledKey(KeyEvent event) {
                return vh.getOnKeyListener() != null && vh.getOnKeyListener().onKey(vh.view, event.getKeyCode(), event);
            }
        });
    }

    protected void onBindRowViewHolder(RowPresenter.ViewHolder holder, Object item) {
        super.onBindRowViewHolder(holder, item);
        ViewHolder vh = (ViewHolder)holder;
        PlaybackControlsRow row = (PlaybackControlsRow)vh.getRow();
        if (row.getItem() == null) {
            vh.mDescriptionDock.setVisibility(8);
        } else {
            vh.mDescriptionDock.setVisibility(0);
            if (vh.mDescriptionViewHolder != null) {
                this.mDescriptionPresenter.onBindViewHolder(vh.mDescriptionViewHolder, row.getItem());
            }
        }
        if (row.getImageDrawable() == null) {
            vh.mImageView.setVisibility(8);
        } else {
            vh.mImageView.setVisibility(0);
        }
        vh.mImageView.setImageDrawable(row.getImageDrawable());
        vh.mControlsBoundData.adapter = row.getPrimaryActionsAdapter();
        vh.mControlsBoundData.presenter = vh.getPresenter(true);
        vh.mControlsBoundData.mRowViewHolder = vh;
        this.mPlaybackControlsPresenter.onBindViewHolder(vh.mControlsVh, vh.mControlsBoundData);
        vh.mSecondaryBoundData.adapter = row.getSecondaryActionsAdapter();
        vh.mSecondaryBoundData.presenter = vh.getPresenter(false);
        vh.mSecondaryBoundData.mRowViewHolder = vh;
        this.mSecondaryControlsPresenter.onBindViewHolder(vh.mSecondaryControlsVh, vh.mSecondaryBoundData);
        vh.setTotalTime(row.getDuration());
        vh.setCurrentPosition(row.getCurrentPosition());
        vh.setBufferedPosition(row.getBufferedPosition());
        row.setOnPlaybackProgressChangedListener(vh.mListener);
        this.controllerAgent.addLiveBadgeStateListener(state -> this.setIsLive(state, vh.mLiveBadgeLayout));
    }

    protected void onUnbindRowViewHolder(RowPresenter.ViewHolder holder) {
        ViewHolder vh = (ViewHolder)holder;
        PlaybackControlsRow row = (PlaybackControlsRow)vh.getRow();
        if (vh.mDescriptionViewHolder != null) {
            this.mDescriptionPresenter.onUnbindViewHolder(vh.mDescriptionViewHolder);
        }
        this.mPlaybackControlsPresenter.onUnbindViewHolder(vh.mControlsVh);
        this.mSecondaryControlsPresenter.onUnbindViewHolder(vh.mSecondaryControlsVh);
        row.setOnPlaybackProgressChangedListener(null);
        super.onUnbindRowViewHolder(holder);
    }

    protected void onProgressBarClicked(ViewHolder vh) {
        if (vh != null) {
            if (vh.mPlayPauseAction == null) {
                vh.mPlayPauseAction = new PlaybackControlsRow.PlayPauseAction(vh.view.getContext());
            }
            if (vh.getOnItemViewClickedListener() != null) {
                vh.getOnItemViewClickedListener().onItemClicked((Presenter.ViewHolder)vh, (Object)vh.mPlayPauseAction, (RowPresenter.ViewHolder)vh, (Object)vh.getRow());
            }
            if (this.mOnActionClickedListener != null) {
                this.mOnActionClickedListener.onActionClicked((Action)vh.mPlayPauseAction);
            }
        }
    }

    public void setDefaultSeekIncrement(float ratio) {
        this.mDefaultSeekIncrement = ratio;
    }

    public float getDefaultSeekIncrement() {
        return this.mDefaultSeekIncrement;
    }

    protected void onRowViewSelected(RowPresenter.ViewHolder vh, boolean selected) {
        super.onRowViewSelected(vh, selected);
        if (selected) {
            ((ViewHolder)vh).dispatchItemSelection();
        }
    }

    protected void onRowViewAttachedToWindow(RowPresenter.ViewHolder vh) {
        super.onRowViewAttachedToWindow(vh);
        if (this.mDescriptionPresenter != null) {
            this.mDescriptionPresenter.onViewAttachedToWindow(((ViewHolder)vh).mDescriptionViewHolder);
        }
    }

    protected void onRowViewDetachedFromWindow(RowPresenter.ViewHolder vh) {
        super.onRowViewDetachedFromWindow(vh);
        if (this.mDescriptionPresenter != null) {
            this.mDescriptionPresenter.onViewDetachedFromWindow(((ViewHolder)vh).mDescriptionViewHolder);
        }
    }

    private void setIsLive(MLSPlayerView.LiveState state, FrameLayout liveBadgeLayout) {
        switch (state) {
            case LIVE_ON_THE_EDGE: {
                liveBadgeLayout.setFocusable(false);
                liveBadgeLayout.setVisibility(0);
                liveBadgeLayout.setBackground(ContextCompat.getDrawable((Context)liveBadgeLayout.getContext(), (int)R.drawable.bg_live));
                break;
            }
            case LIVE_TRAILING: {
                liveBadgeLayout.setFocusable(true);
                liveBadgeLayout.setVisibility(0);
                liveBadgeLayout.setBackground(ContextCompat.getDrawable((Context)liveBadgeLayout.getContext(), (int)R.drawable.selector_live_badge_button));
                break;
            }
            case VOD: {
                liveBadgeLayout.setVisibility(8);
            }
        }
    }

    public class ViewHolder
    extends PlaybackRowPresenter.ViewHolder
    implements PlaybackSeekUi {
        final Presenter.ViewHolder mDescriptionViewHolder;
        final ImageView mImageView;
        final ViewGroup mDescriptionDock;
        final ViewGroup mControlsDock;
        final ViewGroup mSecondaryControlsDock;
        final LinearLayout mTimersContainer;
        final TextView mTotalTime;
        final TextView mCurrentTime;
        final FrameLayout mSeeKBarContainer;
        final MLSSeekBar mProgressBar;
        final MLSThumbsBar mThumbsBar;
        long mTotalTimeInMs;
        long mCurrentTimeInMs;
        long mSecondaryProgressInMs;
        final StringBuilder mTempBuilder;
        MLSControlBarPresenter.ViewHolder mControlsVh;
        MLSControlBarPresenter.ViewHolder mSecondaryControlsVh;
        BoundData mControlsBoundData;
        BoundData mSecondaryBoundData;
        Presenter.ViewHolder mSelectedViewHolder;
        Object mSelectedItem;
        PlaybackControlsRow.PlayPauseAction mPlayPauseAction;
        int mThumbHeroIndex;
        PlaybackSeekUi.Client mSeekClient;
        boolean mInSeek;
        PlaybackSeekDataProvider mSeekDataProvider;
        long[] mPositions;
        int mPositionsLength;
        FrameLayout mLiveBadgeLayout;
        ConstraintLayout mViewersCountLayout;
        TextView mViewersCountTextView;
        final View mTimelineMarkerAnchor;
        final FrameLayout mTimelineMarkerBackgroundLayout;
        final TextView mTimelineMarkerTextView;
        final PlaybackControlsRow.OnPlaybackProgressCallback mListener;
        PlaybackSeekDataProvider.ResultCallback mThumbResult;

        void updateProgressInSeek(boolean forward) {
            long newPos;
            long pos = this.mCurrentTimeInMs;
            if (this.mPositionsLength > 0) {
                int thumbHeroIndex;
                int index = Arrays.binarySearch(this.mPositions, 0, this.mPositionsLength, pos);
                if (forward) {
                    if (index >= 0) {
                        if (index < this.mPositionsLength - 1) {
                            newPos = this.mPositions[index + 1];
                            thumbHeroIndex = index + 1;
                        } else {
                            newPos = this.mTotalTimeInMs;
                            thumbHeroIndex = index;
                        }
                    } else {
                        int insertIndex = -1 - index;
                        if (insertIndex <= this.mPositionsLength - 1) {
                            newPos = this.mPositions[insertIndex];
                            thumbHeroIndex = insertIndex;
                        } else {
                            newPos = this.mTotalTimeInMs;
                            thumbHeroIndex = insertIndex > 0 ? insertIndex - 1 : 0;
                        }
                    }
                } else if (index >= 0) {
                    if (index > 0) {
                        newPos = this.mPositions[index - 1];
                        thumbHeroIndex = index - 1;
                    } else {
                        newPos = 0L;
                        thumbHeroIndex = 0;
                    }
                } else {
                    int insertIndex = -1 - index;
                    if (insertIndex > 0) {
                        newPos = this.mPositions[insertIndex - 1];
                        thumbHeroIndex = insertIndex - 1;
                    } else {
                        newPos = 0L;
                        thumbHeroIndex = 0;
                    }
                }
                this.updateThumbsInSeek(thumbHeroIndex, forward);
            } else {
                long interval = (long)((float)this.mTotalTimeInMs * MLSPlaybackTransportRowPresenter.this.getDefaultSeekIncrement());
                newPos = pos + (forward ? interval : -interval);
                if (newPos > this.mTotalTimeInMs) {
                    newPos = this.mTotalTimeInMs;
                } else if (newPos < 0L) {
                    newPos = 0L;
                }
            }
            double ratio = (double)newPos / (double)this.mTotalTimeInMs;
            this.mProgressBar.setProgress((int)(ratio * 2.147483647E9));
            this.mProgressBar.setCurrentTimeBySeek(newPos);
            this.mSeekClient.onSeekPositionChanged(newPos);
        }

        void updateThumbsInSeek(int thumbHeroIndex, boolean forward) {
            int childIndex;
            int i;
            int newRequestEnd;
            int newRequestStart;
            if (this.mThumbHeroIndex == thumbHeroIndex) {
                return;
            }
            int totalNum = this.mThumbsBar.getChildCount();
            if (totalNum < 0 || (totalNum & 1) == 0) {
                throw new RuntimeException();
            }
            int heroChildIndex = totalNum / 2;
            int start = Math.max(thumbHeroIndex - totalNum / 2, 0);
            int end = Math.min(thumbHeroIndex + totalNum / 2, this.mPositionsLength - 1);
            if (this.mThumbHeroIndex < 0) {
                newRequestStart = start;
                newRequestEnd = end;
            } else {
                int i2;
                forward = thumbHeroIndex > this.mThumbHeroIndex;
                int oldStart = Math.max(this.mThumbHeroIndex - totalNum / 2, 0);
                int oldEnd = Math.min(this.mThumbHeroIndex + totalNum / 2, this.mPositionsLength - 1);
                if (forward) {
                    newRequestStart = Math.max(oldEnd + 1, start);
                    newRequestEnd = end;
                    for (i2 = start; i2 <= newRequestStart - 1; ++i2) {
                        this.mThumbsBar.setThumbBitmap(heroChildIndex + (i2 - thumbHeroIndex), this.mThumbsBar.getThumbBitmap(heroChildIndex + (i2 - this.mThumbHeroIndex)));
                    }
                } else {
                    newRequestEnd = Math.min(oldStart - 1, end);
                    newRequestStart = start;
                    for (i2 = end; i2 >= newRequestEnd + 1; --i2) {
                        this.mThumbsBar.setThumbBitmap(heroChildIndex + (i2 - thumbHeroIndex), this.mThumbsBar.getThumbBitmap(heroChildIndex + (i2 - this.mThumbHeroIndex)));
                    }
                }
            }
            this.mThumbHeroIndex = thumbHeroIndex;
            if (forward) {
                for (i = newRequestStart; i <= newRequestEnd; ++i) {
                    this.mSeekDataProvider.getThumbnail(i, this.mThumbResult);
                }
            } else {
                for (i = newRequestEnd; i >= newRequestStart; --i) {
                    this.mSeekDataProvider.getThumbnail(i, this.mThumbResult);
                }
            }
            for (childIndex = 0; childIndex < heroChildIndex - this.mThumbHeroIndex + start; ++childIndex) {
                this.mThumbsBar.setThumbBitmap(childIndex, null);
            }
            for (childIndex = heroChildIndex + end - this.mThumbHeroIndex + 1; childIndex < totalNum; ++childIndex) {
                this.mThumbsBar.setThumbBitmap(childIndex, null);
            }
        }

        boolean onForward() {
            if (!this.startSeek()) {
                return false;
            }
            this.updateProgressInSeek(true);
            return true;
        }

        boolean onBackward() {
            if (!this.startSeek()) {
                return false;
            }
            this.updateProgressInSeek(false);
            return true;
        }

        public ViewHolder(View rootView, Presenter descriptionPresenter) {
            super(rootView);
            this.mTotalTimeInMs = Long.MIN_VALUE;
            this.mCurrentTimeInMs = Long.MIN_VALUE;
            this.mTempBuilder = new StringBuilder();
            this.mControlsBoundData = new BoundData();
            this.mSecondaryBoundData = new BoundData();
            this.mThumbHeroIndex = -1;
            this.mListener = new PlaybackControlsRow.OnPlaybackProgressCallback(){

                public void onCurrentPositionChanged(PlaybackControlsRow row, long ms) {
                    ViewHolder.this.setCurrentPosition(ms);
                }

                public void onDurationChanged(PlaybackControlsRow row, long ms) {
                    ViewHolder.this.setTotalTime(ms);
                }

                public void onBufferedPositionChanged(PlaybackControlsRow row, long ms) {
                    ViewHolder.this.setBufferedPosition(ms);
                }
            };
            this.mThumbResult = new PlaybackSeekDataProvider.ResultCallback(){

                public void onThumbnailLoaded(Bitmap bitmap, int index) {
                    int childIndex = index - (ViewHolder.this.mThumbHeroIndex - ViewHolder.this.mThumbsBar.getChildCount() / 2);
                    if (childIndex < 0 || childIndex >= ViewHolder.this.mThumbsBar.getChildCount()) {
                        return;
                    }
                    ViewHolder.this.mThumbsBar.setThumbBitmap(childIndex, bitmap);
                }
            };
            this.mImageView = (ImageView)rootView.findViewById(R.id.image);
            this.mDescriptionDock = (ViewGroup)rootView.findViewById(R.id.description_dock);
            this.mCurrentTime = (TextView)rootView.findViewById(R.id.current_time);
            this.mTimersContainer = (LinearLayout)rootView.findViewById(R.id.tvController_timersContainer);
            this.mTotalTime = (TextView)rootView.findViewById(R.id.total_time);
            this.mSeeKBarContainer = (FrameLayout)rootView.findViewById(R.id.tvController_seekBarContainer);
            this.mProgressBar = (MLSSeekBar)rootView.findViewById(R.id.playback_progress);
            this.mProgressBar.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    MLSPlaybackTransportRowPresenter.this.onProgressBarClicked(ViewHolder.this);
                }
            });
            this.mProgressBar.setOnKeyListener(new View.OnKeyListener(){

                public boolean onKey(View view, int keyCode, KeyEvent keyEvent) {
                    switch (keyCode) {
                        case 19: 
                        case 20: {
                            return ViewHolder.this.mInSeek;
                        }
                        case 21: 
                        case 69: 
                        case 89: {
                            if (keyEvent.getAction() == 0) {
                                ViewHolder.this.onBackward();
                            }
                            return true;
                        }
                        case 22: 
                        case 81: 
                        case 90: {
                            if (keyEvent.getAction() == 0) {
                                ViewHolder.this.onForward();
                            }
                            return true;
                        }
                        case 23: 
                        case 66: {
                            if (!ViewHolder.this.mInSeek) {
                                return false;
                            }
                            if (keyEvent.getAction() == 1) {
                                ViewHolder.this.stopSeek(false);
                            }
                            return true;
                        }
                        case 4: 
                        case 111: {
                            if (!ViewHolder.this.mInSeek) {
                                return false;
                            }
                            if (keyEvent.getAction() == 1) {
                                ViewHolder.this.stopSeek(Build.VERSION.SDK_INT >= 21 ? !ViewHolder.this.mProgressBar.isAccessibilityFocused() : true);
                            }
                            return true;
                        }
                    }
                    return false;
                }
            });
            this.mProgressBar.setAccessibilitySeekListener(new MLSSeekBar.AccessibilitySeekListener(){

                @Override
                public boolean onAccessibilitySeekForward() {
                    return ViewHolder.this.onForward();
                }

                @Override
                public boolean onAccessibilitySeekBackward() {
                    return ViewHolder.this.onBackward();
                }
            });
            this.mProgressBar.setMax(Integer.MAX_VALUE);
            this.mControlsDock = (ViewGroup)rootView.findViewById(R.id.controls_dock);
            this.mSecondaryControlsDock = (ViewGroup)rootView.findViewById(R.id.secondary_controls_dock);
            Presenter.ViewHolder viewHolder = this.mDescriptionViewHolder = descriptionPresenter == null ? null : descriptionPresenter.onCreateViewHolder(this.mDescriptionDock);
            if (this.mDescriptionViewHolder != null) {
                this.mDescriptionDock.addView(this.mDescriptionViewHolder.view);
            }
            this.mThumbsBar = (MLSThumbsBar)rootView.findViewById(R.id.thumbs_row);
            this.mLiveBadgeLayout = (FrameLayout)rootView.findViewById(R.id.tvController_liveBadgeLayout);
            this.mLiveBadgeLayout.setOnClickListener(v -> {
                MLSPlaybackTransportRowPresenter.this.controllerAgent.setControllerLiveMode(MLSPlayerView.LiveState.LIVE_ON_THE_EDGE);
                MLSPlaybackTransportRowPresenter.this.controllerAgent.backToLive();
            });
            this.mViewersCountLayout = (ConstraintLayout)rootView.findViewById(R.id.tvController_viewersCountLayout);
            this.mViewersCountTextView = (TextView)rootView.findViewById(R.id.tvController_viewersCountTextView);
            MLSPlaybackTransportRowPresenter.this.controllerAgent.setViewerCountView(this.mViewersCountLayout, this.mViewersCountTextView);
            this.mTimelineMarkerAnchor = rootView.findViewById(R.id.tvController_timelineMarkerAnchor);
            this.mTimelineMarkerBackgroundLayout = (FrameLayout)rootView.findViewById(R.id.tvController_timelineMarkerBackgroundLayout);
            this.mTimelineMarkerTextView = (TextView)rootView.findViewById(R.id.tvController_timelineMarkerTextView);
            TimelineMarkerWidget timelineMarkerView = new TimelineMarkerWidget(this.mTimelineMarkerAnchor, this.mTimelineMarkerBackgroundLayout, this.mTimelineMarkerTextView, MLSPlaybackTransportRowPresenter.this.config.getVideoPlayerConfig().getPrimaryColor());
            TvTimelineMarkerManager tvTimelineMarkerManager = new TvTimelineMarkerManager(this.mProgressBar, timelineMarkerView);
            TVVideoPlayerConfig videoPlayerConfig = MLSPlaybackTransportRowPresenter.this.config.getVideoPlayerConfig();
            MLSPlaybackTransportRowPresenter.this.setProgressColor(Color.parseColor((String)videoPlayerConfig.getPrimaryColor()));
            if (videoPlayerConfig.getShowSeekBar()) {
                this.mSeeKBarContainer.setVisibility(0);
            } else {
                this.mSeeKBarContainer.setVisibility(8);
            }
            if (videoPlayerConfig.getShowTimers()) {
                this.mTimersContainer.setVisibility(0);
            } else {
                this.mTimersContainer.setVisibility(8);
            }
        }

        public final Presenter.ViewHolder getDescriptionViewHolder() {
            return this.mDescriptionViewHolder;
        }

        public void setPlaybackSeekUiClient(PlaybackSeekUi.Client client) {
            this.mSeekClient = client;
        }

        boolean startSeek() {
            int pos;
            if (this.mInSeek) {
                return true;
            }
            if (this.mSeekClient == null || !this.mSeekClient.isSeekEnabled() || this.mTotalTimeInMs <= 0L) {
                return false;
            }
            this.mInSeek = true;
            this.mSeekClient.onSeekStarted();
            this.mSeekDataProvider = this.mSeekClient.getPlaybackSeekDataProvider();
            long[] lArray = this.mPositions = this.mSeekDataProvider != null ? this.mSeekDataProvider.getSeekPositions() : null;
            this.mPositionsLength = this.mPositions != null ? ((pos = Arrays.binarySearch(this.mPositions, this.mTotalTimeInMs)) >= 0 ? pos + 1 : -1 - pos) : 0;
            this.mControlsVh.view.setVisibility(8);
            this.mSecondaryControlsVh.view.setVisibility(4);
            this.mDescriptionViewHolder.view.setVisibility(4);
            this.mThumbsBar.setVisibility(0);
            return true;
        }

        void stopSeek(boolean cancelled) {
            if (!this.mInSeek) {
                return;
            }
            this.mInSeek = false;
            this.mSeekClient.onSeekFinished(cancelled);
            if (this.mSeekDataProvider != null) {
                this.mSeekDataProvider.reset();
            }
            this.mThumbHeroIndex = -1;
            this.mThumbsBar.clearThumbBitmaps();
            this.mSeekDataProvider = null;
            this.mPositions = null;
            this.mPositionsLength = 0;
            this.mControlsVh.view.setVisibility(0);
            this.mSecondaryControlsVh.view.setVisibility(0);
            this.mDescriptionViewHolder.view.setVisibility(0);
            this.mThumbsBar.setVisibility(4);
        }

        void dispatchItemSelection() {
            if (!this.isSelected()) {
                return;
            }
            if (this.mSelectedViewHolder == null) {
                if (this.getOnItemViewSelectedListener() != null) {
                    this.getOnItemViewSelectedListener().onItemSelected(null, null, (RowPresenter.ViewHolder)this, (Object)this.getRow());
                }
            } else if (this.getOnItemViewSelectedListener() != null) {
                this.getOnItemViewSelectedListener().onItemSelected(this.mSelectedViewHolder, this.mSelectedItem, (RowPresenter.ViewHolder)this, (Object)this.getRow());
            }
        }

        Presenter getPresenter(boolean primary) {
            ObjectAdapter adapter;
            ObjectAdapter objectAdapter = adapter = primary ? ((PlaybackControlsRow)this.getRow()).getPrimaryActionsAdapter() : ((PlaybackControlsRow)this.getRow()).getSecondaryActionsAdapter();
            if (adapter == null) {
                return null;
            }
            if (adapter.getPresenterSelector() instanceof ControlButtonPresenterSelector) {
                ControlButtonPresenterSelector selector = (ControlButtonPresenterSelector)adapter.getPresenterSelector();
                return selector.getSecondaryPresenter();
            }
            return adapter.getPresenter(adapter.size() > 0 ? adapter.get(0) : null);
        }

        public final TextView getDurationView() {
            return this.mTotalTime;
        }

        protected void onSetDurationLabel(long totalTimeMs) {
            if (this.mTotalTime != null) {
                MLSPlaybackTransportRowPresenter.formatTime(totalTimeMs, this.mTempBuilder);
                this.mTotalTime.setText((CharSequence)this.mTempBuilder.toString());
            }
        }

        void setTotalTime(long totalTimeMs) {
            if (this.mTotalTimeInMs != totalTimeMs) {
                this.mTotalTimeInMs = totalTimeMs;
                this.onSetDurationLabel(totalTimeMs);
                this.mProgressBar.setTotalTime(totalTimeMs);
            }
        }

        public final TextView getCurrentPositionView() {
            return this.mCurrentTime;
        }

        protected void onSetCurrentPositionLabel(long currentTimeMs) {
            if (this.mCurrentTime != null) {
                MLSPlaybackTransportRowPresenter.formatTime(currentTimeMs, this.mTempBuilder);
                this.mCurrentTime.setText((CharSequence)this.mTempBuilder.toString());
            }
        }

        void setCurrentPosition(long currentTimeMs) {
            if (currentTimeMs != this.mCurrentTimeInMs) {
                this.mCurrentTimeInMs = currentTimeMs;
                this.onSetCurrentPositionLabel(currentTimeMs);
            }
            if (!this.mInSeek) {
                int progressRatio = 0;
                if (this.mTotalTimeInMs > 0L) {
                    double ratio = (double)this.mCurrentTimeInMs / (double)this.mTotalTimeInMs;
                    progressRatio = (int)(ratio * 2.147483647E9);
                }
                this.mProgressBar.setProgress(progressRatio);
            }
        }

        void setBufferedPosition(long progressMs) {
            this.mSecondaryProgressInMs = progressMs;
            double ratio = (double)progressMs / (double)this.mTotalTimeInMs;
            double progressRatio = ratio * 2.147483647E9;
            this.mProgressBar.setSecondaryProgress((int)progressRatio);
        }
    }

    static class BoundData
    extends MLSPlaybackControlPresenter.BoundData {
        ViewHolder mRowViewHolder;

        BoundData() {
        }
    }
}

