/*
 * Decompiled with CFR 0.152.
 */
package tw.cheyingwu.ckip;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import tw.cheyingwu.ckip.Term;
import tw.cheyingwu.ckip.WordSegmentationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CKIP
extends WordSegmentationService {
    private String username;
    private String password;
    private String serverIP;
    private int serverPort;
    private List<String> sentence = new ArrayList<String>();

    public CKIP(String serverIP, int serverPort, String username, String password) {
        this.username = username;
        this.password = password;
        this.serverIP = serverIP;
        this.serverPort = serverPort;
    }

    @Override
    public void send() {
        try {
            Document d = DocumentHelper.createDocument();
            Element root = d.addElement("wordsegmentation");
            root.addAttribute("version", "0.1");
            root.addElement("option").addAttribute("showcategory", "1");
            root.addElement("authentication").addAttribute("username", this.getUsername()).addAttribute("password", this.getPassword());
            root.addElement("text").addText(this.getRawText());
            Socket s = new Socket(this.serverIP, this.serverPort);
            OutputStreamWriter osw = new OutputStreamWriter(s.getOutputStream(), "Big5");
            PrintWriter pw = new PrintWriter(osw);
            pw.println(d.asXML());
            pw.flush();
            InputStreamReader isr = new InputStreamReader(s.getInputStream(), "Big5");
            BufferedReader br = new BufferedReader(isr);
            this.setReturnText(br.readLine());
            br.close();
            s.close();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String[] getSentence() {
        try {
            ArrayList<String> s = new ArrayList<String>();
            Document d = DocumentHelper.parseText((String)this.getReturnText());
            Element root = d.getRootElement();
            Iterator i = root.elementIterator("result");
            while (i.hasNext()) {
                Element n = (Element)i.next();
                Iterator j = n.elementIterator();
                while (j.hasNext()) {
                    Element element = (Element)j.next();
                    s.add(element.getText());
                }
            }
            this.sentence = s;
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return this.sentence.toArray(new String[0]);
    }

    @Override
    public List<Term> getTerm() {
        ArrayList<Term> tl = new ArrayList<Term>();
        for (String s : this.getSentence()) {
            for (String e : s.split("\u3000")) {
                if ("".equals(e)) continue;
                Term t = new Term();
                Pattern p = Pattern.compile("(\\S*)\\((\\S*)\\)");
                Matcher m = p.matcher(e);
                while (m.find()) {
                    t.setTerm(m.group(1));
                    t.setTag(m.group(2));
                }
                tl.add(t);
            }
        }
        return tl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServerIP() {
        return this.serverIP;
    }

    public void setServerIP(String serverIP) {
        this.serverIP = serverIP;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }
}

