/*
 * Decompiled with CFR 0.152.
 */
package ua.co.k.strftime;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import ua.co.k.strftime.TextToken;
import ua.co.k.strftime.Token;
import ua.co.k.strftime.ValueToken;
import ua.co.k.strftime.ZoneIdResolver;

public class StrftimeFormatter {
    private final Locale locale;
    private final List<Token> tokens;
    private final boolean strict;
    private final ZoneIdResolver zoneIdResolver;

    public StrftimeFormatter(String pattern, Locale locale, boolean strict, ZoneIdResolver zoneIdResolver) {
        Objects.requireNonNull(locale);
        this.locale = locale;
        this.strict = strict;
        this.tokens = this.parse(pattern);
        this.zoneIdResolver = zoneIdResolver;
    }

    StrftimeFormatter(List<Token> tokens, Locale locale, boolean strict, ZoneIdResolver zoneIdResolver) {
        Objects.requireNonNull(locale);
        this.locale = locale;
        this.tokens = tokens;
        this.strict = strict;
        this.zoneIdResolver = zoneIdResolver;
    }

    public static StrftimeFormatter ofSafePattern(String pattern) {
        return new StrftimeFormatter(pattern, Locale.getDefault(), false, ZoneIdResolver.DEFAULT);
    }

    public static StrftimeFormatter ofSafePattern(String pattern, Locale locale) {
        return new StrftimeFormatter(pattern, locale, false, ZoneIdResolver.DEFAULT);
    }

    public static StrftimeFormatter ofStrictPattern(String pattern) {
        return new StrftimeFormatter(pattern, Locale.getDefault(), true, ZoneIdResolver.DEFAULT);
    }

    public static StrftimeFormatter ofStrictPattern(String pattern, Locale locale) {
        return new StrftimeFormatter(pattern, locale, true, ZoneIdResolver.DEFAULT);
    }

    public StrftimeFormatter withLocale(Locale locale) {
        if (this.locale.equals(locale)) {
            return this;
        }
        return new StrftimeFormatter(this.tokens, locale, this.strict, this.zoneIdResolver);
    }

    public StrftimeFormatter withZoneIdResolver(ZoneIdResolver resolver) {
        if (this.zoneIdResolver.equals(resolver)) {
            return this;
        }
        return new StrftimeFormatter(this.tokens, this.locale, this.strict, resolver);
    }

    public String format(Object obj) {
        StringBuilder sb = new StringBuilder();
        this.formatTo(obj, sb);
        return sb.toString();
    }

    public void formatTo(Object obj, StringBuilder sb) {
        this.tokens.forEach(el -> el.render(obj, sb, this.strict, this.locale, this.zoneIdResolver));
    }

    private List<Token> parse(String in) {
        List<Integer> codepoints = in.codePoints().boxed().collect(Collectors.toList());
        ParseContext parseContext = new ParseContext(codepoints);
        ArrayList<Token> res = new ArrayList<Token>();
        while (this.moreTokens(parseContext)) {
            Token token = this.readNext(parseContext);
            res.add(token);
        }
        return res;
    }

    private Token readNext(ParseContext parseContext) {
        if (parseContext.state == ParseContext.State.TEXT) {
            return this.readNextText(parseContext);
        }
        return this.readNextValue(parseContext);
    }

    /*
     * Unable to fully structure code
     */
    private Token readNextValue(ParseContext parseContext) {
        token = new ValueToken();
        fallback = new ArrayList<Integer>();
        token.current = ValueToken.Parts.flags;
        while (parseContext.startOffset < parseContext.codepoints.size()) {
            block17: {
                block15: {
                    block16: {
                        codepoint = parseContext.codepoints.get(parseContext.startOffset);
                        fallback.add(codepoint);
                        if (token.current != ValueToken.Parts.flags) break block15;
                        if (!ValueToken.isFlag(codepoint)) break block16;
                        token.addFlag(codepoint);
                        break block17;
                    }
                    if (ValueToken.isWidth(codepoint)) {
                        token.current = ValueToken.Parts.width;
                    } else if (ValueToken.isModifier(codepoint)) {
                        token.current = ValueToken.Parts.modifier;
                    } else if (ValueToken.isConversion(codepoint)) {
                        token.current = ValueToken.Parts.conversion;
                    }
                }
                if (token.current != ValueToken.Parts.width) ** GOTO lbl31
                if (ValueToken.isWidth(codepoint)) {
                    token.addWidth(codepoint);
                } else {
                    if (ValueToken.isModifier(codepoint)) {
                        token.current = ValueToken.Parts.modifier;
                    } else if (ValueToken.isConversion(codepoint)) {
                        token.current = ValueToken.Parts.conversion;
                    }
lbl31:
                    // 5 sources

                    if (token.current == ValueToken.Parts.modifier) {
                        if (ValueToken.isModifier(codepoint)) {
                            ++parseContext.startOffset;
                            parseContext.state = ParseContext.State.TEXT;
                            return new TextToken(fallback);
                        }
                        if (ValueToken.isConversion(codepoint)) {
                            token.current = ValueToken.Parts.conversion;
                        }
                    }
                    if (token.current == ValueToken.Parts.conversion && ValueToken.isConversion(codepoint)) {
                        applied = token.applyConversion(codepoint);
                        ++parseContext.startOffset;
                        if (applied) break;
                        parseContext.state = ParseContext.State.TEXT;
                        return new TextToken(fallback);
                    }
                    ++parseContext.startOffset;
                    parseContext.state = ParseContext.State.TEXT;
                    return new TextToken(fallback);
                }
            }
            ++parseContext.startOffset;
        }
        parseContext.state = ParseContext.State.TEXT;
        return token;
    }

    private Token readNextText(ParseContext parseContext) {
        TextToken token = new TextToken();
        while (parseContext.startOffset < parseContext.codepoints.size()) {
            int codepoint = parseContext.codepoints.get(parseContext.startOffset);
            if (codepoint == 37) {
                ++parseContext.startOffset;
                if (!this.moreTokens(parseContext)) {
                    token.add(37);
                    break;
                }
                parseContext.valueStaredPosition = parseContext.startOffset - 1;
                parseContext.state = ParseContext.State.VALUE;
                break;
            }
            token.add(codepoint);
            ++parseContext.startOffset;
        }
        return token;
    }

    private boolean moreTokens(ParseContext parseContext) {
        return parseContext.codepoints.size() > parseContext.startOffset;
    }

    static class ParseContext {
        final List<Integer> codepoints;
        int startOffset = 0;
        State state = State.TEXT;
        int valueStaredPosition;

        ParseContext(List<Integer> codepoints) {
            this.codepoints = codepoints;
        }

        static enum State {
            TEXT,
            VALUE;

        }
    }
}

