/*
 * Decompiled with CFR 0.152.
 */
package ua.co.k.strftime.formatters;

import java.time.DayOfWeek;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import ua.co.k.strftime.formatters.FromTemporalFieldFormat;

class DayOfWeekFormat
extends FromTemporalFieldFormat {
    private final DayOfWeek firstDay;
    private final int startCount;

    public DayOfWeekFormat(DayOfWeek firstDay, int startCount) {
        super(ChronoField.DAY_OF_WEEK);
        this.firstDay = firstDay;
        this.startCount = startCount;
    }

    @Override
    protected Long doFormat(TemporalAccessor obj, boolean strict) {
        Long original = super.doFormat(obj, strict);
        if (original == null) {
            if (!strict) {
                return null;
            }
            Objects.requireNonNull(original);
        }
        return (7L + original - (long)this.firstDay.getValue()) % 7L + (long)this.startCount;
    }
}

