/*
 * Decompiled with CFR 0.152.
 */
package ug.sparkpl.momoapi.Utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import lombok.NonNull;
import retrofit2.HttpException;
import retrofit2.Response;
import ug.sparkpl.momoapi.models.MomoApiError;

public class Utils {
    private Utils() {
    }

    public static boolean isNull(@Nullable Object object) {
        return object == null;
    }

    public static boolean isNotNull(@Nullable Object object) {
        return object != null;
    }

    @NonNull
    public static <T> T coalesce(@Nullable T value, @NonNull T theDefault) {
        if (theDefault == null) {
            throw new NullPointerException("theDefault is marked @NonNull but is null");
        }
        if (value != null) {
            return value;
        }
        return theDefault;
    }

    @Nullable
    public static Boolean toBoolean(@Nullable String s) {
        if (s != null) {
            return Boolean.parseBoolean(s);
        }
        return null;
    }

    @Nullable
    public static Integer toInteger(@Nullable String s) {
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static String toString(@Nullable Integer n) {
        if (n != null) {
            return Integer.toString(n);
        }
        return null;
    }

    @Nullable
    public static String toString(@Nullable Long n) {
        if (n != null) {
            return Long.toString(n);
        }
        return null;
    }

    @Nullable
    public static String toString(@Nullable Float n) {
        if (n != null) {
            return Float.toString(n.floatValue());
        }
        return null;
    }

    @Nullable
    public static String toString(@Nullable Double n) {
        if (n != null) {
            return Double.toString(n);
        }
        return null;
    }

    @NonNull
    public static <T> T requireNonNull(@Nullable T value) throws NullPointerException {
        return Utils.requireNonNull(value, "Value should not be null.");
    }

    @NonNull
    public static <T> T requireNonNull(@Nullable T value, @NonNull Class<T> klass) throws NullPointerException {
        if (klass == null) {
            throw new NullPointerException("klass is marked @NonNull but is null");
        }
        return Utils.requireNonNull(value, klass.toString() + " required to be non-null.");
    }

    @NonNull
    public static <T> T requireNonNull(@Nullable T value, @NonNull String message) throws NullPointerException {
        if (message == null) {
            throw new NullPointerException("message is marked @NonNull but is null");
        }
        if (value == null) {
            throw new NullPointerException(message);
        }
        return value;
    }

    public static boolean isHttpStatusCode(Throwable throwable, int statusCode) {
        return throwable instanceof HttpException && ((HttpException)throwable).code() == statusCode;
    }

    public MomoApiError parseError(Response<JsonObject> response) {
        MomoApiError error;
        Gson gson = new Gson();
        try {
            error = (MomoApiError)gson.fromJson((JsonElement)response.body(), MomoApiError.class);
        }
        catch (JsonSyntaxException e) {
            return new MomoApiError();
        }
        return error;
    }
}

