/*
 * Decompiled with CFR 0.152.
 */
package ug.sparkpl.momoapi.network;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import lombok.NonNull;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.joda.time.DateTime;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;
import rx.Scheduler;
import rx.schedulers.Schedulers;
import ug.sparkpl.momoapi.Utils.DateTimeTypeConverter;
import ug.sparkpl.momoapi.network.collections.CollectionsApiService;

class BaseClient {
    BaseClient() {
    }

    Scheduler getScheduler() {
        return Schedulers.computation();
    }

    Gson getGson() {
        return new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(DateTime.class, (Object)new DateTimeTypeConverter()).create();
    }

    Retrofit createRetrofit(@NonNull HttpUrl apiEndpoint, @NonNull Gson gson, @NonNull OkHttpClient okHttpClient) {
        if (apiEndpoint == null) {
            throw new NullPointerException("apiEndpoint is marked @NonNull but is null");
        }
        if (gson == null) {
            throw new NullPointerException("gson is marked @NonNull but is null");
        }
        if (okHttpClient == null) {
            throw new NullPointerException("okHttpClient is marked @NonNull but is null");
        }
        return new Retrofit.Builder().client(okHttpClient).baseUrl(apiEndpoint).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).build();
    }

    HttpLoggingInterceptor getHttpLoggingInterceptor() {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
        interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        return interceptor;
    }

    CollectionsApiService provideCollectionsApiService(@NonNull Retrofit apiRetrofit) {
        if (apiRetrofit == null) {
            throw new NullPointerException("apiRetrofit is marked @NonNull but is null");
        }
        return (CollectionsApiService)apiRetrofit.create(CollectionsApiService.class);
    }

    Retrofit getApiRetrofit(@NonNull HttpUrl apiEndpoint, @NonNull Gson gson, @NonNull OkHttpClient okHttpClient) {
        if (apiEndpoint == null) {
            throw new NullPointerException("apiEndpoint is marked @NonNull but is null");
        }
        if (gson == null) {
            throw new NullPointerException("gson is marked @NonNull but is null");
        }
        if (okHttpClient == null) {
            throw new NullPointerException("okHttpClient is marked @NonNull but is null");
        }
        return this.createRetrofit(apiEndpoint, gson, okHttpClient);
    }
}

