/*
 * Decompiled with CFR 0.152.
 */
package ug.sparkpl.momoapi.network.collections;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.joda.time.DateTime;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;
import ug.sparkpl.momoapi.Utils.DateTimeTypeConverter;
import ug.sparkpl.momoapi.models.AccessToken;
import ug.sparkpl.momoapi.network.ApiException;
import ug.sparkpl.momoapi.network.RequestOptions;
import ug.sparkpl.momoapi.network.collections.CollectionSession;
import ug.sparkpl.momoapi.network.collections.CollectionsApiService;

public class CollectionsAuthorizationInterceptor
implements Interceptor {
    Logger logger;
    private CollectionsApiService apiService;
    private CollectionSession session;
    private RequestOptions opts;

    public CollectionsAuthorizationInterceptor(CollectionSession session, RequestOptions opts) {
        this.session = session;
        this.opts = opts;
        this.logger = Logger.getLogger(CollectionsAuthorizationInterceptor.class.getName());
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(DateTime.class, (Object)new DateTimeTypeConverter()).create();
        OkHttpClient.Builder okhttpbuilder = new OkHttpClient.Builder();
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
        httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.HEADERS);
        okhttpbuilder.addInterceptor((Interceptor)httpLoggingInterceptor);
        okhttpbuilder.connectTimeout(30L, TimeUnit.SECONDS);
        okhttpbuilder.readTimeout(30L, TimeUnit.SECONDS);
        okhttpbuilder.writeTimeout(30L, TimeUnit.SECONDS);
        OkHttpClient httpClient = okhttpbuilder.build();
        Retrofit retrofitClient = new Retrofit.Builder().client(httpClient).baseUrl(this.opts.getBaseUrl()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).build();
        this.apiService = (CollectionsApiService)retrofitClient.create(CollectionsApiService.class);
    }

    private Request request(Request initialRequest) {
        this.logger.log(Level.INFO, "Using token >>>>>>>>>>>>>>>>> " + this.session.getToken());
        return initialRequest.newBuilder().addHeader("Authorization", "Bearer " + this.session.getToken()).addHeader("Ocp-Apim-Subscription-Key", this.opts.getCollectionPrimaryKey()).addHeader("X-Target-Environment", this.opts.getTargetEnvironment()).method(initialRequest.method(), initialRequest.body()).build();
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response mainResponse = chain.proceed(this.request(chain.request()));
        Request mainRequest = chain.request();
        if (mainResponse.code() == 401 || mainResponse.code() == 403) {
            this.logger.log(Level.INFO, "<<<<<<<<<<<<<<<Getting Fresh Token");
            String credentials = Credentials.basic((String)this.opts.getCollectionUserId(), (String)this.opts.getCollectionApiSecret());
            retrofit2.Response loginResponse = this.apiService.getToken(credentials, this.opts.getCollectionPrimaryKey()).execute();
            if (loginResponse.isSuccessful()) {
                AccessToken token = (AccessToken)loginResponse.body();
                this.session.saveToken(token.getToken());
                Request.Builder builder = mainRequest.newBuilder().addHeader("Authorization", "Bearer " + this.session.getToken()).addHeader("Ocp-Apim-Subscription-Key", this.opts.getCollectionPrimaryKey()).addHeader("X-Target-Environment", this.opts.getTargetEnvironment()).method(mainRequest.method(), mainRequest.body());
                mainResponse = chain.proceed(builder.build());
            }
        } else if (!mainResponse.isSuccessful()) {
            this.logger.log(Level.INFO, "<<<<<<<<<<<<<<< ETETETET  " + mainResponse.code() + "  .." + mainResponse.body().string());
            throw new ApiException(mainResponse.body().string());
        }
        return mainResponse;
    }
}

