/*
 * Decompiled with CFR 0.152.
 */
package ug.sparkpl.momoapi.network.disbursements;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.joda.time.DateTime;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.converter.scalars.ScalarsConverterFactory;
import ug.sparkpl.momoapi.Utils.DateTimeTypeConverter;
import ug.sparkpl.momoapi.models.AccessToken;
import ug.sparkpl.momoapi.models.Balance;
import ug.sparkpl.momoapi.models.Transaction;
import ug.sparkpl.momoapi.models.Transfer;
import ug.sparkpl.momoapi.network.RequestOptions;
import ug.sparkpl.momoapi.network.disbursements.DisbursementsApiService;
import ug.sparkpl.momoapi.network.disbursements.DisbursementsAuthorizationInterceptor;
import ug.sparkpl.momoapi.network.disbursements.DisbursementsSession;

public class DisbursementsClient {
    RequestOptions opts;
    Gson gson;
    private DisbursementsSession session;
    private DisbursementsApiService apiService;
    private OkHttpClient httpClient;
    private Retrofit retrofitClient;

    public DisbursementsClient(RequestOptions opts) {
        this.opts = opts;
        this.gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(DateTime.class, (Object)new DateTimeTypeConverter()).create();
        this.session = new DisbursementsSession();
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
        httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.HEADERS);
        httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        OkHttpClient.Builder okhttpbuilder = new OkHttpClient.Builder();
        okhttpbuilder.addInterceptor((Interceptor)new DisbursementsAuthorizationInterceptor(this.session, this.opts));
        okhttpbuilder.addInterceptor((Interceptor)httpLoggingInterceptor);
        okhttpbuilder.connectTimeout(30L, TimeUnit.SECONDS);
        okhttpbuilder.readTimeout(30L, TimeUnit.SECONDS);
        okhttpbuilder.writeTimeout(30L, TimeUnit.SECONDS);
        this.httpClient = okhttpbuilder.build();
        this.retrofitClient = new Retrofit.Builder().client(this.httpClient).baseUrl(opts.getBaseUrl()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.gson)).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).build();
        this.apiService = (DisbursementsApiService)this.retrofitClient.create(DisbursementsApiService.class);
    }

    public AccessToken getToken() throws IOException {
        String credentials = Credentials.basic((String)this.opts.getDisbursementUserId(), (String)this.opts.getDisbursementApiSecret());
        Response token = this.apiService.getToken(credentials, this.opts.getDisbursementPrimaryKey()).execute();
        return (AccessToken)token.body();
    }

    public Balance getBalance() throws IOException {
        Response balance = this.apiService.getBalance().execute();
        return (Balance)balance.body();
    }

    public Transaction getTransactionStatus(String ref) throws IOException {
        Response transaction = this.apiService.getTransactionStatus(ref).execute();
        return (Transaction)transaction.body();
    }

    public String transfer(String mobile, String amount, String external_id, String payee_note, String payer_message, String currency) throws IOException {
        Transfer rBody = new Transfer(mobile, amount, external_id, payee_note, payer_message, currency);
        String ref = UUID.randomUUID().toString();
        this.apiService.transfer(rBody, ref).execute();
        return ref;
    }

    public String transfer(HashMap<String, String> opts) throws IOException {
        Transfer rBody = new Transfer(opts.get("mobile"), opts.get("amount"), opts.get("externalId"), opts.get("payeeNote"), opts.get("payerMessage"), opts.get("currency"));
        String ref = UUID.randomUUID().toString();
        this.apiService.transfer(rBody, ref).execute();
        return ref;
    }
}

