/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.orthography.english;

import java.util.ArrayList;
import java.util.List;
import simplenlg.features.DiscourseFunction;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.DocumentCategory;
import simplenlg.framework.DocumentElement;
import simplenlg.framework.ElementCategory;
import simplenlg.framework.ListElement;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGModule;
import simplenlg.framework.StringElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrthographyProcessor
extends NLGModule {
    private boolean commaSepPremodifiers;
    private boolean commaSepCuephrase;

    @Override
    public void initialise() {
        this.commaSepPremodifiers = true;
        this.commaSepCuephrase = false;
    }

    public boolean isCommaSepPremodifiers() {
        return this.commaSepPremodifiers;
    }

    public void setCommaSepPremodifiers(boolean commaSepPremodifiers) {
        this.commaSepPremodifiers = commaSepPremodifiers;
    }

    public boolean isCommaSepCuephrase() {
        return this.commaSepCuephrase;
    }

    public void setCommaSepCuephrase(boolean commaSepCuephrase) {
        this.commaSepCuephrase = commaSepCuephrase;
    }

    @Override
    public NLGElement realise(NLGElement element) {
        NLGElement realisedElement;
        block25: {
            ElementCategory category;
            Object function;
            block27: {
                block26: {
                    realisedElement = null;
                    function = null;
                    if (element instanceof ListElement) {
                        List<NLGElement> children = element.getChildren();
                        if (!children.isEmpty()) {
                            NLGElement firstChild = children.get(0);
                            function = firstChild.getFeature("discourse_function");
                        }
                    } else if (element != null) {
                        function = element.getFeature("discourse_function");
                    }
                    if (element == null) break block25;
                    category = element.getCategory();
                    if (!(category instanceof DocumentCategory) || !(element instanceof DocumentElement)) break block26;
                    List<NLGElement> components = ((DocumentElement)element).getComponents();
                    switch ((DocumentCategory)category) {
                        case SENTENCE: {
                            realisedElement = this.realiseSentence(components, element);
                            break;
                        }
                        case LIST_ITEM: {
                            if (components != null && components.size() > 0) {
                                realisedElement = new ListElement(this.realise(components));
                                realisedElement.setParent(element.getParent());
                                break;
                            }
                            break block27;
                        }
                        default: {
                            ((DocumentElement)element).setComponents(this.realise(components));
                            realisedElement = element;
                            break;
                        }
                    }
                    break block27;
                }
                if (element instanceof ListElement) {
                    StringBuffer buffer = new StringBuffer();
                    if (DiscourseFunction.PRE_MODIFIER.equals(function)) {
                        boolean all_appositives = true;
                        for (NLGElement child : element.getChildren()) {
                            all_appositives = all_appositives && child.getFeatureAsBoolean("appositive") != false;
                        }
                        if (all_appositives) {
                            buffer.append(", ");
                        }
                        this.realiseList(buffer, element.getChildren(), this.commaSepPremodifiers ? "," : "");
                        if (all_appositives) {
                            buffer.append(", ");
                        }
                    } else if (DiscourseFunction.POST_MODIFIER.equals(function)) {
                        List<NLGElement> postmods = element.getChildren();
                        int len = postmods.size();
                        for (int i = 0; i < len; ++i) {
                            NLGElement postmod = postmods.get(i);
                            if (postmod.getFeatureAsBoolean("appositive").booleanValue()) {
                                buffer.append(", ");
                                buffer.append(this.realise(postmod));
                                if (i >= len - 1) continue;
                                buffer.append(", ");
                                continue;
                            }
                            buffer.append(this.realise(postmod));
                            if (!(postmod instanceof ListElement) && (postmod.getRealisation() == null || postmod.getRealisation().equals(""))) continue;
                            buffer.append(" ");
                        }
                    } else if ((DiscourseFunction.CUE_PHRASE.equals(function) || DiscourseFunction.FRONT_MODIFIER.equals(function)) && this.commaSepCuephrase) {
                        this.realiseList(buffer, element.getChildren(), this.commaSepCuephrase ? "," : "");
                    } else {
                        this.realiseList(buffer, element.getChildren(), "");
                    }
                    realisedElement = new StringElement(buffer.toString());
                } else {
                    realisedElement = element instanceof CoordinatedPhraseElement ? this.realiseCoordinatedPhrase(element.getChildren()) : element;
                }
            }
            if (realisedElement != null) {
                realisedElement.setCategory(category);
            }
            if ((DiscourseFunction.CUE_PHRASE.equals(function) || DiscourseFunction.FRONT_MODIFIER.equals(function)) && this.commaSepCuephrase) {
                String realisation = realisedElement.getRealisation();
                if (!realisation.endsWith(",")) {
                    realisation = realisation + ",";
                }
                realisedElement.setRealisation(realisation);
            }
        }
        this.removePunctSpace(realisedElement);
        return realisedElement;
    }

    private void removePunctSpace(NLGElement realisedElement) {
        String realisation;
        if (realisedElement != null && (realisation = realisedElement.getRealisation()) != null) {
            realisation = realisation.replaceAll(" ,", ",");
            realisation = realisation.replaceAll(",,+", ",");
            realisedElement.setRealisation(realisation);
        }
    }

    private NLGElement realiseSentence(List<NLGElement> components, NLGElement element) {
        NLGElement realisedElement = null;
        if (components != null && components.size() > 0) {
            StringBuffer realisation = new StringBuffer();
            this.realiseList(realisation, components, "");
            this.stripLeadingCommas(realisation);
            this.capitaliseFirstLetter(realisation);
            this.terminateSentence(realisation, element.getFeatureAsBoolean("interrogative"));
            ((DocumentElement)element).clearComponents();
            element.setRealisation(realisation.toString());
            realisedElement = element;
        }
        return realisedElement;
    }

    private void terminateSentence(StringBuffer realisation, boolean interrogative) {
        char character = realisation.charAt(realisation.length() - 1);
        if (character != '.' && character != '?') {
            if (interrogative) {
                realisation.append('?');
            } else {
                realisation.append('.');
            }
        }
    }

    private void stripLeadingCommas(StringBuffer realisation) {
        char character = realisation.charAt(0);
        if (character == ' ' || character == ',') {
            realisation.deleteCharAt(0);
            this.stripLeadingCommas(realisation);
        }
    }

    private void capitaliseFirstLetter(StringBuffer realisation) {
        char character = realisation.charAt(0);
        if (character >= 'a' && character <= 'z') {
            character = (char)(65 + (character - 97));
            realisation.setCharAt(0, character);
        }
    }

    @Override
    public List<NLGElement> realise(List<NLGElement> elements) {
        ArrayList<NLGElement> realisedList = new ArrayList<NLGElement>();
        if (elements != null && elements.size() > 0) {
            for (NLGElement eachElement : elements) {
                if (eachElement instanceof DocumentElement) {
                    realisedList.add(this.realise(eachElement));
                    continue;
                }
                realisedList.add(eachElement);
            }
        }
        return realisedList;
    }

    private void realiseList(StringBuffer realisation, List<NLGElement> components, String listSeparator) {
        NLGElement realisedChild = null;
        for (int i = 0; i < components.size(); ++i) {
            NLGElement thisElement = components.get(i);
            realisedChild = this.realise(thisElement);
            String childRealisation = realisedChild.getRealisation();
            if (childRealisation == null || childRealisation.length() <= 0 || childRealisation.matches("^[\\s\\n]+$")) continue;
            realisation.append(realisedChild.getRealisation());
            if (components.size() > 1 && i < components.size() - 1) {
                realisation.append(listSeparator);
            }
            realisation.append(' ');
        }
        if (realisation.length() > 0) {
            realisation.setLength(realisation.length() - 1);
        }
    }

    private NLGElement realiseCoordinatedPhrase(List<NLGElement> components) {
        StringBuffer realisation = new StringBuffer();
        NLGElement realisedChild = null;
        int length = components.size();
        for (int index = 0; index < length; ++index) {
            realisedChild = components.get(index);
            if (index < length - 2 && DiscourseFunction.CONJUNCTION.equals(realisedChild.getFeature("discourse_function"))) {
                realisation.append(", ");
                continue;
            }
            realisedChild = this.realise(realisedChild);
            realisation.append(realisedChild.getRealisation()).append(' ');
        }
        realisation.setLength(realisation.length() - 1);
        return new StringElement(realisation.toString().replace(" ,", ","));
    }
}

