/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.aggregation;

import java.util.ArrayList;
import java.util.List;
import simplenlg.aggregation.AggregationRule;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGFactory;
import simplenlg.framework.NLGModule;

public class Aggregator
extends NLGModule {
    private List<AggregationRule> _rules;
    private NLGFactory _factory;

    @Override
    public void initialise() {
        this._rules = new ArrayList<AggregationRule>();
        this._factory = new NLGFactory();
    }

    public void setFactory(NLGFactory factory) {
        this._factory = factory;
        for (AggregationRule rule : this._rules) {
            rule.setFactory(this._factory);
        }
    }

    public void addRule(AggregationRule rule) {
        rule.setFactory(this._factory);
        this._rules.add(rule);
    }

    public List<AggregationRule> getRules() {
        return this._rules;
    }

    @Override
    public NLGElement realise(NLGElement element) {
        NLGElement result = element;
        for (AggregationRule rule : this._rules) {
            NLGElement intermediate = rule.apply(result);
            if (intermediate == null) continue;
            result = intermediate;
        }
        return result;
    }

    @Override
    public List<NLGElement> realise(List<NLGElement> elements) {
        for (AggregationRule rule : this._rules) {
            elements = rule.apply(elements);
        }
        return elements;
    }
}

