/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.aggregation;

import java.util.List;
import simplenlg.aggregation.AggregationRule;
import simplenlg.aggregation.PhraseChecker;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.NLGElement;
import simplenlg.framework.PhraseCategory;

public class ClauseCoordinationRule
extends AggregationRule {
    @Override
    public NLGElement apply(NLGElement previous, NLGElement next) {
        NLGElement aggregated = null;
        if (previous.getCategory() == PhraseCategory.CLAUSE && next.getCategory() == PhraseCategory.CLAUSE && PhraseChecker.nonePassive(previous, next) && !PhraseChecker.expletiveSubjects(previous, next)) {
            if (PhraseChecker.sameSentences(previous, next)) {
                aggregated = previous;
            } else if (PhraseChecker.sameFrontMods(previous, next) && PhraseChecker.sameSubjects(previous, next) && PhraseChecker.samePostMods(previous, next)) {
                NLGElement vp;
                aggregated = this.factory.createClause();
                aggregated.setFeature("subjects", previous.getFeatureAsElementList("subjects"));
                aggregated.setFeature("front_modifiers", previous.getFeatureAsElement("front_modifiers"));
                aggregated.setFeature("cue_phrase", previous.getFeatureAsElement("cue_phrase"));
                aggregated.setFeature("postmodifiers", previous.getFeatureAsElementList("postmodifiers"));
                if (!PhraseChecker.sameVPArgs(previous, next) && PhraseChecker.sameVPHead(previous, next) && PhraseChecker.sameVPModifiers(previous, next)) {
                    NLGElement vp1 = previous.getFeatureAsElement("verb_phrase");
                    vp = this.factory.createVerbPhrase();
                    vp.setFeature("head", vp1.getFeatureAsElement("head"));
                    vp.setFeature("complements", vp1.getFeatureAsElementList("complements"));
                    vp.setFeature("premodifiers", vp1.getFeatureAsElementList("premodifiers"));
                    vp.setFeature("postmodifiers", vp1.getFeatureAsElementList("postmodifiers"));
                } else {
                    NLGElement vp1 = previous.getFeatureAsElement("verb_phrase");
                    NLGElement vp2 = next.getFeatureAsElement("verb_phrase");
                    vp = this.factory.createCoordinatedPhrase(vp1, vp2);
                }
                aggregated.setFeature("verb_phrase", vp);
            } else if (PhraseChecker.sameFrontMods(previous, next) && PhraseChecker.sameVP(previous, next) && PhraseChecker.samePostMods(previous, next)) {
                aggregated = this.factory.createClause();
                aggregated.setFeature("front_modifiers", previous.getFeatureAsElementList("front_modifiers"));
                CoordinatedPhraseElement subjects = this.factory.createCoordinatedPhrase();
                subjects.setCategory(PhraseCategory.NOUN_PHRASE);
                List<NLGElement> allSubjects = previous.getFeatureAsElementList("subjects");
                allSubjects.addAll(next.getFeatureAsElementList("subjects"));
                for (NLGElement subj : allSubjects) {
                    subjects.addCoordinate(subj);
                }
                aggregated.setFeature("subjects", subjects);
                aggregated.setFeature("postmodifiers", previous.getFeatureAsElementList("postmodifiers"));
                aggregated.setFeature("verb_phrase", previous.getFeature("verb_phrase"));
            }
        }
        return aggregated;
    }
}

