/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.format.english;

import java.util.ArrayList;
import java.util.List;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.DocumentCategory;
import simplenlg.framework.DocumentElement;
import simplenlg.framework.ElementCategory;
import simplenlg.framework.ListElement;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGModule;
import simplenlg.framework.StringElement;

public class HTMLFormatter
extends NLGModule {
    @Override
    public void initialise() {
    }

    @Override
    public NLGElement realise(NLGElement element) {
        StringBuffer realisation;
        block21: {
            List<NLGElement> components;
            NLGElement realisedComponent;
            block23: {
                ElementCategory category;
                block22: {
                    realisedComponent = null;
                    realisation = new StringBuffer();
                    if (element == null) break block21;
                    category = element.getCategory();
                    components = element.getChildren();
                    if (!(element instanceof StringElement)) break block22;
                    realisation.append(element.getRealisation());
                    break block21;
                }
                if (!(category instanceof DocumentCategory)) break block23;
                switch ((DocumentCategory)category) {
                    case DOCUMENT: {
                        String title;
                        String string = title = element instanceof DocumentElement ? ((DocumentElement)element).getTitle() : null;
                        if (null != title) {
                            realisation.append("<h1>" + title + "</h1>");
                        }
                        for (NLGElement eachComponent : components) {
                            realisedComponent = this.realise(eachComponent);
                            if (realisedComponent == null) continue;
                            realisation.append(realisedComponent.getRealisation());
                        }
                        break block21;
                    }
                    case SECTION: {
                        String title;
                        String string = title = element instanceof DocumentElement ? ((DocumentElement)element).getTitle() : null;
                        if (title != null) {
                            String sectionTitle = ((DocumentElement)element).getTitle();
                            realisation.append("<h2>" + (String)sectionTitle + "</h2>");
                        }
                        for (NLGElement eachComponent : components) {
                            realisedComponent = this.realise(eachComponent);
                            if (realisedComponent == null) continue;
                            realisation.append(realisedComponent.getRealisation());
                        }
                        break block21;
                    }
                    case LIST: {
                        realisation.append("<ul>");
                        for (NLGElement eachComponent : components) {
                            realisedComponent = this.realise(eachComponent);
                            if (realisedComponent == null) continue;
                            realisation.append(realisedComponent.getRealisation());
                        }
                        realisation.append("</ul>");
                        break;
                    }
                    case ENUMERATED_LIST: {
                        realisation.append("<ol>");
                        for (NLGElement eachComponent : components) {
                            realisedComponent = this.realise(eachComponent);
                            if (realisedComponent == null) continue;
                            realisation.append(realisedComponent.getRealisation());
                        }
                        realisation.append("</ol>");
                        break;
                    }
                    case PARAGRAPH: {
                        if (null == components || 0 >= components.size()) break;
                        realisedComponent = this.realise(components.get(0));
                        if (realisedComponent != null) {
                            realisation.append("<p>");
                            realisation.append(realisedComponent.getRealisation());
                        }
                        for (int i = 1; i < components.size(); ++i) {
                            if (realisedComponent != null) {
                                realisation.append(" ");
                            }
                            if ((realisedComponent = this.realise(components.get(i))) == null) continue;
                            realisation.append(realisedComponent.getRealisation());
                        }
                        realisation.append("</p>");
                        break;
                    }
                    case SENTENCE: {
                        realisation.append(element.getRealisation());
                        break;
                    }
                    case LIST_ITEM: {
                        realisation.append("<li>");
                        for (NLGElement eachComponent : components) {
                            realisedComponent = this.realise(eachComponent);
                            if (realisedComponent == null) continue;
                            realisation.append(realisedComponent.getRealisation());
                            if (components.indexOf(eachComponent) >= components.size() - 1) continue;
                            realisation.append(' ');
                        }
                        realisation.append("</li>");
                    }
                }
                break block21;
            }
            if (element instanceof ListElement || element instanceof CoordinatedPhraseElement) {
                for (NLGElement eachComponent : components) {
                    realisedComponent = this.realise(eachComponent);
                    if (realisedComponent == null) continue;
                    realisation.append(realisedComponent.getRealisation()).append(' ');
                }
            }
        }
        return new StringElement(realisation.toString());
    }

    @Override
    public List<NLGElement> realise(List<NLGElement> elements) {
        ArrayList<NLGElement> realisedList = new ArrayList<NLGElement>();
        if (elements != null) {
            for (NLGElement eachElement : elements) {
                realisedList.add(this.realise(eachElement));
            }
        }
        return realisedList;
    }
}

