/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.framework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import simplenlg.features.NumberAgreement;
import simplenlg.framework.NLGElement;
import simplenlg.framework.PhraseCategory;
import simplenlg.framework.StringElement;

public class CoordinatedPhraseElement
extends NLGElement {
    private static final List<String> PLURAL_COORDINATORS = Arrays.asList("and");

    public CoordinatedPhraseElement() {
        this.setFeature("conjunction", "and");
    }

    public CoordinatedPhraseElement(Object coordinate1, Object coordinate2) {
        this.addCoordinate(coordinate1);
        this.addCoordinate(coordinate2);
        this.setFeature("conjunction", "and");
    }

    public void addCoordinate(Object newCoordinate) {
        List<NLGElement> coordinates = this.getFeatureAsElementList("coordinates");
        if (coordinates == null) {
            coordinates = new ArrayList<NLGElement>();
            this.setFeature("coordinates", coordinates);
        } else if (coordinates.size() == 0) {
            this.setFeature("coordinates", coordinates);
        }
        if (newCoordinate instanceof NLGElement) {
            if (((NLGElement)newCoordinate).isA(PhraseCategory.CLAUSE) && coordinates.size() > 0) {
                ((NLGElement)newCoordinate).setFeature("suppressed_complementiser", true);
            }
            coordinates.add((NLGElement)newCoordinate);
        } else if (newCoordinate instanceof String) {
            StringElement coordElement = new StringElement((String)newCoordinate);
            coordElement.setFeature("suppressed_complementiser", true);
            coordinates.add(coordElement);
        }
        this.setFeature("coordinates", coordinates);
    }

    @Override
    public List<NLGElement> getChildren() {
        return this.getFeatureAsElementList("coordinates");
    }

    public void clearCoordinates() {
        this.removeFeature("coordinates");
    }

    public void addPreModifier(NLGElement newPreModifier) {
        List<NLGElement> preModifiers = this.getFeatureAsElementList("premodifiers");
        if (preModifiers == null) {
            preModifiers = new ArrayList<NLGElement>();
        }
        preModifiers.add(newPreModifier);
        this.setFeature("premodifiers", preModifiers);
    }

    public void addPreModifier(String newPreModifier) {
        List<NLGElement> preModifiers = this.getFeatureAsElementList("premodifiers");
        if (preModifiers == null) {
            preModifiers = new ArrayList<NLGElement>();
        }
        preModifiers.add(new StringElement(newPreModifier));
        this.setFeature("premodifiers", preModifiers);
    }

    public List<NLGElement> getPreModifiers() {
        return this.getFeatureAsElementList("premodifiers");
    }

    public List<NLGElement> getComplements() {
        return this.getFeatureAsElementList("complements");
    }

    public void addPostModifier(NLGElement newPostModifier) {
        List<NLGElement> postModifiers = this.getFeatureAsElementList("postmodifiers");
        if (postModifiers == null) {
            postModifiers = new ArrayList<NLGElement>();
        }
        postModifiers.add(newPostModifier);
        this.setFeature("postmodifiers", postModifiers);
    }

    public void addPostModifier(String newPostModifier) {
        List<NLGElement> postModifiers = this.getFeatureAsElementList("postmodifiers");
        if (postModifiers == null) {
            postModifiers = new ArrayList<NLGElement>();
        }
        postModifiers.add(new StringElement(newPostModifier));
        this.setFeature("postmodifiers", postModifiers);
    }

    public List<NLGElement> getPostModifiers() {
        return this.getFeatureAsElementList("postmodifiers");
    }

    @Override
    public String printTree(String indent) {
        String thisIndent = indent == null ? " |-" : indent + " |-";
        String childIndent = indent == null ? " | " : indent + " | ";
        String lastIndent = indent == null ? " \\-" : indent + " \\-";
        String lastChildIndent = indent == null ? "   " : indent + "   ";
        StringBuffer print = new StringBuffer();
        print.append("CoordinatedPhraseElement:\n");
        List<NLGElement> children = this.getChildren();
        int length = children.size() - 1;
        int index = 0;
        for (index = 0; index < length; ++index) {
            print.append(thisIndent).append(children.get(index).printTree(childIndent));
        }
        if (length >= 0) {
            print.append(lastIndent).append(children.get(length).printTree(lastChildIndent));
        }
        return print.toString();
    }

    public void addComplement(NLGElement newComplement) {
        List<NLGElement> complements = this.getFeatureAsElementList("complements");
        if (complements == null) {
            complements = new ArrayList<NLGElement>();
        }
        complements.add(newComplement);
        this.setFeature("complements", complements);
    }

    public void addComplement(String newComplement) {
        List<NLGElement> complements = this.getFeatureAsElementList("complements");
        if (complements == null) {
            complements = new ArrayList<NLGElement>();
        }
        complements.add(new StringElement(newComplement));
        this.setFeature("complements", complements);
    }

    public NLGElement getLastCoordinate() {
        List<NLGElement> children = this.getChildren();
        return children != null && children.size() > 0 ? children.get(children.size() - 1) : null;
    }

    public void setConjunction(String conjunction) {
        this.setFeature("conjunction", conjunction);
    }

    public String getConjunction() {
        return this.getFeatureAsString("conjunction");
    }

    public boolean checkIfPlural() {
        int size = this.getChildren().size();
        if (size == 1) {
            return NumberAgreement.PLURAL.equals(this.getLastCoordinate().getFeature("number"));
        }
        return PLURAL_COORDINATORS.contains(this.getConjunction());
    }
}

