/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.framework;

import simplenlg.framework.ElementCategory;

public enum DocumentCategory implements ElementCategory
{
    DOCUMENT,
    SECTION,
    PARAGRAPH,
    SENTENCE,
    LIST,
    ENUMERATED_LIST,
    LIST_ITEM;


    @Override
    public boolean equalTo(Object checkObject) {
        boolean match = false;
        if (checkObject != null) {
            match = checkObject instanceof DocumentCategory ? this.equals(checkObject) : this.toString().equalsIgnoreCase(checkObject.toString());
        }
        return match;
    }

    public boolean hasSubPart(ElementCategory elementCategory) {
        boolean subPart = false;
        if (elementCategory != null) {
            if (elementCategory instanceof DocumentCategory) {
                switch (this) {
                    case DOCUMENT: {
                        subPart = !elementCategory.equals(DOCUMENT) && !elementCategory.equals(LIST_ITEM);
                        break;
                    }
                    case SECTION: {
                        subPart = elementCategory.equals(PARAGRAPH) || elementCategory.equals(SECTION);
                        break;
                    }
                    case PARAGRAPH: {
                        subPart = elementCategory.equals(SENTENCE) || elementCategory.equals(LIST);
                        break;
                    }
                    case LIST: {
                        subPart = elementCategory.equals(LIST_ITEM);
                        break;
                    }
                    case ENUMERATED_LIST: {
                        subPart = elementCategory.equals(LIST_ITEM);
                        break;
                    }
                }
            } else {
                subPart = this.equals(SENTENCE) || this.equals(LIST_ITEM);
            }
        }
        return subPart;
    }
}

