/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.framework;

import java.util.List;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.NLGElement;
import simplenlg.framework.WordElement;

public class InflectedWordElement
extends NLGElement {
    public InflectedWordElement(String word, LexicalCategory category) {
        this.setFeature("base_form", word);
        this.setCategory(category);
    }

    public InflectedWordElement(WordElement word) {
        this.setFeature("base_word", word);
        String defaultSpelling = word.getDefaultSpellingVariant();
        this.setFeature("base_form", defaultSpelling);
        this.setCategory(word.getCategory());
    }

    @Override
    public List<NLGElement> getChildren() {
        return null;
    }

    @Override
    public String toString() {
        return "InflectedWordElement[" + this.getBaseForm() + ':' + this.getCategory().toString() + ']';
    }

    @Override
    public String printTree(String indent) {
        StringBuffer print = new StringBuffer();
        print.append("InflectedWordElement: base=").append(this.getBaseForm()).append(", category=").append(this.getCategory().toString()).append(", ").append(super.toString()).append('\n');
        return print.toString();
    }

    public String getBaseForm() {
        return this.getFeatureAsString("base_form");
    }

    public void setBaseWord(WordElement word) {
        this.setFeature("base_word", word);
    }

    public WordElement getBaseWord() {
        NLGElement baseWord = this.getFeatureAsElement("base_word");
        return baseWord instanceof WordElement ? (WordElement)baseWord : null;
    }
}

