/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import simplenlg.features.NumberAgreement;
import simplenlg.features.Tense;
import simplenlg.framework.ElementCategory;
import simplenlg.framework.NLGFactory;
import simplenlg.framework.StringElement;

public abstract class NLGElement {
    private ElementCategory category;
    protected HashMap<String, Object> features = new HashMap();
    private NLGElement parent;
    private String realisation;
    private NLGFactory factory;

    public void setCategory(ElementCategory newCategory) {
        this.category = newCategory;
    }

    public ElementCategory getCategory() {
        return this.category;
    }

    public void setFeature(String featureName, Object featureValue) {
        if (featureName != null) {
            if (featureValue == null) {
                this.features.remove(featureName);
            } else {
                this.features.put(featureName, featureValue);
            }
        }
    }

    public void setFeature(String featureName, boolean featureValue) {
        if (featureName != null) {
            this.features.put(featureName, new Boolean(featureValue));
        }
    }

    public void setFeature(String featureName, int featureValue) {
        if (featureName != null) {
            this.features.put(featureName, new Integer(featureValue));
        }
    }

    public void setFeature(String featureName, long featureValue) {
        if (featureName != null) {
            this.features.put(featureName, new Long(featureValue));
        }
    }

    public void setFeature(String featureName, float featureValue) {
        if (featureName != null) {
            this.features.put(featureName, new Float(featureValue));
        }
    }

    public void setFeature(String featureName, double featureValue) {
        if (featureName != null) {
            this.features.put(featureName, new Double(featureValue));
        }
    }

    public Object getFeature(String featureName) {
        return featureName != null ? this.features.get(featureName) : null;
    }

    public String getFeatureAsString(String featureName) {
        Object value = this.getFeature(featureName);
        String stringValue = null;
        if (value != null) {
            stringValue = value.toString();
        }
        return stringValue;
    }

    public List<NLGElement> getFeatureAsElementList(String featureName) {
        ArrayList<NLGElement> list = new ArrayList<NLGElement>();
        Object value = this.getFeature(featureName);
        if (value instanceof NLGElement) {
            list.add((NLGElement)value);
        } else if (value instanceof Collection) {
            Iterator iterator = ((Collection)value).iterator();
            Object nextObject = null;
            while (iterator.hasNext()) {
                nextObject = iterator.next();
                if (!(nextObject instanceof NLGElement)) continue;
                list.add(nextObject);
            }
        }
        return list;
    }

    public List<Object> getFeatureAsList(String featureName) {
        ArrayList<Object> values = new ArrayList<Object>();
        Object value = this.getFeature(featureName);
        if (value != null) {
            if (value instanceof Collection) {
                Iterator iterator = ((Collection)value).iterator();
                Object nextObject = null;
                while (iterator.hasNext()) {
                    nextObject = iterator.next();
                    values.add(nextObject);
                }
            } else {
                values.add(value);
            }
        }
        return values;
    }

    public List<String> getFeatureAsStringList(String featureName) {
        ArrayList<String> values = new ArrayList<String>();
        Object value = this.getFeature(featureName);
        if (value != null) {
            if (value instanceof Collection) {
                Iterator iterator = ((Collection)value).iterator();
                Object nextObject = null;
                while (iterator.hasNext()) {
                    nextObject = iterator.next();
                    values.add(nextObject.toString());
                }
            } else {
                values.add(value.toString());
            }
        }
        return values;
    }

    public Integer getFeatureAsInteger(String featureName) {
        Object value = this.getFeature(featureName);
        Integer intValue = null;
        if (value instanceof Integer) {
            intValue = (Integer)value;
        } else if (value instanceof Number) {
            intValue = new Integer(((Number)value).intValue());
        } else if (value instanceof String) {
            try {
                intValue = new Integer((String)value);
            }
            catch (NumberFormatException exception) {
                intValue = null;
            }
        }
        return intValue;
    }

    public Long getFeatureAsLong(String featureName) {
        Object value = this.getFeature(featureName);
        Long longValue = null;
        if (value instanceof Long) {
            longValue = (Long)value;
        } else if (value instanceof Number) {
            longValue = new Long(((Number)value).longValue());
        } else if (value instanceof String) {
            try {
                longValue = new Long((String)value);
            }
            catch (NumberFormatException exception) {
                longValue = null;
            }
        }
        return longValue;
    }

    public Float getFeatureAsFloat(String featureName) {
        Object value = this.getFeature(featureName);
        Float floatValue = null;
        if (value instanceof Float) {
            floatValue = (Float)value;
        } else if (value instanceof Number) {
            floatValue = new Float(((Number)value).floatValue());
        } else if (value instanceof String) {
            try {
                floatValue = new Float((String)value);
            }
            catch (NumberFormatException exception) {
                floatValue = null;
            }
        }
        return floatValue;
    }

    public Double getFeatureAsDouble(String featureName) {
        Object value = this.getFeature(featureName);
        Double doubleValue = null;
        if (value instanceof Double) {
            doubleValue = (Double)value;
        } else if (value instanceof Number) {
            doubleValue = new Double(((Number)value).doubleValue());
        } else if (value instanceof String) {
            try {
                doubleValue = new Double((String)value);
            }
            catch (NumberFormatException exception) {
                doubleValue = null;
            }
        }
        return doubleValue;
    }

    public Boolean getFeatureAsBoolean(String featureName) {
        Object value = this.getFeature(featureName);
        Boolean boolValue = Boolean.FALSE;
        if (value instanceof Boolean) {
            boolValue = (Boolean)value;
        }
        return boolValue;
    }

    public NLGElement getFeatureAsElement(String featureName) {
        Object value = this.getFeature(featureName);
        NLGElement elementValue = null;
        if (value instanceof NLGElement) {
            elementValue = (NLGElement)value;
        } else if (value instanceof String) {
            elementValue = new StringElement((String)value);
        }
        return elementValue;
    }

    public Map<String, Object> getAllFeatures() {
        return this.features;
    }

    public boolean hasFeature(String featureName) {
        return featureName != null ? this.features.containsKey(featureName) : false;
    }

    public void removeFeature(String featureName) {
        this.features.remove(featureName);
    }

    public void clearAllFeatures() {
        this.features.clear();
    }

    public void setParent(NLGElement newParent) {
        this.parent = newParent;
    }

    public NLGElement getParent() {
        return this.parent;
    }

    public void setRealisation(String realised) {
        this.realisation = realised;
    }

    public String getRealisation() {
        int start;
        int end = 0;
        if (null != this.realisation) {
            end = this.realisation.length();
            for (start = 0; start < this.realisation.length() && ' ' == this.realisation.charAt(start); ++start) {
            }
            if (start == this.realisation.length()) {
                this.realisation = null;
            } else {
                while (end > 0 && ' ' == this.realisation.charAt(end - 1)) {
                    --end;
                }
            }
        }
        return this.realisation == null ? "" : this.realisation.substring(start, end);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("{realisation=").append(this.realisation);
        if (this.category != null) {
            buffer.append(", category=").append(this.category.toString());
        }
        if (this.features != null) {
            buffer.append(", features=").append(this.features.toString());
        }
        buffer.append('}');
        return buffer.toString();
    }

    public boolean isA(ElementCategory checkCategory) {
        boolean isA = false;
        if (this.category != null) {
            isA = this.category.equalTo(checkCategory);
        } else if (checkCategory == null) {
            isA = true;
        }
        return isA;
    }

    public abstract List<NLGElement> getChildren();

    public Set<String> getAllFeatureNames() {
        return this.features.keySet();
    }

    public String printTree(String indent) {
        String thisIndent = indent == null ? " |-" : indent + " |-";
        String childIndent = indent == null ? " |-" : indent + " |-";
        StringBuffer print = new StringBuffer();
        print.append("NLGElement: ").append(this.toString()).append('\n');
        List<NLGElement> children = this.getChildren();
        if (children != null) {
            for (NLGElement eachChild : this.getChildren()) {
                print.append(thisIndent).append(eachChild.printTree(childIndent));
            }
        }
        return print.toString();
    }

    public boolean equals(String elementRealisation) {
        boolean match = false;
        if (elementRealisation == null && this.realisation == null) {
            match = true;
        } else if (elementRealisation != null && this.realisation != null) {
            match = elementRealisation.equals(this.realisation);
        }
        return match;
    }

    public void setPlural(boolean isPlural) {
        if (isPlural) {
            this.setFeature("number", (Object)NumberAgreement.PLURAL);
        } else {
            this.setFeature("number", (Object)NumberAgreement.SINGULAR);
        }
    }

    public boolean isPlural() {
        return NumberAgreement.PLURAL.equals(this.getFeature("number"));
    }

    @Deprecated
    public Tense getTense() {
        Tense tense = Tense.PRESENT;
        Object tenseValue = this.getFeature("tense");
        if (tenseValue instanceof Tense) {
            tense = (Tense)((Object)tenseValue);
        }
        return tense;
    }

    @Deprecated
    public void setTense(Tense newTense) {
        this.setFeature("tense", (Object)newTense);
    }

    @Deprecated
    public void setNegated(boolean isNegated) {
        this.setFeature("negated", isNegated);
    }

    @Deprecated
    public boolean isNegated() {
        return this.getFeatureAsBoolean("negated");
    }

    public NLGFactory getFactory() {
        return this.factory;
    }

    public void setFactory(NLGFactory factory) {
        this.factory = factory;
    }

    public boolean equals(Object o) {
        boolean eq = false;
        if (o instanceof NLGElement) {
            NLGElement element = (NLGElement)o;
            eq = this.category == element.category && this.features.equals(element.features);
        }
        return eq;
    }
}

