/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.framework;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import simplenlg.framework.NLGElement;
import simplenlg.framework.PhraseCategory;

public class StringElement
extends NLGElement {
    public StringElement(String value) {
        this.setCategory(PhraseCategory.CANNED_TEXT);
        this.setFeature("elided", false);
        this.setRealisation(value);
    }

    @Override
    public List<NLGElement> getChildren() {
        return new ArrayList<NLGElement>();
    }

    @Override
    public String toString() {
        return this.getRealisation();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && o instanceof StringElement && this.realisationsMatch((StringElement)o);
    }

    private boolean realisationsMatch(StringElement o) {
        if (this.getRealisation() == null) {
            return o.getRealisation() == null;
        }
        return this.getRealisation().equals(o.getRealisation());
    }

    @Override
    public String printTree(String indent) {
        StringBuffer print = new StringBuffer();
        print.append("StringElement: content=\"").append(this.getRealisation()).append('\"');
        Map<String, Object> features = this.getAllFeatures();
        if (features != null) {
            print.append(", features=").append(features.toString());
        }
        print.append('\n');
        return print.toString();
    }
}

