/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.framework;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import simplenlg.features.Inflection;
import simplenlg.features.LexicalFeature;
import simplenlg.framework.ElementCategory;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.NLGElement;

public class WordElement
extends NLGElement {
    String baseForm;
    String id;
    Map<Inflection, InflectionSet> inflVars;
    Inflection defaultInfl;

    public WordElement() {
        this(null, LexicalCategory.ANY, null);
    }

    public WordElement(String baseForm) {
        this(baseForm, LexicalCategory.ANY, null);
    }

    public WordElement(String baseForm, LexicalCategory category) {
        this(baseForm, category, null);
    }

    public WordElement(String baseForm, LexicalCategory category, String id) {
        this.baseForm = baseForm;
        this.setCategory(category);
        this.id = id;
        this.inflVars = new HashMap<Inflection, InflectionSet>();
    }

    public WordElement(WordElement currentWord) {
        this.baseForm = currentWord.getBaseForm();
        this.setCategory(currentWord.getCategory());
        this.id = currentWord.getId();
        this.inflVars = currentWord.getInflectionalVariants();
        this.defaultInfl = (Inflection)((Object)currentWord.getDefaultInflectionalVariant());
        this.setFeatures(currentWord);
    }

    public String getBaseForm() {
        return this.baseForm;
    }

    public String getId() {
        return this.id;
    }

    public void setBaseForm(String baseForm) {
        this.baseForm = baseForm;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDefaultInflectionalVariant(Inflection variant) {
        this.setFeature("default_infl", (Object)variant);
        this.defaultInfl = variant;
        if (this.inflVars.containsKey((Object)variant)) {
            InflectionSet set = this.inflVars.get((Object)variant);
            String[] forms = LexicalFeature.getInflectionalFeatures(this.getCategory());
            if (forms != null) {
                for (String f : forms) {
                    this.setFeature(f, set.getForm(f));
                }
            }
        }
    }

    public Object getDefaultInflectionalVariant() {
        return this.defaultInfl;
    }

    public Map<Inflection, InflectionSet> getInflectionalVariants() {
        return this.inflVars;
    }

    public void setDefaultSpellingVariant(String variant) {
        this.setFeature("default_spell", variant);
    }

    public String getDefaultSpellingVariant() {
        String defSpell = this.getFeatureAsString("default_spell");
        return defSpell == null ? this.getBaseForm() : defSpell;
    }

    public void addInflectionalVariant(Inflection infl, String lexicalFeature, String form) {
        if (this.inflVars.containsKey((Object)infl)) {
            this.inflVars.get((Object)infl).addForm(lexicalFeature, form);
        } else {
            InflectionSet set = new InflectionSet(infl);
            set.addForm(lexicalFeature, form);
            this.inflVars.put(infl, set);
        }
    }

    public void addInflectionalVariant(Inflection infl) {
        this.inflVars.put(infl, new InflectionSet(infl));
    }

    public boolean hasInflectionalVariant(Inflection infl) {
        return this.inflVars.containsKey((Object)infl);
    }

    public void setFeatures(WordElement currentWord) {
        if (null != currentWord && null != currentWord.getAllFeatures()) {
            for (String feature : currentWord.getAllFeatureNames()) {
                this.setFeature(feature, currentWord.getFeature(feature));
            }
        }
    }

    @Override
    public String toString() {
        ElementCategory _category = this.getCategory();
        StringBuffer buffer = new StringBuffer("WordElement[");
        buffer.append(this.getBaseForm()).append(':');
        if (_category != null) {
            buffer.append(_category.toString());
        } else {
            buffer.append("no category");
        }
        buffer.append(']');
        return buffer.toString();
    }

    public String toXML() {
        String xml = String.format("<word>%n", new Object[0]);
        if (this.getBaseForm() != null) {
            xml = xml + String.format("  <base>%s</base>%n", this.getBaseForm());
        }
        if (this.getCategory() != LexicalCategory.ANY) {
            xml = xml + String.format("  <category>%s</category>%n", this.getCategory().toString().toLowerCase());
        }
        if (this.getId() != null) {
            xml = xml + String.format("  <id>%s</id>%n", this.getId());
        }
        TreeSet<String> featureNames = new TreeSet<String>(this.getAllFeatureNames());
        for (String feature : featureNames) {
            Object value = this.getFeature(feature);
            if (value == null) continue;
            if (value instanceof Boolean) {
                boolean bvalue = (Boolean)value;
                if (!bvalue) continue;
                xml = xml + String.format("  <%s/>%n", feature);
                continue;
            }
            xml = xml + String.format("  <%s>%s</%s>%n", feature, value.toString(), feature);
        }
        xml = xml + String.format("</word>%n", new Object[0]);
        return xml;
    }

    @Override
    public List<NLGElement> getChildren() {
        return new ArrayList<NLGElement>();
    }

    @Override
    public String printTree(String indent) {
        StringBuffer print = new StringBuffer();
        print.append("WordElement: base=").append(this.getBaseForm()).append(", category=").append(this.getCategory().toString()).append(", ").append(super.toString()).append('\n');
        return print.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof WordElement) {
            WordElement we = (WordElement)o;
            return !(this.baseForm != we.baseForm && !this.baseForm.equals(we.baseForm) || this.id != we.id && !this.id.equals(we.id) || !we.features.equals(this.features));
        }
        return false;
    }

    private class InflectionSet {
        Inflection infl;
        Map<String, String> forms;

        InflectionSet(Inflection infl) {
            this.infl = infl;
            this.forms = new HashMap<String, String>();
        }

        void addForm(String feature, String form) {
            this.forms.put(feature, form);
        }

        String getForm(String feature) {
            return this.forms.get(feature);
        }
    }
}

