/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon;

import java.util.ArrayList;
import java.util.List;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.WordElement;
import simplenlg.lexicon.Lexicon;

public class MultipleLexicon
extends Lexicon {
    private boolean alwaysSearchAll = false;
    private List<Lexicon> lexiconList = new ArrayList<Lexicon>();

    public MultipleLexicon() {
    }

    public MultipleLexicon(Lexicon ... lexicons) {
        this();
        for (Lexicon lex : lexicons) {
            this.lexiconList.add(lex);
        }
    }

    public void addInitialLexicon(Lexicon lex) {
        this.lexiconList.add(0, lex);
    }

    public void addFinalLexicon(Lexicon lex) {
        this.lexiconList.add(0, lex);
    }

    public boolean isAlwaysSearchAll() {
        return this.alwaysSearchAll;
    }

    public void setAlwaysSearchAll(boolean alwaysSearchAll) {
        this.alwaysSearchAll = alwaysSearchAll;
    }

    @Override
    public List<WordElement> getWords(String baseForm, LexicalCategory category) {
        ArrayList<WordElement> result = new ArrayList<WordElement>();
        for (Lexicon lex : this.lexiconList) {
            List<WordElement> lexResult = lex.getWords(baseForm, category);
            if (lexResult == null || lexResult.isEmpty()) continue;
            result.addAll(lexResult);
            if (this.alwaysSearchAll) continue;
            return result;
        }
        return result;
    }

    @Override
    public List<WordElement> getWordsByID(String id) {
        ArrayList<WordElement> result = new ArrayList<WordElement>();
        for (Lexicon lex : this.lexiconList) {
            List<WordElement> lexResult = lex.getWordsByID(id);
            if (lexResult == null || lexResult.isEmpty()) continue;
            result.addAll(lexResult);
            if (this.alwaysSearchAll) continue;
            return result;
        }
        return result;
    }

    @Override
    public List<WordElement> getWordsFromVariant(String variant, LexicalCategory category) {
        ArrayList<WordElement> result = new ArrayList<WordElement>();
        for (Lexicon lex : this.lexiconList) {
            List<WordElement> lexResult = lex.getWordsFromVariant(variant, category);
            if (lexResult == null || lexResult.isEmpty()) continue;
            result.addAll(lexResult);
            if (this.alwaysSearchAll) continue;
            return result;
        }
        return result;
    }

    @Override
    public void close() {
        for (Lexicon lex : this.lexiconList) {
            lex.close();
        }
    }
}

