/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import simplenlg.features.Inflection;
import simplenlg.framework.ElementCategory;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.WordElement;
import simplenlg.lexicon.Lexicon;

public class XMLLexicon
extends Lexicon {
    private static final String XML_BASE = "base";
    private static final String XML_CATEGORY = "category";
    private static final String XML_ID = "id";
    private static final String XML_WORD = "word";
    private Set<WordElement> words;
    private Map<String, WordElement> indexByID;
    private Map<String, List<WordElement>> indexByBase;
    private Map<String, List<WordElement>> indexByVariant;

    public XMLLexicon(String filename) {
        File file = new File(filename);
        this.createLexicon(file.toURI());
    }

    public XMLLexicon(File file) {
        this.createLexicon(file.toURI());
    }

    public XMLLexicon(URI lexiconURI) {
        this.createLexicon(lexiconURI);
    }

    public XMLLexicon() {
        try {
            URL defaultLexicon = this.getClass().getClassLoader().getResource("default-lexicon.xml");
            if (null != defaultLexicon) {
                this.createLexicon(defaultLexicon.toURI());
            } else {
                this.createLexicon(this.getClass().getResource("/simplenlg/lexicon/default-lexicon.xml").toURI());
            }
        }
        catch (URISyntaxException ex) {
            System.out.println(ex.toString());
        }
    }

    private void createLexicon(URI lexiconURI) {
        this.words = new HashSet<WordElement>();
        this.indexByID = new HashMap<String, WordElement>();
        this.indexByBase = new HashMap<String, List<WordElement>>();
        this.indexByVariant = new HashMap<String, List<WordElement>>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(lexiconURI.toString());
            if (doc != null) {
                Element lexRoot = doc.getDocumentElement();
                NodeList wordNodes = lexRoot.getChildNodes();
                for (int i = 0; i < wordNodes.getLength(); ++i) {
                    WordElement word;
                    Node wordNode = wordNodes.item(i);
                    if (wordNode.getNodeType() != 1 || (word = this.convertNodeToWord(wordNode)) == null) continue;
                    this.words.add(word);
                    this.IndexWord(word);
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
        this.addSpecialCases();
    }

    private void addSpecialCases() {
        WordElement be = this.getWord("be", LexicalCategory.VERB);
        if (be != null) {
            this.updateIndex(be, "is", this.indexByVariant);
            this.updateIndex(be, "am", this.indexByVariant);
            this.updateIndex(be, "are", this.indexByVariant);
            this.updateIndex(be, "was", this.indexByVariant);
            this.updateIndex(be, "were", this.indexByVariant);
        }
    }

    private WordElement convertNodeToWord(Node wordNode) {
        if (!wordNode.getNodeName().equalsIgnoreCase(XML_WORD)) {
            return null;
        }
        WordElement word = new WordElement();
        ArrayList<Inflection> inflections = new ArrayList<Inflection>();
        NodeList nodes = wordNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node featureNode = nodes.item(i);
            if (featureNode.getNodeType() != 1) continue;
            String feature = featureNode.getNodeName().trim();
            String value = featureNode.getTextContent();
            if (value != null) {
                value = value.trim();
            }
            if (feature == null) {
                System.err.println("Error in XML lexicon node for " + word.toString());
                break;
            }
            if (feature.equalsIgnoreCase(XML_BASE)) {
                word.setBaseForm(value);
                continue;
            }
            if (feature.equalsIgnoreCase(XML_CATEGORY)) {
                word.setCategory(LexicalCategory.valueOf(value.toUpperCase()));
                continue;
            }
            if (feature.equalsIgnoreCase(XML_ID)) {
                word.setId(value);
                continue;
            }
            if (value == null || value.equals("")) {
                Inflection infl = Inflection.getInflCode(feature);
                if (infl != null) {
                    inflections.add(infl);
                    continue;
                }
                word.setFeature(feature, true);
                continue;
            }
            word.setFeature(feature, value);
        }
        if (inflections.isEmpty()) {
            inflections.add(Inflection.REGULAR);
        }
        Inflection defaultInfl = inflections.contains((Object)Inflection.REGULAR) ? Inflection.REGULAR : (Inflection)((Object)inflections.get(0));
        word.setFeature("default_infl", (Object)defaultInfl);
        word.setDefaultInflectionalVariant(defaultInfl);
        for (Inflection infl : inflections) {
            word.addInflectionalVariant(infl);
        }
        return word;
    }

    private void IndexWord(WordElement word) {
        String id;
        String base = word.getBaseForm();
        if (base != null) {
            this.updateIndex(word, base, this.indexByBase);
        }
        if ((id = word.getId()) != null) {
            if (this.indexByID.containsKey(id)) {
                System.out.println("Lexicon error: ID " + id + " occurs more than once");
            }
            this.indexByID.put(id, word);
        }
        for (String variant : this.getVariants(word)) {
            this.updateIndex(word, variant, this.indexByVariant);
        }
    }

    private void updateIndex(WordElement word, String base, Map<String, List<WordElement>> index) {
        if (!index.containsKey(base)) {
            index.put(base, new ArrayList());
        }
        index.get(base).add(word);
    }

    @Override
    public List<WordElement> getWords(String baseForm, LexicalCategory category) {
        return this.getWordsFromIndex(baseForm, category, this.indexByBase);
    }

    private List<WordElement> getWordsFromIndex(String indexKey, LexicalCategory category, Map<String, List<WordElement>> indexMap) {
        ArrayList<WordElement> result = new ArrayList<WordElement>();
        if (!indexMap.containsKey(indexKey)) {
            return result;
        }
        if (category == LexicalCategory.ANY) {
            for (WordElement word : indexMap.get(indexKey)) {
                result.add(new WordElement(word));
            }
            return result;
        }
        for (WordElement word : indexMap.get(indexKey)) {
            if (word.getCategory() != category) continue;
            result.add(new WordElement(word));
        }
        return result;
    }

    @Override
    public List<WordElement> getWordsByID(String id) {
        ArrayList<WordElement> result = new ArrayList<WordElement>();
        if (this.indexByID.containsKey(id)) {
            result.add(new WordElement(this.indexByID.get(id)));
        }
        return result;
    }

    @Override
    public List<WordElement> getWordsFromVariant(String variant, LexicalCategory category) {
        return this.getWordsFromIndex(variant, category, this.indexByVariant);
    }

    private Set<String> getVariants(WordElement word) {
        HashSet<String> variants = new HashSet<String>();
        variants.add(word.getBaseForm());
        ElementCategory category = word.getCategory();
        if (category instanceof LexicalCategory) {
            switch ((LexicalCategory)category) {
                case NOUN: {
                    variants.add(this.getVariant(word, "plural", "s"));
                    break;
                }
                case ADJECTIVE: {
                    variants.add(this.getVariant(word, "comparative", "er"));
                    variants.add(this.getVariant(word, "superlative", "est"));
                    break;
                }
                case VERB: {
                    variants.add(this.getVariant(word, "present3s", "s"));
                    variants.add(this.getVariant(word, "past", "ed"));
                    variants.add(this.getVariant(word, "pastParticiple", "ed"));
                    variants.add(this.getVariant(word, "presentParticiple", "ing"));
                    break;
                }
            }
        }
        return variants;
    }

    private String getVariant(WordElement word, String feature, String suffix) {
        if (word.hasFeature(feature)) {
            return word.getFeatureAsString(feature);
        }
        return this.getForm(word.getBaseForm(), suffix);
    }

    private String getForm(String base, String suffix) {
        if (base.endsWith("y") && !suffix.startsWith("i")) {
            base = base.substring(0, base.length() - 1) + "ie";
        }
        if (base.endsWith("e") && (suffix.startsWith("e") || suffix.startsWith("i"))) {
            base = base.substring(0, base.length() - 1);
        }
        if (suffix.startsWith("s") && (base.endsWith("s") || base.endsWith("x") || base.endsWith("z") || base.endsWith("ch") || base.endsWith("sh"))) {
            base = base + "e";
        }
        return base + suffix;
    }
}

