/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.morphology.english;

import simplenlg.features.DiscourseFunction;
import simplenlg.features.Form;
import simplenlg.features.Gender;
import simplenlg.features.Inflection;
import simplenlg.features.NumberAgreement;
import simplenlg.features.Person;
import simplenlg.features.Tense;
import simplenlg.framework.InflectedWordElement;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGModule;
import simplenlg.framework.StringElement;
import simplenlg.framework.WordElement;
import simplenlg.morphology.english.DeterminerAgrHelper;

public abstract class MorphologyRules
extends NLGModule {
    private static final String[][][] PRONOUNS = new String[][][]{{{"I", "you", "he", "she", "it"}, {"me", "you", "him", "her", "it"}, {"myself", "yourself", "himself", "herself", "itself"}, {"mine", "yours", "his", "hers", "its"}, {"my", "your", "his", "her", "its"}}, {{"we", "you", "they", "they", "they"}, {"us", "you", "them", "them", "them"}, {"ourselves", "yourselves", "themselves", "themselves", "themselves"}, {"ours", "yours", "theirs", "theirs", "theirs"}, {"our", "your", "their", "their", "their"}}};
    private static final String[] WH_PRONOUNS = new String[]{"who", "what", "which", "where", "why", "how", "how many"};

    protected static StringElement doNounMorphology(InflectedWordElement element, WordElement baseWord) {
        StringBuffer realised = new StringBuffer();
        String baseForm = MorphologyRules.getBaseForm(element, baseWord);
        if (element.isPlural() && !element.getFeatureAsBoolean("proper").booleanValue()) {
            String pluralForm = null;
            Object elementDefaultInfl = element.getFeature("default_infl");
            pluralForm = elementDefaultInfl != null && Inflection.UNCOUNT.equals(elementDefaultInfl) ? baseForm : element.getFeatureAsString("plural");
            if (pluralForm == null && baseWord != null) {
                String baseDefaultInfl = baseWord.getFeatureAsString("default_infl");
                pluralForm = baseDefaultInfl != null && baseDefaultInfl.equals("uncount") ? baseForm : baseWord.getFeatureAsString("plural");
            }
            if (pluralForm == null) {
                Object pattern = element.getFeature("default_infl");
                pluralForm = Inflection.GRECO_LATIN_REGULAR.equals(pattern) ? MorphologyRules.buildGrecoLatinPluralNoun(baseForm) : MorphologyRules.buildRegularPluralNoun(baseForm);
            }
            realised.append(pluralForm);
        } else {
            realised.append(baseForm);
        }
        MorphologyRules.checkPossessive(element, realised);
        StringElement realisedElement = new StringElement(realised.toString());
        realisedElement.setFeature("discourse_function", element.getFeature("discourse_function"));
        return realisedElement;
    }

    private static String buildRegularPluralNoun(String baseForm) {
        String plural = null;
        if (baseForm != null) {
            plural = baseForm.matches(".*[b-z&&[^eiou]]y\\b") ? baseForm.replaceAll("y\\b", "ies") : (baseForm.matches(".*([szx]|[cs]h)\\b") ? baseForm + "es" : baseForm + "s");
        }
        return plural;
    }

    private static String buildGrecoLatinPluralNoun(String baseForm) {
        String plural = null;
        if (baseForm != null) {
            plural = baseForm.endsWith("us") ? baseForm.replaceAll("us\\b", "i") : (baseForm.endsWith("ma") ? baseForm + "ta" : (baseForm.endsWith("a") ? baseForm + "e" : (baseForm.matches(".*[(um)(on)]\\b") ? baseForm.replaceAll("[(um)(on)]\\b", "a") : (baseForm.endsWith("sis") ? baseForm.replaceAll("sis\\b", "ses") : (baseForm.endsWith("is") ? baseForm.replaceAll("is\\b", "ides") : (baseForm.endsWith("men") ? baseForm.replaceAll("men\\b", "mina") : (baseForm.endsWith("ex") ? baseForm.replaceAll("ex\\b", "ices") : (baseForm.endsWith("x") ? baseForm.replaceAll("x\\b", "ces") : baseForm))))))));
        }
        return plural;
    }

    protected static NLGElement doVerbMorphology(InflectedWordElement element, WordElement baseWord) {
        String realised = null;
        Object numberValue = element.getFeature("number");
        Object personValue = element.getFeature("person");
        Object tense = element.getFeature("tense");
        Tense tenseValue = tense instanceof Tense ? (Tense)((Object)tense) : Tense.PRESENT;
        Object formValue = element.getFeature("form");
        Object patternValue = element.getFeature("default_infl");
        String baseForm = MorphologyRules.getBaseForm(element, baseWord);
        if (element.getFeatureAsBoolean("negated").booleanValue() || Form.BARE_INFINITIVE.equals(formValue)) {
            realised = baseForm;
        } else if (Form.PRESENT_PARTICIPLE.equals(formValue)) {
            realised = element.getFeatureAsString("presentParticiple");
            if (realised == null && baseWord != null) {
                realised = baseWord.getFeatureAsString("presentParticiple");
            }
            if (realised == null) {
                realised = Inflection.REGULAR_DOUBLE.equals(patternValue) ? MorphologyRules.buildDoublePresPartVerb(baseForm) : MorphologyRules.buildRegularPresPartVerb(baseForm);
            }
        } else if (Tense.PAST.equals((Object)tenseValue) || Form.PAST_PARTICIPLE.equals(formValue)) {
            if (Form.PAST_PARTICIPLE.equals(formValue)) {
                realised = element.getFeatureAsString("pastParticiple");
                if (realised == null && baseWord != null) {
                    realised = baseWord.getFeatureAsString("pastParticiple");
                }
                if (realised == null) {
                    realised = "be".equalsIgnoreCase(baseForm) ? "been" : (Inflection.REGULAR_DOUBLE.equals(patternValue) ? MorphologyRules.buildDoublePastVerb(baseForm) : MorphologyRules.buildRegularPastVerb(baseForm, numberValue, personValue));
                }
            } else {
                realised = element.getFeatureAsString("past");
                if (realised == null && baseWord != null) {
                    realised = baseWord.getFeatureAsString("past");
                }
                if (realised == null) {
                    realised = Inflection.REGULAR_DOUBLE.equals(patternValue) ? MorphologyRules.buildDoublePastVerb(baseForm) : MorphologyRules.buildRegularPastVerb(baseForm, numberValue, personValue);
                }
            }
        } else if (!(numberValue != null && !NumberAgreement.SINGULAR.equals(numberValue) || personValue != null && !Person.THIRD.equals(personValue) || tenseValue != null && !Tense.PRESENT.equals((Object)tenseValue))) {
            realised = element.getFeatureAsString("present3s");
            if (realised == null && baseWord != null && !"be".equalsIgnoreCase(baseForm)) {
                realised = baseWord.getFeatureAsString("present3s");
            }
            if (realised == null) {
                realised = MorphologyRules.buildPresent3SVerb(baseForm);
            }
        } else {
            realised = "be".equalsIgnoreCase(baseForm) ? (Person.FIRST.equals(personValue) && (NumberAgreement.SINGULAR.equals(numberValue) || numberValue == null) ? "am" : "are") : baseForm;
        }
        StringElement realisedElement = new StringElement(realised);
        realisedElement.setFeature("discourse_function", element.getFeature("discourse_function"));
        return realisedElement;
    }

    private static String getBaseForm(InflectedWordElement element, WordElement baseWord) {
        if (LexicalCategory.VERB == element.getCategory()) {
            if (baseWord != null && baseWord.getDefaultSpellingVariant() != null) {
                return baseWord.getDefaultSpellingVariant();
            }
            return element.getBaseForm();
        }
        if (element.getBaseForm() != null) {
            return element.getBaseForm();
        }
        if (baseWord == null) {
            return null;
        }
        return baseWord.getDefaultSpellingVariant();
    }

    private static void checkPossessive(InflectedWordElement element, StringBuffer realised) {
        if (element.getFeatureAsBoolean("possessive").booleanValue()) {
            if (realised.charAt(realised.length() - 1) == 's') {
                realised.append('\'');
            } else {
                realised.append("'s");
            }
        }
    }

    private static String buildPresent3SVerb(String baseForm) {
        String morphology = null;
        if (baseForm != null) {
            morphology = baseForm.equalsIgnoreCase("be") ? "is" : (baseForm.matches(".*[szx(ch)(sh)]\\b") ? baseForm + "es" : (baseForm.matches(".*[b-z&&[^eiou]]y\\b") ? baseForm.replaceAll("y\\b", "ies") : baseForm + "s"));
        }
        return morphology;
    }

    private static String buildRegularPastVerb(String baseForm, Object number, Object person) {
        String morphology = null;
        if (baseForm != null) {
            morphology = baseForm.equalsIgnoreCase("be") ? (NumberAgreement.PLURAL.equals(number) ? "were" : (Person.SECOND.equals(person) ? "were" : "was")) : (baseForm.endsWith("e") ? baseForm + "d" : (baseForm.matches(".*[b-z&&[^eiou]]y\\b") ? baseForm.replaceAll("y\\b", "ied") : baseForm + "ed"));
        }
        return morphology;
    }

    private static String buildDoublePastVerb(String baseForm) {
        String morphology = null;
        if (baseForm != null) {
            morphology = baseForm + baseForm.charAt(baseForm.length() - 1) + "ed";
        }
        return morphology;
    }

    private static String buildRegularPresPartVerb(String baseForm) {
        String morphology = null;
        if (baseForm != null) {
            morphology = baseForm.equalsIgnoreCase("be") ? "being" : (baseForm.endsWith("ie") ? baseForm.replaceAll("ie\\b", "ying") : (baseForm.matches(".*[^iyeo]e\\b") ? baseForm.replaceAll("e\\b", "ing") : baseForm + "ing"));
        }
        return morphology;
    }

    private static String buildDoublePresPartVerb(String baseForm) {
        String morphology = null;
        if (baseForm != null) {
            morphology = baseForm + baseForm.charAt(baseForm.length() - 1) + "ing";
        }
        return morphology;
    }

    public static NLGElement doAdjectiveMorphology(InflectedWordElement element, WordElement baseWord) {
        String realised = null;
        Object patternValue = element.getFeature("default_infl");
        String baseForm = MorphologyRules.getBaseForm(element, baseWord);
        if (element.getFeatureAsBoolean("is_comparative").booleanValue()) {
            realised = element.getFeatureAsString("comparative");
            if (realised == null && baseWord != null) {
                realised = baseWord.getFeatureAsString("comparative");
            }
            if (realised == null) {
                realised = Inflection.REGULAR_DOUBLE.equals(patternValue) ? MorphologyRules.buildDoubleCompAdjective(baseForm) : MorphologyRules.buildRegularComparative(baseForm);
            }
        } else if (element.getFeatureAsBoolean("is_superlative").booleanValue()) {
            realised = element.getFeatureAsString("superlative");
            if (realised == null && baseWord != null) {
                realised = baseWord.getFeatureAsString("superlative");
            }
            if (realised == null) {
                realised = Inflection.REGULAR_DOUBLE.equals(patternValue) ? MorphologyRules.buildDoubleSuperAdjective(baseForm) : MorphologyRules.buildRegularSuperlative(baseForm);
            }
        } else {
            realised = baseForm;
        }
        StringElement realisedElement = new StringElement(realised);
        realisedElement.setFeature("discourse_function", element.getFeature("discourse_function"));
        return realisedElement;
    }

    private static String buildDoubleCompAdjective(String baseForm) {
        String morphology = null;
        if (baseForm != null) {
            morphology = baseForm + baseForm.charAt(baseForm.length() - 1) + "er";
        }
        return morphology;
    }

    private static String buildRegularComparative(String baseForm) {
        String morphology = null;
        if (baseForm != null) {
            morphology = baseForm.matches(".*[b-z&&[^eiou]]y\\b") ? baseForm.replaceAll("y\\b", "ier") : (baseForm.endsWith("e") ? baseForm + "r" : baseForm + "er");
        }
        return morphology;
    }

    private static String buildDoubleSuperAdjective(String baseForm) {
        String morphology = null;
        if (baseForm != null) {
            morphology = baseForm + baseForm.charAt(baseForm.length() - 1) + "est";
        }
        return morphology;
    }

    private static String buildRegularSuperlative(String baseForm) {
        String morphology = null;
        if (baseForm != null) {
            morphology = baseForm.matches(".*[b-z&&[^eiou]]y\\b") ? baseForm.replaceAll("y\\b", "iest") : (baseForm.endsWith("e") ? baseForm + "st" : baseForm + "est");
        }
        return morphology;
    }

    public static NLGElement doAdverbMorphology(InflectedWordElement element, WordElement baseWord) {
        String realised = null;
        String baseForm = MorphologyRules.getBaseForm(element, baseWord);
        if (element.getFeatureAsBoolean("is_comparative").booleanValue()) {
            realised = element.getFeatureAsString("comparative");
            if (realised == null && baseWord != null) {
                realised = baseWord.getFeatureAsString("comparative");
            }
            if (realised == null) {
                realised = MorphologyRules.buildRegularComparative(baseForm);
            }
        } else if (element.getFeatureAsBoolean("is_superlative").booleanValue()) {
            realised = element.getFeatureAsString("superlative");
            if (realised == null && baseWord != null) {
                realised = baseWord.getFeatureAsString("superlative");
            }
            if (realised == null) {
                realised = MorphologyRules.buildRegularSuperlative(baseForm);
            }
        } else {
            realised = baseForm;
        }
        StringElement realisedElement = new StringElement(realised);
        realisedElement.setFeature("discourse_function", element.getFeature("discourse_function"));
        return realisedElement;
    }

    public static NLGElement doPronounMorphology(InflectedWordElement element) {
        String realised = null;
        if (!element.getFeatureAsBoolean("non_morph").booleanValue() && !MorphologyRules.isWHPronoun(element)) {
            int personIndex;
            Object genderValue = element.getFeature("gender");
            Object personValue = element.getFeature("person");
            Object discourseValue = element.getFeature("discourse_function");
            int numberIndex = element.isPlural() ? 1 : 0;
            int genderIndex = genderValue instanceof Gender ? ((Gender)((Object)genderValue)).ordinal() : 2;
            int n = personIndex = personValue instanceof Person ? ((Person)((Object)personValue)).ordinal() : 2;
            if (personIndex == 2) {
                personIndex += genderIndex;
            }
            int positionIndex = 0;
            if (element.getFeatureAsBoolean("reflexive").booleanValue()) {
                positionIndex = 2;
            } else if (element.getFeatureAsBoolean("possessive").booleanValue()) {
                positionIndex = 3;
                if (DiscourseFunction.SPECIFIER.equals(discourseValue)) {
                    ++positionIndex;
                }
            } else {
                positionIndex = DiscourseFunction.SUBJECT.equals(discourseValue) && element.getFeatureAsBoolean("passive") == false || DiscourseFunction.OBJECT.equals(discourseValue) && element.getFeatureAsBoolean("passive") != false || DiscourseFunction.SPECIFIER.equals(discourseValue) || DiscourseFunction.COMPLEMENT.equals(discourseValue) && element.getFeatureAsBoolean("passive") != false ? 0 : 1;
            }
            realised = PRONOUNS[numberIndex][positionIndex][personIndex];
        } else {
            realised = element.getBaseForm();
        }
        StringElement realisedElement = new StringElement(realised);
        realisedElement.setFeature("discourse_function", element.getFeature("discourse_function"));
        return realisedElement;
    }

    private static boolean isWHPronoun(InflectedWordElement word) {
        String base = word.getBaseForm();
        boolean wh = false;
        if (base != null) {
            for (int i = 0; i < WH_PRONOUNS.length && !wh; ++i) {
                wh = WH_PRONOUNS[i].equals(base);
            }
        }
        return wh;
    }

    public static void doDeterminerMorphology(NLGElement determiner, String realisation) {
        if (realisation != null) {
            if (!determiner.getRealisation().equals("a")) {
                if (determiner.isPlural()) {
                    if ("that".equals(determiner.getRealisation())) {
                        determiner.setRealisation("those");
                    } else if ("this".equals(determiner.getRealisation())) {
                        determiner.setRealisation("these");
                    }
                } else if (!determiner.isPlural()) {
                    if ("those".equals(determiner.getRealisation())) {
                        determiner.setRealisation("that");
                    } else if ("these".equals(determiner.getRealisation())) {
                        determiner.setRealisation("this");
                    }
                }
            }
            if (determiner.getRealisation().equals("a")) {
                if (determiner.isPlural()) {
                    determiner.setRealisation("some");
                } else if (DeterminerAgrHelper.requiresAn(realisation)) {
                    determiner.setRealisation("an");
                }
            }
        }
    }
}

