/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.phrasespec;

import simplenlg.features.DiscourseFunction;
import simplenlg.features.Gender;
import simplenlg.features.Person;
import simplenlg.framework.InflectedWordElement;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGFactory;
import simplenlg.framework.PhraseCategory;
import simplenlg.framework.PhraseElement;
import simplenlg.framework.WordElement;
import simplenlg.phrasespec.AdjPhraseSpec;

public class NPPhraseSpec
extends PhraseElement {
    public NPPhraseSpec(NLGFactory phraseFactory) {
        super(PhraseCategory.NOUN_PHRASE);
        this.setFactory(phraseFactory);
    }

    @Override
    public void setHead(Object newHead) {
        super.setHead(newHead);
        this.setNounPhraseFeatures(this.getFeatureAsElement("head"));
    }

    private void setNounPhraseFeatures(NLGElement nounElement) {
        if (nounElement == null) {
            return;
        }
        this.setFeature("possessive", nounElement != null ? nounElement.getFeatureAsBoolean("possessive") : Boolean.FALSE);
        this.setFeature("raised", false);
        this.setFeature("acronym", false);
        if (nounElement != null && nounElement.hasFeature("number")) {
            this.setFeature("number", nounElement.getFeature("number"));
        } else {
            this.setPlural(false);
        }
        if (nounElement != null && nounElement.hasFeature("person")) {
            this.setFeature("person", nounElement.getFeature("person"));
        } else {
            this.setFeature("person", (Object)Person.THIRD);
        }
        if (nounElement != null && nounElement.hasFeature("gender")) {
            this.setFeature("gender", nounElement.getFeature("gender"));
        } else {
            this.setFeature("gender", (Object)Gender.NEUTER);
        }
        if (nounElement != null && nounElement.hasFeature("expletive_subject")) {
            this.setFeature("expletive_subject", nounElement.getFeature("expletive_subject"));
        }
        this.setFeature("adjective_ordering", true);
    }

    public void setNoun(Object noun) {
        NLGElement nounElement = this.getFactory().createNLGElement(noun, LexicalCategory.NOUN);
        this.setHead(nounElement);
    }

    public NLGElement getNoun() {
        return this.getHead();
    }

    @Override
    public void setDeterminer(Object determiner) {
        this.setSpecifier(determiner);
    }

    public NLGElement getDeterminer() {
        return this.getSpecifier();
    }

    public void setSpecifier(Object specifier) {
        if (specifier instanceof NLGElement) {
            this.setFeature("specifier", specifier);
            ((NLGElement)specifier).setFeature("discourse_function", (Object)DiscourseFunction.SPECIFIER);
        } else {
            NLGElement specifierElement = this.getFactory().createWord(specifier, LexicalCategory.DETERMINER);
            if (specifierElement != null) {
                this.setFeature("specifier", specifierElement);
                specifierElement.setFeature("discourse_function", (Object)DiscourseFunction.SPECIFIER);
            }
        }
    }

    public NLGElement getSpecifier() {
        return this.getFeatureAsElement("specifier");
    }

    @Override
    public void addModifier(Object modifier) {
        String modifierString;
        if (modifier == null) {
            return;
        }
        NLGElement modifierElement = null;
        if (modifier instanceof NLGElement) {
            modifierElement = (NLGElement)modifier;
        } else if (modifier instanceof String && (modifierString = (String)modifier).length() > 0 && !modifierString.contains(" ")) {
            modifierElement = this.getFactory().createWord(modifier, LexicalCategory.ANY);
        }
        if (modifierElement == null) {
            this.addPostModifier((String)modifier);
            return;
        }
        if (modifierElement instanceof AdjPhraseSpec) {
            this.addPreModifier(modifierElement);
            return;
        }
        WordElement modifierWord = null;
        if (modifierElement != null && modifierElement instanceof WordElement) {
            modifierWord = (WordElement)modifierElement;
        } else if (modifierElement != null && modifierElement instanceof InflectedWordElement) {
            modifierWord = ((InflectedWordElement)modifierElement).getBaseWord();
        }
        if (modifierWord != null && modifierWord.getCategory() == LexicalCategory.ADJECTIVE) {
            this.addPreModifier(modifierWord);
            return;
        }
        this.addPostModifier(modifierElement);
    }
}

