/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser.english;

import java.util.ArrayList;
import java.util.List;
import simplenlg.format.english.TextFormatter;
import simplenlg.framework.DocumentCategory;
import simplenlg.framework.DocumentElement;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGModule;
import simplenlg.lexicon.Lexicon;
import simplenlg.morphology.english.MorphologyProcessor;
import simplenlg.orthography.english.OrthographyProcessor;
import simplenlg.syntax.english.SyntaxProcessor;

public class Realiser
extends NLGModule {
    private MorphologyProcessor morphology;
    private OrthographyProcessor orthography;
    private SyntaxProcessor syntax;
    private NLGModule formatter = null;
    private boolean debug = false;

    public Realiser() {
        this.initialise();
    }

    public Realiser(Lexicon lexicon) {
        this();
        this.setLexicon(lexicon);
    }

    public boolean isCommaSepPremodifiers() {
        return this.orthography == null ? false : this.orthography.isCommaSepPremodifiers();
    }

    public void setCommaSepPremodifiers(boolean commaSepPremodifiers) {
        if (this.orthography != null) {
            this.orthography.setCommaSepPremodifiers(commaSepPremodifiers);
        }
    }

    public boolean isCommaSepCuephrase() {
        return this.orthography == null ? false : this.orthography.isCommaSepCuephrase();
    }

    public void setCommaSepCuephrase(boolean commaSepCuephrase) {
        if (this.orthography != null) {
            this.orthography.setCommaSepCuephrase(commaSepCuephrase);
        }
    }

    @Override
    public void initialise() {
        this.morphology = new MorphologyProcessor();
        this.morphology.initialise();
        this.orthography = new OrthographyProcessor();
        this.orthography.initialise();
        this.syntax = new SyntaxProcessor();
        this.syntax.initialise();
        this.formatter = new TextFormatter();
        this.formatter.initialise();
    }

    @Override
    public NLGElement realise(NLGElement element) {
        StringBuilder debug = new StringBuilder();
        if (this.debug) {
            System.out.println("INITIAL TREE\n");
            System.out.println(element.printTree(null));
            debug.append("INITIAL TREE<br/>");
            debug.append(element.printTree("&nbsp;&nbsp;").replaceAll("\n", "<br/>"));
        }
        NLGElement postSyntax = this.syntax.realise(element);
        if (this.debug) {
            System.out.println("<br/>POST-SYNTAX TREE<br/>");
            System.out.println(postSyntax.printTree(null));
            debug.append("<br/>POST-SYNTAX TREE<br/>");
            debug.append(postSyntax.printTree("&nbsp;&nbsp;").replaceAll("\n", "<br/>"));
        }
        NLGElement postMorphology = this.morphology.realise(postSyntax);
        if (this.debug) {
            System.out.println("\nPOST-MORPHOLOGY TREE\n");
            System.out.println(postMorphology.printTree(null));
            debug.append("<br/>POST-MORPHOLOGY TREE<br/>");
            debug.append(postMorphology.printTree("&nbsp;&nbsp;").replaceAll("\n", "<br/>"));
        }
        NLGElement postOrthography = this.orthography.realise(postMorphology);
        if (this.debug) {
            System.out.println("\nPOST-ORTHOGRAPHY TREE\n");
            System.out.println(postOrthography.printTree(null));
            debug.append("<br/>POST-ORTHOGRAPHY TREE<br/>");
            debug.append(postOrthography.printTree("&nbsp;&nbsp;").replaceAll("\n", "<br/>"));
        }
        NLGElement postFormatter = null;
        if (this.formatter != null) {
            postFormatter = this.formatter.realise(postOrthography);
            if (this.debug) {
                System.out.println("\nPOST-FORMATTER TREE\n");
                System.out.println(postFormatter.printTree(null));
                debug.append("<br/>POST-FORMATTER TREE<br/>");
                debug.append(postFormatter.printTree("&nbsp;&nbsp;").replaceAll("\n", "<br/>"));
            }
        } else {
            postFormatter = postOrthography;
        }
        if (this.debug) {
            postFormatter.setFeature("debug", debug.toString());
        }
        return postFormatter;
    }

    public String realiseSentence(NLGElement element) {
        NLGElement realised = null;
        if (element instanceof DocumentElement) {
            realised = this.realise(element);
        } else {
            DocumentElement sentence = new DocumentElement(DocumentCategory.SENTENCE, null);
            sentence.addComponent(element);
            realised = this.realise(sentence);
        }
        if (realised == null) {
            return null;
        }
        return realised.getRealisation();
    }

    @Override
    public List<NLGElement> realise(List<NLGElement> elements) {
        ArrayList<NLGElement> realisedElements = new ArrayList<NLGElement>();
        if (null != elements) {
            for (NLGElement element : elements) {
                NLGElement realisedElement = this.realise(element);
                realisedElements.add(realisedElement);
            }
        }
        return realisedElements;
    }

    @Override
    public void setLexicon(Lexicon newLexicon) {
        this.syntax.setLexicon(newLexicon);
        this.morphology.setLexicon(newLexicon);
        this.orthography.setLexicon(newLexicon);
    }

    public void setFormatter(NLGModule formatter) {
        this.formatter = formatter;
    }

    public void setDebugMode(boolean debugOn) {
        this.debug = debugOn;
    }
}

