/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.syntax.english;

import java.util.List;
import simplenlg.features.ClauseStatus;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.Form;
import simplenlg.features.InterrogativeType;
import simplenlg.features.NumberAgreement;
import simplenlg.features.Person;
import simplenlg.features.Tense;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.ListElement;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGFactory;
import simplenlg.framework.PhraseCategory;
import simplenlg.framework.PhraseElement;
import simplenlg.phrasespec.SPhraseSpec;
import simplenlg.phrasespec.VPPhraseSpec;
import simplenlg.syntax.english.PhraseHelper;
import simplenlg.syntax.english.SyntaxProcessor;
import simplenlg.syntax.english.VerbPhraseHelper;

abstract class ClauseHelper {
    ClauseHelper() {
    }

    static NLGElement realise(SyntaxProcessor parent, PhraseElement phrase) {
        ListElement realisedElement = null;
        NLGFactory phraseFactory = phrase.getFactory();
        NLGElement splitVerb = null;
        boolean interrogObj = false;
        if (phrase != null) {
            realisedElement = new ListElement();
            NLGElement verbElement = phrase.getFeatureAsElement("verb_phrase");
            if (verbElement == null) {
                verbElement = phrase.getHead();
            }
            ClauseHelper.checkSubjectNumberPerson(phrase, verbElement);
            ClauseHelper.checkDiscourseFunction(phrase);
            ClauseHelper.copyFrontModifiers(phrase, verbElement);
            ClauseHelper.addComplementiser(phrase, parent, realisedElement);
            ClauseHelper.addCuePhrase(phrase, parent, realisedElement);
            if (phrase.hasFeature("interrogative_type")) {
                Object inter = phrase.getFeature("interrogative_type");
                interrogObj = InterrogativeType.WHAT_OBJECT.equals(inter) || InterrogativeType.WHO_OBJECT.equals(inter) || InterrogativeType.HOW_PREDICATE.equals(inter) || InterrogativeType.HOW.equals(inter) || InterrogativeType.WHY.equals(inter) || InterrogativeType.WHERE.equals(inter);
                splitVerb = ClauseHelper.realiseInterrogative(phrase, parent, realisedElement, phraseFactory, verbElement);
            } else if (phrase.hasFeature("exclamatory")) {
                if (phrase.getParent() != null) {
                    phrase.getParent().setFeature("exclamatory", true);
                }
            } else {
                PhraseHelper.realiseList(parent, realisedElement, phrase.getFeatureAsElementList("front_modifiers"), DiscourseFunction.FRONT_MODIFIER);
            }
            ClauseHelper.addSubjectsToFront(phrase, parent, realisedElement, splitVerb);
            NLGElement passiveSplitVerb = ClauseHelper.addPassiveComplementsNumberPerson(phrase, parent, realisedElement, verbElement);
            if (passiveSplitVerb != null) {
                splitVerb = passiveSplitVerb;
            }
            ClauseHelper.realiseVerb(phrase, parent, realisedElement, splitVerb, verbElement, interrogObj);
            ClauseHelper.addPassiveSubjects(phrase, parent, realisedElement, phraseFactory);
            ClauseHelper.addInterrogativeFrontModifiers(phrase, parent, realisedElement);
            ClauseHelper.addEndingTo(phrase, parent, realisedElement, phraseFactory);
        }
        return realisedElement;
    }

    private static void addEndingTo(PhraseElement phrase, SyntaxProcessor parent, ListElement realisedElement, NLGFactory phraseFactory) {
        if (InterrogativeType.WHO_INDIRECT_OBJECT.equals(phrase.getFeature("interrogative_type"))) {
            NLGElement word = phraseFactory.createWord("to", LexicalCategory.PREPOSITION);
            realisedElement.addComponent(parent.realise(word));
        }
    }

    private static void addInterrogativeFrontModifiers(PhraseElement phrase, SyntaxProcessor parent, ListElement realisedElement) {
        NLGElement currentElement = null;
        if (phrase.hasFeature("interrogative_type")) {
            for (NLGElement subject : phrase.getFeatureAsElementList("front_modifiers")) {
                currentElement = parent.realise(subject);
                if (currentElement == null) continue;
                currentElement.setFeature("discourse_function", (Object)DiscourseFunction.FRONT_MODIFIER);
                realisedElement.addComponent(currentElement);
            }
        }
    }

    private static void addPassiveSubjects(PhraseElement phrase, SyntaxProcessor parent, ListElement realisedElement, NLGFactory phraseFactory) {
        NLGElement currentElement = null;
        if (phrase.getFeatureAsBoolean("passive").booleanValue()) {
            List<NLGElement> allSubjects = phrase.getFeatureAsElementList("subjects");
            if (allSubjects.size() > 0 || phrase.hasFeature("interrogative_type")) {
                realisedElement.addComponent(parent.realise(phraseFactory.createPrepositionPhrase("by")));
            }
            for (NLGElement subject : allSubjects) {
                subject.setFeature("passive", true);
                if (!subject.isA(PhraseCategory.NOUN_PHRASE) && !(subject instanceof CoordinatedPhraseElement) || (currentElement = parent.realise(subject)) == null) continue;
                currentElement.setFeature("discourse_function", (Object)DiscourseFunction.SUBJECT);
                realisedElement.addComponent(currentElement);
            }
        }
    }

    private static void realiseVerb(PhraseElement phrase, SyntaxProcessor parent, ListElement realisedElement, NLGElement splitVerb, NLGElement verbElement, boolean whObj) {
        ClauseHelper.setVerbFeatures(phrase, verbElement);
        NLGElement currentElement = parent.realise(verbElement);
        if (currentElement != null) {
            if (splitVerb == null) {
                currentElement.setFeature("discourse_function", (Object)DiscourseFunction.VERB_PHRASE);
                realisedElement.addComponent(currentElement);
            } else if (currentElement instanceof ListElement) {
                List<NLGElement> children = currentElement.getChildren();
                currentElement = children.get(0);
                currentElement.setFeature("discourse_function", (Object)DiscourseFunction.VERB_PHRASE);
                realisedElement.addComponent(currentElement);
                realisedElement.addComponent(splitVerb);
                for (int eachChild = 1; eachChild < children.size(); ++eachChild) {
                    currentElement = children.get(eachChild);
                    currentElement.setFeature("discourse_function", (Object)DiscourseFunction.VERB_PHRASE);
                    realisedElement.addComponent(currentElement);
                }
            } else {
                currentElement.setFeature("discourse_function", (Object)DiscourseFunction.VERB_PHRASE);
                if (whObj) {
                    realisedElement.addComponent(currentElement);
                    realisedElement.addComponent(splitVerb);
                } else {
                    realisedElement.addComponent(splitVerb);
                    realisedElement.addComponent(currentElement);
                }
            }
        }
    }

    private static void setVerbFeatures(PhraseElement phrase, NLGElement verbElement) {
    }

    private static NLGElement addPassiveComplementsNumberPerson(PhraseElement phrase, SyntaxProcessor parent, ListElement realisedElement, NLGElement verbElement) {
        Object passiveNumber = null;
        Person passivePerson = null;
        NLGElement currentElement = null;
        NLGElement splitVerb = null;
        NLGElement verbPhrase = phrase.getFeatureAsElement("verb_phrase");
        int numComps = 0;
        boolean coordSubj = false;
        if (phrase.getFeatureAsBoolean("passive").booleanValue() && verbPhrase != null && !InterrogativeType.WHAT_OBJECT.equals(phrase.getFeature("interrogative_type"))) {
            for (NLGElement subject : verbPhrase.getFeatureAsElementList("complements")) {
                if (!DiscourseFunction.OBJECT.equals(subject.getFeature("discourse_function"))) continue;
                subject.setFeature("passive", true);
                ++numComps;
                currentElement = parent.realise(subject);
                if (currentElement != null) {
                    currentElement.setFeature("discourse_function", (Object)DiscourseFunction.OBJECT);
                    if (phrase.hasFeature("interrogative_type")) {
                        splitVerb = currentElement;
                    } else {
                        realisedElement.addComponent(currentElement);
                    }
                }
                if (!coordSubj && subject instanceof CoordinatedPhraseElement) {
                    String conj = ((CoordinatedPhraseElement)subject).getConjunction();
                    coordSubj = conj != null && conj.equals("and");
                }
                passiveNumber = passiveNumber == null ? subject.getFeature("number") : NumberAgreement.PLURAL;
                if (Person.FIRST.equals(subject.getFeature("person"))) {
                    passivePerson = Person.FIRST;
                } else if (Person.SECOND.equals(subject.getFeature("person")) && !Person.FIRST.equals((Object)passivePerson)) {
                    passivePerson = Person.SECOND;
                } else if (passivePerson == null) {
                    passivePerson = Person.THIRD;
                }
                if (!Form.GERUND.equals(phrase.getFeature("form")) || phrase.getFeatureAsBoolean("suppress_genitive_in_gerund").booleanValue()) continue;
                subject.setFeature("possessive", true);
            }
        }
        if (verbElement != null) {
            if (passivePerson != null) {
                verbElement.setFeature("person", (Object)passivePerson);
            }
            if (numComps > 1 || coordSubj) {
                verbElement.setFeature("number", (Object)NumberAgreement.PLURAL);
            } else if (passiveNumber != null) {
                verbElement.setFeature("number", passiveNumber);
            }
        }
        return splitVerb;
    }

    private static void addSubjectsToFront(PhraseElement phrase, SyntaxProcessor parent, ListElement realisedElement, NLGElement splitVerb) {
        if (!(Form.INFINITIVE.equals(phrase.getFeature("form")) || Form.IMPERATIVE.equals(phrase.getFeature("form")) || phrase.getFeatureAsBoolean("passive").booleanValue() || splitVerb != null)) {
            realisedElement.addComponents(ClauseHelper.realiseSubjects(phrase, parent).getChildren());
        }
    }

    private static ListElement realiseSubjects(PhraseElement phrase, SyntaxProcessor parent) {
        NLGElement currentElement = null;
        ListElement realisedElement = new ListElement();
        for (NLGElement subject : phrase.getFeatureAsElementList("subjects")) {
            subject.setFeature("discourse_function", (Object)DiscourseFunction.SUBJECT);
            if (Form.GERUND.equals(phrase.getFeature("form")) && !phrase.getFeatureAsBoolean("suppress_genitive_in_gerund").booleanValue()) {
                subject.setFeature("possessive", true);
            }
            if ((currentElement = parent.realise(subject)) == null) continue;
            realisedElement.addComponent(currentElement);
        }
        return realisedElement;
    }

    private static NLGElement realiseInterrogative(PhraseElement phrase, SyntaxProcessor parent, ListElement realisedElement, NLGFactory phraseFactory, NLGElement verbElement) {
        Object type;
        NLGElement splitVerb = null;
        if (phrase.getParent() != null) {
            phrase.getParent().setFeature("interrogative", true);
        }
        if ((type = phrase.getFeature("interrogative_type")) instanceof InterrogativeType) {
            switch ((InterrogativeType)((Object)type)) {
                case YES_NO: {
                    splitVerb = ClauseHelper.realiseYesNo(phrase, parent, verbElement, phraseFactory, realisedElement);
                    break;
                }
                case WHO_SUBJECT: 
                case WHAT_SUBJECT: {
                    ClauseHelper.realiseInterrogativeKeyWord(((InterrogativeType)((Object)type)).getString(), LexicalCategory.PRONOUN, parent, realisedElement, phraseFactory);
                    phrase.removeFeature("subjects");
                    break;
                }
                case HOW_MANY: {
                    ClauseHelper.realiseInterrogativeKeyWord("how", LexicalCategory.PRONOUN, parent, realisedElement, phraseFactory);
                    ClauseHelper.realiseInterrogativeKeyWord("many", LexicalCategory.ADVERB, parent, realisedElement, phraseFactory);
                    break;
                }
                case HOW: 
                case WHY: 
                case WHERE: 
                case WHO_OBJECT: 
                case WHO_INDIRECT_OBJECT: 
                case WHAT_OBJECT: {
                    splitVerb = ClauseHelper.realiseObjectWHInterrogative(((InterrogativeType)((Object)type)).getString(), phrase, parent, realisedElement, phraseFactory);
                    break;
                }
                case HOW_PREDICATE: {
                    splitVerb = ClauseHelper.realiseObjectWHInterrogative("how", phrase, parent, realisedElement, phraseFactory);
                    break;
                }
            }
        }
        return splitVerb;
    }

    private static boolean hasAuxiliary(PhraseElement phrase) {
        return phrase.hasFeature("modal") || phrase.getFeatureAsBoolean("perfect") != false || phrase.getFeatureAsBoolean("progressive") != false || Tense.FUTURE.equals(phrase.getFeature("tense"));
    }

    private static NLGElement realiseObjectWHInterrogative(String keyword, PhraseElement phrase, SyntaxProcessor parent, ListElement realisedElement, NLGFactory phraseFactory) {
        ListElement splitVerb = null;
        ClauseHelper.realiseInterrogativeKeyWord(keyword, LexicalCategory.PRONOUN, parent, realisedElement, phraseFactory);
        if (!ClauseHelper.hasAuxiliary(phrase) && !VerbPhraseHelper.isCopular(phrase)) {
            ClauseHelper.addDoAuxiliary(phrase, parent, phraseFactory, realisedElement);
        } else if (!phrase.getFeatureAsBoolean("passive").booleanValue()) {
            splitVerb = ClauseHelper.realiseSubjects(phrase, parent);
        }
        return splitVerb;
    }

    private static void addDoAuxiliary(PhraseElement phrase, SyntaxProcessor parent, NLGFactory phraseFactory, ListElement realisedElement) {
        VPPhraseSpec doPhrase = phraseFactory.createVerbPhrase("do");
        doPhrase.setFeature("tense", phrase.getFeature("tense"));
        doPhrase.setFeature("person", phrase.getFeature("person"));
        doPhrase.setFeature("number", phrase.getFeature("number"));
        realisedElement.addComponent(parent.realise(doPhrase));
    }

    private static void realiseInterrogativeKeyWord(String keyWord, LexicalCategory cat, SyntaxProcessor parent, ListElement realisedElement, NLGFactory phraseFactory) {
        NLGElement question;
        NLGElement currentElement;
        if (keyWord != null && (currentElement = parent.realise(question = phraseFactory.createWord(keyWord, cat))) != null) {
            realisedElement.addComponent(currentElement);
        }
    }

    private static NLGElement realiseYesNo(PhraseElement phrase, SyntaxProcessor parent, NLGElement verbElement, NLGFactory phraseFactory, ListElement realisedElement) {
        ListElement splitVerb = null;
        if (!(verbElement instanceof VPPhraseSpec && VerbPhraseHelper.isCopular(((VPPhraseSpec)verbElement).getVerb()) || phrase.getFeatureAsBoolean("progressive").booleanValue() || phrase.hasFeature("modal") || Tense.FUTURE.equals(phrase.getFeature("tense")) || phrase.getFeatureAsBoolean("negated").booleanValue() || phrase.getFeatureAsBoolean("passive").booleanValue())) {
            ClauseHelper.addDoAuxiliary(phrase, parent, phraseFactory, realisedElement);
        } else {
            splitVerb = ClauseHelper.realiseSubjects(phrase, parent);
        }
        return splitVerb;
    }

    private static void addCuePhrase(PhraseElement phrase, SyntaxProcessor parent, ListElement realisedElement) {
        NLGElement currentElement = parent.realise(phrase.getFeatureAsElement("cue_phrase"));
        if (currentElement != null) {
            currentElement.setFeature("discourse_function", (Object)DiscourseFunction.CUE_PHRASE);
            realisedElement.addComponent(currentElement);
        }
    }

    private static void addComplementiser(PhraseElement phrase, SyntaxProcessor parent, ListElement realisedElement) {
        NLGElement currentElement;
        if (ClauseStatus.SUBORDINATE.equals(phrase.getFeature("clause_status")) && !phrase.getFeatureAsBoolean("suppressed_complementiser").booleanValue() && (currentElement = parent.realise(phrase.getFeatureAsElement("complementiser"))) != null) {
            realisedElement.addComponent(currentElement);
        }
    }

    private static void copyFrontModifiers(PhraseElement phrase, NLGElement verbElement) {
        List<NLGElement> frontModifiers = phrase.getFeatureAsElementList("front_modifiers");
        Object clauseForm = phrase.getFeature("form");
        if (verbElement != null) {
            List<NLGElement> phrasePostModifiers = phrase.getFeatureAsElementList("postmodifiers");
            if (verbElement instanceof PhraseElement) {
                List<NLGElement> verbPostModifiers = verbElement.getFeatureAsElementList("postmodifiers");
                for (NLGElement eachModifier : phrasePostModifiers) {
                    if (verbPostModifiers.contains(eachModifier)) continue;
                    ((PhraseElement)verbElement).addPostModifier(eachModifier);
                }
            }
        }
        if (Form.INFINITIVE.equals(clauseForm)) {
            phrase.setFeature("suppressed_complementiser", true);
            for (NLGElement eachModifier : frontModifiers) {
                if (!(verbElement instanceof PhraseElement)) continue;
                ((PhraseElement)verbElement).addPostModifier(eachModifier);
            }
            phrase.removeFeature("front_modifiers");
            if (verbElement != null) {
                verbElement.setFeature("non_morph", true);
            }
        }
    }

    private static void checkDiscourseFunction(PhraseElement phrase) {
        List<NLGElement> subjects = phrase.getFeatureAsElementList("subjects");
        Object clauseForm = phrase.getFeature("form");
        Object discourseValue = phrase.getFeature("discourse_function");
        if (DiscourseFunction.OBJECT.equals(discourseValue) || DiscourseFunction.INDIRECT_OBJECT.equals(discourseValue)) {
            if (Form.IMPERATIVE.equals(clauseForm)) {
                phrase.setFeature("suppressed_complementiser", true);
                phrase.setFeature("form", (Object)Form.INFINITIVE);
            } else if (Form.GERUND.equals(clauseForm) && subjects.size() == 0) {
                phrase.setFeature("suppressed_complementiser", true);
            }
        } else if (DiscourseFunction.SUBJECT.equals(discourseValue)) {
            phrase.setFeature("form", (Object)Form.GERUND);
            phrase.setFeature("suppressed_complementiser", true);
        }
    }

    private static void checkSubjectNumberPerson(PhraseElement phrase, NLGElement verbElement) {
        NLGElement currentElement = null;
        List<NLGElement> subjects = phrase.getFeatureAsElementList("subjects");
        boolean pluralSubjects = false;
        Person person = null;
        if (subjects != null) {
            switch (subjects.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    currentElement = subjects.get(0);
                    if (currentElement instanceof CoordinatedPhraseElement && ((CoordinatedPhraseElement)currentElement).checkIfPlural()) {
                        pluralSubjects = true;
                        break;
                    }
                    if (currentElement.getFeature("number") == NumberAgreement.PLURAL && !(currentElement instanceof SPhraseSpec)) {
                        pluralSubjects = true;
                        break;
                    }
                    if (!currentElement.isA(PhraseCategory.NOUN_PHRASE)) break;
                    NLGElement currentHead = currentElement.getFeatureAsElement("head");
                    person = (Person)((Object)currentElement.getFeature("person"));
                    if (currentHead == null) {
                        pluralSubjects = false;
                        break;
                    }
                    if (currentHead.getFeature("number") == NumberAgreement.PLURAL) {
                        pluralSubjects = true;
                        break;
                    }
                    if (!(currentHead instanceof ListElement)) break;
                    pluralSubjects = true;
                    break;
                }
                default: {
                    pluralSubjects = true;
                }
            }
        }
        if (verbElement != null) {
            verbElement.setFeature("number", pluralSubjects ? NumberAgreement.PLURAL : phrase.getFeature("number"));
            if (person != null) {
                verbElement.setFeature("person", (Object)person);
            }
        }
    }
}

