/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.syntax.english;

import java.util.ArrayList;
import java.util.List;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.Gender;
import simplenlg.features.Person;
import simplenlg.framework.InflectedWordElement;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.ListElement;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGFactory;
import simplenlg.framework.PhraseCategory;
import simplenlg.framework.PhraseElement;
import simplenlg.framework.WordElement;
import simplenlg.syntax.english.PhraseHelper;
import simplenlg.syntax.english.SyntaxProcessor;

abstract class NounPhraseHelper {
    private static final int QUALITATIVE_POSITION = 1;
    private static final int COLOUR_POSITION = 2;
    private static final int CLASSIFYING_POSITION = 3;
    private static final int NOUN_POSITION = 4;

    NounPhraseHelper() {
    }

    static NLGElement realise(SyntaxProcessor parent, PhraseElement phrase) {
        ListElement realisedElement = null;
        if (phrase != null && !phrase.getFeatureAsBoolean("elided").booleanValue()) {
            realisedElement = new ListElement();
            if (phrase.getFeatureAsBoolean("pronominal").booleanValue()) {
                realisedElement.addComponent(NounPhraseHelper.createPronoun(parent, phrase));
            } else {
                NounPhraseHelper.realiseSpecifier(phrase, parent, realisedElement);
                NounPhraseHelper.realisePreModifiers(phrase, parent, realisedElement);
                NounPhraseHelper.realiseHeadNoun(phrase, parent, realisedElement);
                PhraseHelper.realiseList(parent, realisedElement, phrase.getFeatureAsElementList("complements"), DiscourseFunction.COMPLEMENT);
                PhraseHelper.realiseList(parent, realisedElement, phrase.getPostModifiers(), DiscourseFunction.POST_MODIFIER);
            }
        }
        return realisedElement;
    }

    private static void realiseHeadNoun(PhraseElement phrase, SyntaxProcessor parent, ListElement realisedElement) {
        NLGElement headElement = phrase.getHead();
        if (headElement != null) {
            headElement.setFeature("elided", phrase.getFeature("elided"));
            headElement.setFeature("gender", phrase.getFeature("gender"));
            headElement.setFeature("acronym", phrase.getFeature("acronym"));
            headElement.setFeature("number", phrase.getFeature("number"));
            headElement.setFeature("person", phrase.getFeature("person"));
            headElement.setFeature("possessive", phrase.getFeature("possessive"));
            headElement.setFeature("passive", phrase.getFeature("passive"));
            NLGElement currentElement = parent.realise(headElement);
            currentElement.setFeature("discourse_function", (Object)DiscourseFunction.SUBJECT);
            realisedElement.addComponent(currentElement);
        }
    }

    private static void realisePreModifiers(PhraseElement phrase, SyntaxProcessor parent, ListElement realisedElement) {
        List<NLGElement> preModifiers = phrase.getPreModifiers();
        if (phrase.getFeatureAsBoolean("adjective_ordering").booleanValue()) {
            preModifiers = NounPhraseHelper.sortNPPreModifiers(preModifiers);
        }
        PhraseHelper.realiseList(parent, realisedElement, preModifiers, DiscourseFunction.PRE_MODIFIER);
    }

    private static void realiseSpecifier(PhraseElement phrase, SyntaxProcessor parent, ListElement realisedElement) {
        NLGElement specifierElement = phrase.getFeatureAsElement("specifier");
        if (specifierElement != null && !phrase.getFeatureAsBoolean("raised").booleanValue() && !phrase.getFeatureAsBoolean("elided").booleanValue()) {
            NLGElement currentElement;
            if (!specifierElement.isA(LexicalCategory.PRONOUN) && specifierElement.getCategory() != PhraseCategory.NOUN_PHRASE) {
                specifierElement.setFeature("number", phrase.getFeature("number"));
            }
            if ((currentElement = parent.realise(specifierElement)) != null) {
                currentElement.setFeature("discourse_function", (Object)DiscourseFunction.SPECIFIER);
                realisedElement.addComponent(currentElement);
            }
        }
    }

    private static List<NLGElement> sortNPPreModifiers(List<NLGElement> originalModifiers) {
        List<NLGElement> orderedModifiers = null;
        if (originalModifiers == null || originalModifiers.size() <= 1) {
            orderedModifiers = originalModifiers;
        } else {
            orderedModifiers = new ArrayList<NLGElement>(originalModifiers);
            boolean changesMade = false;
            do {
                changesMade = false;
                for (int i = 0; i < orderedModifiers.size() - 1; ++i) {
                    if (NounPhraseHelper.getMinPos(orderedModifiers.get(i)) <= NounPhraseHelper.getMaxPos(orderedModifiers.get(i + 1))) continue;
                    NLGElement temp = orderedModifiers.get(i);
                    orderedModifiers.set(i, orderedModifiers.get(i + 1));
                    orderedModifiers.set(i + 1, temp);
                    changesMade = true;
                }
            } while (changesMade);
        }
        return orderedModifiers;
    }

    private static int getMinPos(NLGElement modifier) {
        int position = 1;
        if (modifier.isA(LexicalCategory.NOUN) || modifier.isA(PhraseCategory.NOUN_PHRASE)) {
            position = 4;
        } else if (modifier.isA(LexicalCategory.ADJECTIVE) || modifier.isA(PhraseCategory.ADJECTIVE_PHRASE)) {
            WordElement adjective = NounPhraseHelper.getHeadWordElement(modifier);
            if (adjective.getFeatureAsBoolean("qualitative").booleanValue()) {
                position = 1;
            } else if (adjective.getFeatureAsBoolean("colour").booleanValue()) {
                position = 2;
            } else if (adjective.getFeatureAsBoolean("classifying").booleanValue()) {
                position = 3;
            }
        }
        return position;
    }

    private static int getMaxPos(NLGElement modifier) {
        int position = 4;
        if (modifier.isA(LexicalCategory.ADJECTIVE) || modifier.isA(PhraseCategory.ADJECTIVE_PHRASE)) {
            WordElement adjective = NounPhraseHelper.getHeadWordElement(modifier);
            position = adjective.getFeatureAsBoolean("classifying") != false ? 3 : (adjective.getFeatureAsBoolean("colour") != false ? 2 : (adjective.getFeatureAsBoolean("qualitative") != false ? 1 : 3));
        }
        return position;
    }

    private static WordElement getHeadWordElement(NLGElement element) {
        WordElement head = null;
        if (element instanceof WordElement) {
            head = (WordElement)element;
        } else if (element instanceof InflectedWordElement) {
            head = (WordElement)element.getFeature("base_word");
        } else if (element instanceof PhraseElement) {
            head = NounPhraseHelper.getHeadWordElement(((PhraseElement)element).getHead());
        }
        return head;
    }

    private static NLGElement createPronoun(SyntaxProcessor parent, PhraseElement phrase) {
        NLGElement element;
        String pronoun = "it";
        NLGFactory phraseFactory = phrase.getFactory();
        Object personValue = phrase.getFeature("person");
        if (Person.FIRST.equals(personValue)) {
            pronoun = "I";
        } else if (Person.SECOND.equals(personValue)) {
            pronoun = "you";
        } else {
            Object genderValue = phrase.getFeature("gender");
            if (Gender.FEMININE.equals(genderValue)) {
                pronoun = "she";
            } else if (Gender.MASCULINE.equals(genderValue)) {
                pronoun = "he";
            }
        }
        NLGElement proElement = phraseFactory.createWord(pronoun, LexicalCategory.PRONOUN);
        if (proElement instanceof WordElement) {
            element = new InflectedWordElement((WordElement)proElement);
            element.setFeature("gender", ((WordElement)proElement).getFeature("gender"));
            element.setFeature("person", ((WordElement)proElement).getFeature("person"));
        } else {
            element = proElement;
        }
        element.setFeature("discourse_function", (Object)DiscourseFunction.SPECIFIER);
        element.setFeature("possessive", phrase.getFeature("possessive"));
        element.setFeature("number", phrase.getFeature("number"));
        if (phrase.hasFeature("discourse_function")) {
            element.setFeature("discourse_function", phrase.getFeature("discourse_function"));
        }
        return element;
    }
}

