/*
 * Decompiled with CFR 0.152.
 */
package gate.util.compilers.eclipse.jdt.internal.compiler.ast;

import gate.util.compilers.eclipse.jdt.internal.compiler.CompilationResult;
import gate.util.compilers.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import gate.util.compilers.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.Expression;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import gate.util.compilers.eclipse.jdt.internal.compiler.flow.FlowInfo;
import gate.util.compilers.eclipse.jdt.internal.compiler.impl.Constant;
import gate.util.compilers.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.BlockScope;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.IntersectionCastTypeBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.MethodScope;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.Scope;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.TypeBindingVisitor;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public abstract class FunctionalExpression
extends Expression {
    protected TypeBinding expectedType;
    public MethodBinding descriptor;
    public MethodBinding binding;
    protected MethodBinding actualMethodBinding;
    boolean ignoreFurtherInvestigation;
    protected ExpressionContext expressionContext = ExpressionContext.VANILLA_CONTEXT;
    static Expression[] NO_EXPRESSIONS = new Expression[0];
    protected Expression[] resultExpressions = NO_EXPRESSIONS;
    public CompilationResult compilationResult;
    public BlockScope enclosingScope;
    protected boolean ellipsisArgument;
    public int bootstrapMethodNumber = -1;
    protected static IErrorHandlingPolicy silentErrorHandlingPolicy = DefaultErrorHandlingPolicies.ignoreAllProblems();
    private boolean hasReportedSamProblem = false;

    public FunctionalExpression(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    public FunctionalExpression() {
    }

    @Override
    public boolean isBoxingCompatibleWith(TypeBinding targetType, Scope scope) {
        return this.isCompatibleWith(targetType, scope);
    }

    public void setCompilationResult(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    public MethodBinding getMethodBinding() {
        return null;
    }

    @Override
    public void setExpectedType(TypeBinding expectedType) {
        this.expectedType = this.ellipsisArgument ? ((ArrayBinding)expectedType).elementsType() : expectedType;
    }

    @Override
    public void setExpressionContext(ExpressionContext context) {
        this.expressionContext = context;
    }

    @Override
    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    @Override
    public void tagAsEllipsisArgument() {
        this.ellipsisArgument = true;
    }

    @Override
    public boolean isPolyExpression(MethodBinding candidate) {
        return true;
    }

    @Override
    public boolean isPolyExpression() {
        return true;
    }

    @Override
    public boolean isPertinentToApplicability(TypeBinding targetType, MethodBinding method) {
        if (targetType instanceof TypeVariableBinding) {
            if (method != null) {
                if (((TypeVariableBinding)targetType).declaringElement == method) {
                    return false;
                }
                if (method.isConstructor() && ((TypeVariableBinding)targetType).declaringElement == method.declaringClass) {
                    return false;
                }
            } else {
                TypeVariableBinding typeVariable = (TypeVariableBinding)targetType;
                if (typeVariable.declaringElement instanceof MethodBinding) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public TypeBinding invocationTargetType() {
        if (this.expectedType == null) {
            return null;
        }
        MethodBinding sam = this.expectedType.getSingleAbstractMethod(this.enclosingScope, true);
        if (sam != null) {
            if (sam.isConstructor()) {
                return sam.declaringClass;
            }
            return sam.returnType;
        }
        return null;
    }

    @Override
    public TypeBinding expectedType() {
        return this.expectedType;
    }

    public boolean argumentsTypeElided() {
        return true;
    }

    public int recordFunctionalType(Scope scope) {
        while (scope != null) {
            switch (scope.kind) {
                case 2: {
                    LambdaExpression expression;
                    ReferenceContext context = ((MethodScope)scope).referenceContext;
                    if (!(context instanceof LambdaExpression) || (expression = (LambdaExpression)context) == expression.original) break;
                    return 0;
                }
                case 4: {
                    CompilationUnitDeclaration unit = ((CompilationUnitScope)scope).referenceContext;
                    return unit.record(this);
                }
            }
            scope = scope.parent;
        }
        return 0;
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        MethodBinding sam;
        this.constant = Constant.NotAConstant;
        this.enclosingScope = blockScope;
        MethodBinding methodBinding = sam = this.expectedType == null ? null : this.expectedType.getSingleAbstractMethod(blockScope, this.argumentsTypeElided());
        if (sam == null) {
            blockScope.problemReporter().targetTypeIsNotAFunctionalInterface(this);
            return null;
        }
        if (!sam.isValidBinding()) {
            return this.reportSamProblem(blockScope, sam);
        }
        this.descriptor = sam;
        if (this.kosherDescriptor(blockScope, sam, true)) {
            this.resolvedType = this.expectedType;
            return this.resolvedType;
        }
        this.resolvedType = null;
        return null;
    }

    protected TypeBinding reportSamProblem(BlockScope blockScope, MethodBinding sam) {
        if (this.hasReportedSamProblem) {
            return null;
        }
        switch (sam.problemId()) {
            case 17: {
                blockScope.problemReporter().targetTypeIsNotAFunctionalInterface(this);
                this.hasReportedSamProblem = true;
                break;
            }
            case 18: {
                blockScope.problemReporter().illFormedParameterizationOfFunctionalInterface(this);
                this.hasReportedSamProblem = true;
                break;
            }
            case 19: {
                blockScope.problemReporter().multipleFunctionalInterfaces(this);
                this.hasReportedSamProblem = true;
            }
        }
        return null;
    }

    @Override
    public TypeBinding checkAgainstFinalTargetType(TypeBinding targetType, Scope scope) {
        targetType = targetType.uncapture(this.enclosingScope);
        return this.resolveTypeExpecting(this.enclosingScope, targetType);
    }

    public boolean kosherDescriptor(Scope scope, MethodBinding sam, boolean shouldChatter) {
        VisibilityInspector inspector = new VisibilityInspector(this, scope, shouldChatter);
        boolean status = true;
        if (!inspector.visible(sam.returnType)) {
            status = false;
        }
        if (!inspector.visible(sam.parameters)) {
            status = false;
        }
        if (!inspector.visible(sam.thrownExceptions)) {
            status = false;
        }
        return status;
    }

    public int nullStatus(FlowInfo flowInfo) {
        return 4;
    }

    public int diagnosticsSourceEnd() {
        return this.sourceEnd;
    }

    public MethodBinding[] getRequiredBridges() {
        ReferenceBinding functionalType = this.expectedType instanceof IntersectionCastTypeBinding ? (ReferenceBinding)((IntersectionCastTypeBinding)this.expectedType).getSAMType(this.enclosingScope) : (ReferenceBinding)this.expectedType;
        class BridgeCollector {
            MethodBinding[] bridges;
            MethodBinding method;
            char[] selector;
            LookupEnvironment environment;
            Scope scope;

            BridgeCollector(ReferenceBinding functionalType, MethodBinding method) {
                this.method = method;
                this.selector = method.selector;
                this.environment = FunctionalExpression.this.enclosingScope.environment();
                this.scope = FunctionalExpression.this.enclosingScope;
                this.collectBridges(functionalType.superInterfaces());
            }

            void collectBridges(ReferenceBinding[] interfaces) {
                int length = interfaces == null ? 0 : interfaces.length;
                int i = 0;
                while (i < length) {
                    ReferenceBinding superInterface = interfaces[i];
                    if (superInterface != null) {
                        MethodBinding[] methods = superInterface.getMethods(this.selector);
                        int j = 0;
                        int count = methods == null ? 0 : methods.length;
                        while (j < count) {
                            MethodBinding originalInherited;
                            MethodBinding inheritedMethod = methods[j];
                            if (!(inheritedMethod == null || this.method == inheritedMethod || inheritedMethod.isStatic() || inheritedMethod.isDefaultMethod() || inheritedMethod.redeclaresPublicObjectMethod(this.scope) || (inheritedMethod = MethodVerifier.computeSubstituteMethod(inheritedMethod, this.method, this.environment)) == null || !MethodVerifier.isSubstituteParameterSubsignature(this.method, inheritedMethod, this.environment) || !MethodVerifier.areReturnTypesCompatible(this.method, inheritedMethod, this.environment) || this.method.areParameterErasuresEqual(originalInherited = inheritedMethod.original()) && !TypeBinding.notEquals(this.method.returnType.erasure(), originalInherited.returnType.erasure()))) {
                                this.add(originalInherited);
                            }
                            ++j;
                        }
                        this.collectBridges(superInterface.superInterfaces());
                    }
                    ++i;
                }
            }

            void add(MethodBinding inheritedMethod) {
                if (this.bridges == null) {
                    this.bridges = new MethodBinding[]{inheritedMethod};
                    return;
                }
                int length = this.bridges.length;
                int i = 0;
                while (i < length) {
                    if (this.bridges[i].areParameterErasuresEqual(inheritedMethod) && TypeBinding.equalsEquals(this.bridges[i].returnType.erasure(), inheritedMethod.returnType.erasure())) {
                        return;
                    }
                    ++i;
                }
                this.bridges = new MethodBinding[length + 1];
                System.arraycopy(this.bridges, 0, this.bridges, 0, length);
                this.bridges[length] = inheritedMethod;
            }

            MethodBinding[] getBridges() {
                return this.bridges;
            }
        }
        return new BridgeCollector(functionalType, this.descriptor).getBridges();
    }

    boolean requiresBridges() {
        return this.getRequiredBridges() != null;
    }

    class VisibilityInspector
    extends TypeBindingVisitor {
        private Scope scope;
        private boolean shouldChatter;
        private boolean visible = true;
        private FunctionalExpression expression;

        public VisibilityInspector(FunctionalExpression expression, Scope scope, boolean shouldChatter) {
            this.scope = scope;
            this.shouldChatter = shouldChatter;
            this.expression = expression;
        }

        private void checkVisibility(ReferenceBinding referenceBinding) {
            if (!referenceBinding.canBeSeenBy(this.scope)) {
                this.visible = false;
                if (this.shouldChatter) {
                    this.scope.problemReporter().descriptorHasInvisibleType(this.expression, referenceBinding);
                }
            }
        }

        @Override
        public boolean visit(ReferenceBinding referenceBinding) {
            this.checkVisibility(referenceBinding);
            return true;
        }

        @Override
        public boolean visit(ParameterizedTypeBinding parameterizedTypeBinding) {
            this.checkVisibility(parameterizedTypeBinding);
            return true;
        }

        @Override
        public boolean visit(RawTypeBinding rawTypeBinding) {
            this.checkVisibility(rawTypeBinding);
            return true;
        }

        public boolean visible(TypeBinding type) {
            TypeBindingVisitor.visit((TypeBindingVisitor)this, type);
            return this.visible;
        }

        public boolean visible(TypeBinding[] types) {
            TypeBindingVisitor.visit((TypeBindingVisitor)this, types);
            return this.visible;
        }
    }
}

