/*
 * Decompiled with CFR 0.152.
 */
package gate.util.compilers.eclipse.jdt.internal.compiler.ast;

import gate.util.compilers.eclipse.jdt.internal.compiler.ASTVisitor;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.CharLiteral;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.ExtendedStringLiteral;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.Literal;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.StringLiteralConcatenation;
import gate.util.compilers.eclipse.jdt.internal.compiler.codegen.CodeStream;
import gate.util.compilers.eclipse.jdt.internal.compiler.impl.StringConstant;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.BlockScope;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class StringLiteral
extends Literal {
    char[] source;
    int lineNumber;

    public StringLiteral(char[] token, int start, int end, int lineNumber) {
        this(start, end);
        this.source = token;
        this.lineNumber = lineNumber - 1;
    }

    public StringLiteral(int s, int e) {
        super(s, e);
    }

    @Override
    public void computeConstant() {
        this.constant = StringConstant.fromValue(String.valueOf(this.source));
    }

    public ExtendedStringLiteral extendWith(CharLiteral lit) {
        return new ExtendedStringLiteral(this, lit);
    }

    public ExtendedStringLiteral extendWith(StringLiteral lit) {
        return new ExtendedStringLiteral(this, lit);
    }

    public StringLiteralConcatenation extendsWith(StringLiteral lit) {
        return new StringLiteralConcatenation(this, lit);
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (valueRequired) {
            codeStream.ldc(this.constant.stringValue());
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    @Override
    public TypeBinding literalType(BlockScope scope) {
        return scope.getJavaLangString();
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append('\"');
        int i = 0;
        while (i < this.source.length) {
            switch (this.source[i]) {
                case '\b': {
                    output.append("\\b");
                    break;
                }
                case '\t': {
                    output.append("\\t");
                    break;
                }
                case '\n': {
                    output.append("\\n");
                    break;
                }
                case '\f': {
                    output.append("\\f");
                    break;
                }
                case '\r': {
                    output.append("\\r");
                    break;
                }
                case '\"': {
                    output.append("\\\"");
                    break;
                }
                case '\'': {
                    output.append("\\'");
                    break;
                }
                case '\\': {
                    output.append("\\\\");
                    break;
                }
                default: {
                    output.append(this.source[i]);
                }
            }
            ++i;
        }
        output.append('\"');
        return output;
    }

    @Override
    public char[] source() {
        return this.source;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }
}

