/*
 * Decompiled with CFR 0.152.
 */
package gate.util.compilers.eclipse.jdt.internal.compiler.lookup;

import gate.util.compilers.eclipse.jdt.internal.compiler.ast.ASTNode;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.Argument;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import gate.util.compilers.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.Binding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.Scope;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ImplicitNullAnnotationVerifier {
    ImplicitNullAnnotationVerifier buddyImplicitNullAnnotationsVerifier;
    private boolean inheritNullAnnotations;
    protected LookupEnvironment environment;

    public ImplicitNullAnnotationVerifier(LookupEnvironment environment, boolean inheritNullAnnotations) {
        this.buddyImplicitNullAnnotationsVerifier = this;
        this.inheritNullAnnotations = inheritNullAnnotations;
        this.environment = environment;
    }

    ImplicitNullAnnotationVerifier(LookupEnvironment environment) {
        CompilerOptions options = environment.globalOptions;
        this.buddyImplicitNullAnnotationsVerifier = new ImplicitNullAnnotationVerifier(environment, options.inheritNullAnnotations);
        this.inheritNullAnnotations = options.inheritNullAnnotations;
        this.environment = environment;
    }

    public void checkImplicitNullAnnotations(MethodBinding currentMethod, AbstractMethodDeclaration srcMethod, boolean complain, Scope scope) {
        try {
            ReferenceBinding currentType = currentMethod.declaringClass;
            if (currentType.id == 1) {
                return;
            }
            boolean needToApplyNonNullDefault = currentMethod.hasNonNullDefault();
            boolean isInstanceMethod = !currentMethod.isConstructor() && !currentMethod.isStatic();
            if (!(needToApplyNonNullDefault || (complain &= isInstanceMethod) || this.inheritNullAnnotations && isInstanceMethod)) {
                return;
            }
            if (isInstanceMethod) {
                int length;
                ArrayList superMethodList = new ArrayList();
                if (currentType instanceof SourceTypeBinding && !currentType.isHierarchyConnected() && !currentType.isAnonymousType()) {
                    ((SourceTypeBinding)currentType).scope.connectTypeHierarchy();
                }
                int paramLen = currentMethod.parameters.length;
                this.findAllOverriddenMethods(currentMethod.original(), currentMethod.selector, paramLen, currentType, new HashSet(), superMethodList);
                InheritedNonNullnessInfo[] inheritedNonNullnessInfos = new InheritedNonNullnessInfo[paramLen + 1];
                int i = 0;
                while (i < paramLen + 1) {
                    inheritedNonNullnessInfos[i] = new InheritedNonNullnessInfo();
                    ++i;
                }
                int i2 = length = superMethodList.size();
                while (--i2 >= 0) {
                    MethodBinding currentSuper = (MethodBinding)superMethodList.get(i2);
                    if ((currentSuper.tagBits & 0x1000L) == 0L) {
                        this.checkImplicitNullAnnotations(currentSuper, null, false, scope);
                    }
                    this.checkNullSpecInheritance(currentMethod, srcMethod, needToApplyNonNullDefault, complain, currentSuper, scope, inheritedNonNullnessInfos);
                    needToApplyNonNullDefault = false;
                }
                long sourceLevel = scope.compilerOptions().sourceLevel;
                InheritedNonNullnessInfo info = inheritedNonNullnessInfos[0];
                if (!info.complained) {
                    long tagBits = 0L;
                    if (info.inheritedNonNullness == Boolean.TRUE) {
                        tagBits = 0x100000000000000L;
                    } else if (info.inheritedNonNullness == Boolean.FALSE) {
                        tagBits = 0x80000000000000L;
                    }
                    if (tagBits != 0L) {
                        if (sourceLevel < 0x340000L) {
                            currentMethod.tagBits |= tagBits;
                        } else if (!currentMethod.returnType.isBaseType()) {
                            LookupEnvironment env = scope.environment();
                            currentMethod.returnType = env.createAnnotatedType(currentMethod.returnType, env.nullAnnotationsFromTagBits(tagBits));
                        }
                    }
                }
                int i3 = 0;
                while (i3 < paramLen) {
                    info = inheritedNonNullnessInfos[i3 + 1];
                    if (!info.complained && info.inheritedNonNullness != null) {
                        Argument currentArg;
                        Argument argument = currentArg = srcMethod == null ? null : srcMethod.arguments[i3];
                        if (sourceLevel < 0x340000L) {
                            this.recordArgNonNullness(currentMethod, paramLen, i3, currentArg, info.inheritedNonNullness);
                        } else {
                            this.recordArgNonNullness18(currentMethod, i3, currentArg, info.inheritedNonNullness, scope.environment());
                        }
                    }
                    ++i3;
                }
            }
            if (needToApplyNonNullDefault) {
                if (scope.compilerOptions().sourceLevel < 0x340000L) {
                    currentMethod.fillInDefaultNonNullness(srcMethod);
                } else {
                    currentMethod.fillInDefaultNonNullness18(srcMethod, scope.environment());
                }
            }
        }
        finally {
            currentMethod.tagBits |= 0x1000L;
        }
    }

    private void findAllOverriddenMethods(MethodBinding original, char[] selector, int suggestedParameterLength, ReferenceBinding currentType, Set ifcsSeen, List result) {
        if (currentType.id == 1) {
            return;
        }
        this.collectOverriddenMethods(original, selector, suggestedParameterLength, currentType.superclass(), ifcsSeen, result);
        ReferenceBinding[] superInterfaces = currentType.superInterfaces();
        int ifcLen = superInterfaces.length;
        int i = 0;
        while (i < ifcLen) {
            ReferenceBinding currentIfc = superInterfaces[i];
            if (ifcsSeen.add(currentIfc.original())) {
                this.collectOverriddenMethods(original, selector, suggestedParameterLength, currentIfc, ifcsSeen, result);
            }
            ++i;
        }
    }

    private void collectOverriddenMethods(MethodBinding original, char[] selector, int suggestedParameterLength, ReferenceBinding superType, Set ifcsSeen, List result) {
        MethodBinding[] ifcMethods = superType.getMethods(selector, suggestedParameterLength);
        int length = ifcMethods.length;
        int i = 0;
        while (i < length) {
            MethodBinding currentMethod = ifcMethods[i];
            if (!currentMethod.isStatic() && MethodVerifier.doesMethodOverride(original, currentMethod, this.environment)) {
                result.add(currentMethod);
                return;
            }
            ++i;
        }
        this.findAllOverriddenMethods(original, selector, suggestedParameterLength, superType, ifcsSeen, result);
    }

    /*
     * Unable to fully structure code
     */
    void checkNullSpecInheritance(MethodBinding currentMethod, AbstractMethodDeclaration srcMethod, boolean hasNonNullDefault, boolean shouldComplain, MethodBinding inheritedMethod, Scope scope, InheritedNonNullnessInfo[] inheritedNonNullnessInfos) {
        block32: {
            block33: {
                block34: {
                    if ((inheritedMethod.tagBits & 4096L) == 0L) {
                        this.buddyImplicitNullAnnotationsVerifier.checkImplicitNullAnnotations(inheritedMethod, null, false, scope);
                    }
                    useTypeAnnotations = this.environment.globalOptions.sourceLevel >= 0x340000L;
                    inheritedNullnessBits = this.getReturnTypeNullnessTagBits(inheritedMethod, useTypeAnnotations);
                    currentNullnessBits = this.getReturnTypeNullnessTagBits(currentMethod, useTypeAnnotations);
                    shouldInherit = this.inheritNullAnnotations;
                    if (currentMethod.returnType == null || currentMethod.returnType.isBaseType()) break block32;
                    if (currentNullnessBits != 0L) break block33;
                    if (!shouldInherit || inheritedNullnessBits == 0L) break block34;
                    if (hasNonNullDefault && shouldComplain && inheritedNullnessBits == 0x80000000000000L) {
                        scope.problemReporter().conflictingNullAnnotations(currentMethod, ((MethodDeclaration)srcMethod).returnType, inheritedMethod);
                    }
                    if (inheritedNonNullnessInfos != null && srcMethod != null) {
                        this.recordDeferredInheritedNullness(scope, ((MethodDeclaration)srcMethod).returnType, inheritedMethod, inheritedNullnessBits == 0x100000000000000L, inheritedNonNullnessInfos[0]);
                    } else {
                        this.applyReturnNullBits(currentMethod, inheritedNullnessBits);
                    }
                    break block32;
                }
                if (hasNonNullDefault) {
                    currentNullnessBits = 0x100000000000000L;
                    this.applyReturnNullBits(currentMethod, currentNullnessBits);
                }
            }
            if (!shouldComplain) break block32;
            if ((inheritedNullnessBits & 0x100000000000000L) == 0L || currentNullnessBits == 0x100000000000000L) ** GOTO lbl29
            if (srcMethod != null) {
                scope.problemReporter().illegalReturnRedefinition(srcMethod, inheritedMethod, this.environment.getNonNullAnnotationName());
            } else {
                scope.problemReporter().cannotImplementIncompatibleNullness(currentMethod, inheritedMethod, useTypeAnnotations);
                return;
lbl29:
                // 1 sources

                if (useTypeAnnotations && NullAnnotationMatching.analyse(inheritedMethod.returnType, currentMethod.returnType, 0, true).isAnyMismatch()) {
                    scope.problemReporter().cannotImplementIncompatibleNullness(currentMethod, inheritedMethod, useTypeAnnotations);
                    return;
                }
            }
        }
        currentArguments = srcMethod == null ? null : srcMethod.arguments;
        length = 0;
        if (currentArguments != null) {
            length = currentArguments.length;
        }
        if (useTypeAnnotations) {
            length = currentMethod.parameters.length;
        } else if (inheritedMethod.parameterNonNullness != null) {
            length = inheritedMethod.parameterNonNullness.length;
        } else if (currentMethod.parameterNonNullness != null) {
            length = currentMethod.parameterNonNullness.length;
        }
        i = 0;
        while (i < length) {
            block35: {
                block38: {
                    block36: {
                        block37: {
                            if (currentMethod.parameters[i].isBaseType()) break block35;
                            currentArgument = currentArguments == null ? null : currentArguments[i];
                            inheritedNonNullNess = this.getParameterNonNullness(inheritedMethod, i, useTypeAnnotations);
                            currentNonNullNess = this.getParameterNonNullness(currentMethod, i, useTypeAnnotations);
                            if (currentNonNullNess != null) break block36;
                            if (inheritedNonNullNess == null || !shouldInherit) break block37;
                            if (hasNonNullDefault && shouldComplain && inheritedNonNullNess == Boolean.FALSE && currentArgument != null) {
                                scope.problemReporter().conflictingNullAnnotations(currentMethod, currentArgument, inheritedMethod);
                            }
                            if (inheritedNonNullnessInfos != null && srcMethod != null) {
                                this.recordDeferredInheritedNullness(scope, srcMethod.arguments[i].type, inheritedMethod, inheritedNonNullNess, inheritedNonNullnessInfos[i + 1]);
                            } else if (!useTypeAnnotations) {
                                this.recordArgNonNullness(currentMethod, length, i, currentArgument, inheritedNonNullNess);
                            } else {
                                this.recordArgNonNullness18(currentMethod, i, currentArgument, inheritedNonNullNess, this.environment);
                            }
                            break block35;
                        }
                        if (hasNonNullDefault) {
                            currentNonNullNess = Boolean.TRUE;
                            if (!useTypeAnnotations) {
                                this.recordArgNonNullness(currentMethod, length, i, currentArgument, Boolean.TRUE);
                            } else {
                                this.recordArgNonNullness18(currentMethod, i, currentArgument, Boolean.TRUE, this.environment);
                            }
                        }
                    }
                    if (!shouldComplain) break block35;
                    annotationName = inheritedNonNullNess == Boolean.TRUE ? this.environment.getNonNullAnnotationName() : this.environment.getNullableAnnotationName();
                    if (inheritedNonNullNess == Boolean.TRUE || currentNonNullNess != Boolean.TRUE) break block38;
                    if (currentArgument != null) {
                        scope.problemReporter().illegalRedefinitionToNonNullParameter(currentArgument, inheritedMethod.declaringClass, inheritedNonNullNess == null ? null : this.environment.getNullableAnnotationName());
                    } else {
                        scope.problemReporter().cannotImplementIncompatibleNullness(currentMethod, inheritedMethod, false);
                    }
                    break block35;
                }
                if (currentNonNullNess != null) ** GOTO lbl-1000
                if (inheritedNonNullNess == Boolean.FALSE) {
                    if (currentArgument != null) {
                        scope.problemReporter().parameterLackingNullableAnnotation(currentArgument, inheritedMethod.declaringClass, annotationName);
                    } else {
                        scope.problemReporter().cannotImplementIncompatibleNullness(currentMethod, inheritedMethod, false);
                    }
                } else if (inheritedNonNullNess == Boolean.TRUE) {
                    scope.problemReporter().parameterLackingNonnullAnnotation(currentArgument, inheritedMethod.declaringClass, annotationName);
                } else if (useTypeAnnotations && NullAnnotationMatching.analyse(currentMethod.parameters[i], inheritedMethod.parameters[i], 0, true).isAnyMismatch()) {
                    scope.problemReporter().cannotImplementIncompatibleNullness(currentMethod, inheritedMethod, false);
                }
            }
            ++i;
        }
    }

    void applyReturnNullBits(MethodBinding method, long nullnessBits) {
        if (this.environment.globalOptions.sourceLevel < 0x340000L) {
            method.tagBits |= nullnessBits;
        } else if (!method.returnType.isBaseType()) {
            method.returnType = this.environment.createAnnotatedType(method.returnType, this.environment.nullAnnotationsFromTagBits(nullnessBits));
        }
    }

    private Boolean getParameterNonNullness(MethodBinding method, int i, boolean useTypeAnnotations) {
        if (useTypeAnnotations) {
            long nullBits;
            TypeBinding parameter = method.parameters[i];
            if (parameter != null && (nullBits = NullAnnotationMatching.validNullTagBits(parameter.tagBits)) != 0L) {
                return nullBits == 0x100000000000000L;
            }
            return null;
        }
        return method.parameterNonNullness == null ? null : method.parameterNonNullness[i];
    }

    private long getReturnTypeNullnessTagBits(MethodBinding method, boolean useTypeAnnotations) {
        if (useTypeAnnotations) {
            if (method.returnType == null) {
                return 0L;
            }
            return NullAnnotationMatching.validNullTagBits(method.returnType.tagBits);
        }
        return method.tagBits & 0x180000000000000L;
    }

    protected void recordDeferredInheritedNullness(Scope scope, ASTNode location, MethodBinding inheritedMethod, Boolean inheritedNonNullness, InheritedNonNullnessInfo nullnessInfo) {
        if (nullnessInfo.inheritedNonNullness != null && nullnessInfo.inheritedNonNullness != inheritedNonNullness) {
            scope.problemReporter().conflictingInheritedNullAnnotations(location, nullnessInfo.inheritedNonNullness, nullnessInfo.annotationOrigin, inheritedNonNullness, inheritedMethod);
            nullnessInfo.complained = true;
        } else {
            nullnessInfo.inheritedNonNullness = inheritedNonNullness;
            nullnessInfo.annotationOrigin = inheritedMethod;
        }
    }

    void recordArgNonNullness(MethodBinding method, int paramCount, int paramIdx, Argument currentArgument, Boolean nonNullNess) {
        if (method.parameterNonNullness == null) {
            method.parameterNonNullness = new Boolean[paramCount];
        }
        method.parameterNonNullness[paramIdx] = nonNullNess;
        if (currentArgument != null) {
            currentArgument.binding.tagBits = currentArgument.binding.tagBits | (nonNullNess != false ? 0x100000000000000L : 0x80000000000000L);
        }
    }

    void recordArgNonNullness18(MethodBinding method, int paramIdx, Argument currentArgument, Boolean nonNullNess, LookupEnvironment env) {
        AnnotationBinding annotationBinding = nonNullNess != false ? env.getNonNullAnnotation() : env.getNullableAnnotation();
        method.parameters[paramIdx] = env.createAnnotatedType(method.parameters[paramIdx], new AnnotationBinding[]{annotationBinding});
        if (currentArgument != null) {
            currentArgument.binding.type = method.parameters[paramIdx];
        }
    }

    static boolean areParametersEqual(MethodBinding one, MethodBinding two) {
        TypeBinding[] oneArgs = one.parameters;
        TypeBinding[] twoArgs = two.parameters;
        if (oneArgs == twoArgs) {
            return true;
        }
        int length = oneArgs.length;
        if (length != twoArgs.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!ImplicitNullAnnotationVerifier.areTypesEqual(oneArgs[i], twoArgs[i])) {
                if (oneArgs[i].leafComponentType().isRawType() && oneArgs[i].dimensions() == twoArgs[i].dimensions() && oneArgs[i].leafComponentType().isEquivalentTo(twoArgs[i].leafComponentType())) {
                    if (one.typeVariables != Binding.NO_TYPE_VARIABLES) {
                        return false;
                    }
                    int j = 0;
                    while (j < i) {
                        if (oneArgs[j].leafComponentType().isParameterizedTypeWithActualArguments()) {
                            return false;
                        }
                        ++j;
                    }
                    break;
                }
                return false;
            }
            ++i;
        }
        ++i;
        while (i < length) {
            if (!ImplicitNullAnnotationVerifier.areTypesEqual(oneArgs[i], twoArgs[i])) {
                if (!oneArgs[i].leafComponentType().isRawType() || oneArgs[i].dimensions() != twoArgs[i].dimensions() || !oneArgs[i].leafComponentType().isEquivalentTo(twoArgs[i].leafComponentType())) {
                    return false;
                }
            } else if (oneArgs[i].leafComponentType().isParameterizedTypeWithActualArguments()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    static boolean areTypesEqual(TypeBinding one, TypeBinding two) {
        if (TypeBinding.equalsEquals(one, two)) {
            return true;
        }
        switch (one.kind()) {
            case 4: {
                switch (two.kind()) {
                    case 260: 
                    case 1028: {
                        if (!TypeBinding.equalsEquals(one, two.erasure())) break;
                        return true;
                    }
                }
                break;
            }
            case 260: 
            case 1028: {
                switch (two.kind()) {
                    case 4: {
                        if (!TypeBinding.equalsEquals(one.erasure(), two)) break;
                        return true;
                    }
                }
                break;
            }
        }
        if (one.isParameterizedType() && two.isParameterizedType()) {
            return one.isEquivalentTo(two) && two.isEquivalentTo(one);
        }
        return false;
    }

    static class InheritedNonNullnessInfo {
        Boolean inheritedNonNullness;
        MethodBinding annotationOrigin;
        boolean complained;

        InheritedNonNullnessInfo() {
        }
    }
}

