/*
 * Decompiled with CFR 0.152.
 */
package gate.util.compilers.eclipse.jdt.internal.compiler.lookup;

import gate.util.compilers.eclipse.jdt.core.compiler.CharOperation;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.ASTNode;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.Annotation;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import gate.util.compilers.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import gate.util.compilers.eclipse.jdt.internal.compiler.impl.Constant;
import gate.util.compilers.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.Binding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.BlockScope;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.MethodScope;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.Scope;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import gate.util.compilers.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class LocalVariableBinding
extends VariableBinding {
    public int resolvedPosition;
    public static final int UNUSED = 0;
    public static final int USED = 1;
    public static final int FAKE_USED = 2;
    public int useFlag;
    public BlockScope declaringScope;
    public LocalDeclaration declaration;
    public int[] initializationPCs;
    public int initializationCount = 0;
    public FakedTrackingVariable closeTracker;

    public LocalVariableBinding(char[] name, TypeBinding type, int modifiers, boolean isArgument) {
        super(name, type, modifiers, isArgument ? Constant.NotAConstant : null);
        if (isArgument) {
            this.tagBits |= 0x400L;
        }
        this.tagBits |= 0x800L;
    }

    public LocalVariableBinding(LocalDeclaration declaration, TypeBinding type, int modifiers, boolean isArgument) {
        this(declaration.name, type, modifiers, isArgument);
        this.declaration = declaration;
    }

    public LocalVariableBinding(LocalDeclaration declaration, TypeBinding type, int modifiers, MethodScope declaringScope) {
        this(declaration, type, modifiers, true);
        this.declaringScope = declaringScope;
    }

    @Override
    public final int kind() {
        return 2;
    }

    @Override
    public char[] computeUniqueKey(boolean isLeaf) {
        StringBuffer buffer = new StringBuffer();
        BlockScope scope = this.declaringScope;
        int occurenceCount = 0;
        if (scope != null) {
            MethodBinding methodBinding;
            MethodScope methodScope = scope instanceof MethodScope ? (MethodScope)scope : scope.enclosingMethodScope();
            ReferenceContext referenceContext = methodScope.referenceContext;
            if (referenceContext instanceof AbstractMethodDeclaration) {
                methodBinding = ((AbstractMethodDeclaration)referenceContext).binding;
                if (methodBinding != null) {
                    buffer.append(methodBinding.computeUniqueKey(false));
                }
            } else if (referenceContext instanceof TypeDeclaration) {
                SourceTypeBinding typeBinding = ((TypeDeclaration)referenceContext).binding;
                if (typeBinding != null) {
                    buffer.append(((Binding)typeBinding).computeUniqueKey(false));
                }
            } else if (referenceContext instanceof LambdaExpression && (methodBinding = ((LambdaExpression)referenceContext).binding) != null) {
                buffer.append(methodBinding.computeUniqueKey(false));
            }
            this.getScopeKey(scope, buffer);
            LocalVariableBinding[] locals = scope.locals;
            int i = 0;
            while (i < scope.localIndex) {
                LocalVariableBinding local = locals[i];
                if (CharOperation.equals(this.name, local.name)) {
                    if (this == local) break;
                    ++occurenceCount;
                }
                ++i;
            }
        }
        buffer.append('#');
        buffer.append(this.name);
        if (occurenceCount > 0) {
            buffer.append('#');
            buffer.append(occurenceCount);
        }
        int length = buffer.length();
        char[] uniqueKey = new char[length];
        buffer.getChars(0, length, uniqueKey, 0);
        return uniqueKey;
    }

    @Override
    public AnnotationBinding[] getAnnotations() {
        Annotation[] annotationNodes;
        if (this.declaringScope == null) {
            if ((this.tagBits & 0x200000000L) != 0L) {
                if (this.declaration == null) {
                    return Binding.NO_ANNOTATIONS;
                }
                Annotation[] annotations = this.declaration.annotations;
                if (annotations != null) {
                    int length = annotations.length;
                    AnnotationBinding[] annotationBindings = new AnnotationBinding[length];
                    int i = 0;
                    while (i < length) {
                        AnnotationBinding compilerAnnotation = annotations[i].getCompilerAnnotation();
                        if (compilerAnnotation == null) {
                            return Binding.NO_ANNOTATIONS;
                        }
                        annotationBindings[i] = compilerAnnotation;
                        ++i;
                    }
                    return annotationBindings;
                }
            }
            return Binding.NO_ANNOTATIONS;
        }
        SourceTypeBinding sourceType = this.declaringScope.enclosingSourceType();
        if (sourceType == null) {
            return Binding.NO_ANNOTATIONS;
        }
        if ((this.tagBits & 0x200000000L) == 0L && (this.tagBits & 0x400L) != 0L && this.declaration != null && (annotationNodes = this.declaration.annotations) != null) {
            ASTNode.resolveAnnotations(this.declaringScope, annotationNodes, this, true);
        }
        return sourceType.retrieveAnnotations(this);
    }

    private void getScopeKey(BlockScope scope, StringBuffer buffer) {
        int scopeIndex = scope.scopeIndex();
        if (scopeIndex != -1) {
            this.getScopeKey((BlockScope)scope.parent, buffer);
            buffer.append('#');
            buffer.append(scopeIndex);
        }
    }

    public boolean isSecret() {
        return this.declaration == null && (this.tagBits & 0x400L) == 0L;
    }

    public void recordInitializationEndPC(int pc) {
        if (this.initializationPCs[(this.initializationCount - 1 << 1) + 1] == -1) {
            this.initializationPCs[(this.initializationCount - 1 << 1) + 1] = pc;
        }
    }

    public void recordInitializationStartPC(int pc) {
        int index;
        if (this.initializationPCs == null) {
            return;
        }
        if (this.initializationCount > 0) {
            int previousEndPC = this.initializationPCs[(this.initializationCount - 1 << 1) + 1];
            if (previousEndPC == -1) {
                return;
            }
            if (previousEndPC == pc) {
                this.initializationPCs[(this.initializationCount - 1 << 1) + 1] = -1;
                return;
            }
        }
        if ((index = this.initializationCount << 1) == this.initializationPCs.length) {
            this.initializationPCs = new int[this.initializationCount << 2];
            System.arraycopy(this.initializationPCs, 0, this.initializationPCs, 0, index);
        }
        this.initializationPCs[index] = pc;
        this.initializationPCs[index + 1] = -1;
        ++this.initializationCount;
    }

    @Override
    public void setAnnotations(AnnotationBinding[] annotations, Scope scope) {
        if (scope == null) {
            return;
        }
        SourceTypeBinding sourceType = scope.enclosingSourceType();
        if (sourceType != null) {
            sourceType.storeAnnotations(this, annotations);
        }
    }

    public void resetInitializations() {
        this.initializationCount = 0;
        this.initializationPCs = null;
    }

    @Override
    public String toString() {
        String s = super.toString();
        switch (this.useFlag) {
            case 1: {
                s = String.valueOf(s) + "[pos: " + String.valueOf(this.resolvedPosition) + "]";
                break;
            }
            case 0: {
                s = String.valueOf(s) + "[pos: unused]";
                break;
            }
            case 2: {
                s = String.valueOf(s) + "[pos: fake_used]";
            }
        }
        s = String.valueOf(s) + "[id:" + String.valueOf(this.id) + "]";
        if (this.initializationCount > 0) {
            s = String.valueOf(s) + "[pc: ";
            int i = 0;
            while (i < this.initializationCount) {
                if (i > 0) {
                    s = String.valueOf(s) + ", ";
                }
                s = String.valueOf(s) + String.valueOf(this.initializationPCs[i << 1]) + "-" + (this.initializationPCs[(i << 1) + 1] == -1 ? "?" : String.valueOf(this.initializationPCs[(i << 1) + 1]));
                ++i;
            }
            s = String.valueOf(s) + "]";
        }
        return s;
    }

    @Override
    public boolean isParameter() {
        return (this.tagBits & 0x400L) != 0L;
    }

    public boolean isCatchParameter() {
        return false;
    }
}

