/*
 * Decompiled with CFR 0.152.
 */
package gate.lib.interaction.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessBase {
    protected List<String> command = new ArrayList<String>();
    protected ProcessBuilder builder = null;
    protected Process process = null;
    protected File workingDir = new File(".");
    protected Thread loggerThread;
    protected Map<String, String> envvars = new HashMap<String, String>();
    protected boolean stopRequested = false;

    public boolean ensureProcess() {
        if (this.need2start()) {
            this.builder = new ProcessBuilder(this.command);
            this.builder.directory(this.workingDir);
            Map<String, String> env = this.builder.environment();
            env.putAll(this.envvars);
            try {
                this.process = this.builder.start();
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not start the process " + this.command, ex);
            }
            this.setupInteraction();
            return true;
        }
        return false;
    }

    public abstract Object process(Object var1);

    public boolean isAlive() {
        return !this.need2start();
    }

    public int stop(int timeoutPerStage) {
        this.stopRequested = true;
        this.stopInteraction();
        try {
            this.process.waitFor(timeoutPerStage, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.process.isAlive()) {
            return this.process.exitValue();
        }
        this.process.destroy();
        try {
            this.process.waitFor(timeoutPerStage, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.process.isAlive()) {
            return this.process.exitValue();
        }
        this.process.destroyForcibly();
        try {
            this.process.waitFor(timeoutPerStage, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.process.isAlive()) {
            throw new RuntimeException("Could not terminate process");
        }
        return this.process.exitValue();
    }

    public int stop() {
        return this.stop(1000);
    }

    protected void copyStream(InputStream processStream, OutputStream ourStream) {
        this.loggerThread = new StreamCopierByLine(processStream, ourStream);
        this.loggerThread.setDaemon(true);
        this.loggerThread.start();
    }

    protected abstract void setupInteraction();

    protected abstract void stopInteraction();

    protected boolean need2start() {
        boolean ret = false;
        if (this.builder == null) {
            ret = true;
        } else if (this.process == null) {
            ret = true;
        } else if (!this.process.isAlive()) {
            ret = true;
        } else {
            boolean stillRunning = false;
            try {
                int n = this.process.exitValue();
            }
            catch (IllegalThreadStateException ex) {
                stillRunning = true;
            }
            if (!stillRunning) {
                ret = true;
            }
        }
        return ret;
    }

    protected void updateCommand4OS(List<String> command) {
        boolean linuxLike = System.getProperty("file.separator").equals("/");
        boolean windowsLike = System.getProperty("file.separator").equals("\\");
        for (int i = 0; i < command.size(); ++i) {
            String arg = command.get(i);
            if (!arg.contains(" ") || linuxLike || !windowsLike) continue;
            command.set(i, "\"" + arg + "\"");
        }
    }

    private static class StreamCopierByLine
    extends Thread {
        OutputStream outstream;
        InputStreamReader isr;
        BufferedReader br;

        public StreamCopierByLine(InputStream instream, OutputStream outstream) {
            this.outstream = outstream;
            try {
                this.isr = new InputStreamReader(instream, "utf-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("Could not create StreamReader", ex);
            }
            this.br = new BufferedReader(this.isr);
        }

        @Override
        public void run() {
            boolean isFirstLine = true;
            try {
                String strLine;
                while ((strLine = this.br.readLine()) != null) {
                    if (!isFirstLine) {
                        this.outstream.write("\n".getBytes());
                    }
                    this.outstream.write(strLine.getBytes("utf-8"));
                    isFirstLine = false;
                    this.outstream.flush();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Error during stream copy", ex);
            }
        }
    }

    private static class StreamCopierByBuffer
    extends Thread {
        public transient Logger logger = LoggerFactory.getLogger(this.getClass());
        InputStream stream;
        OutputStream outstream;

        public StreamCopierByBuffer(InputStream stream, OutputStream outstream) {
            this.stream = stream;
            this.outstream = outstream;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[1024];
            while (true) {
                block6: {
                    try {
                        int n = this.stream.read(buffer);
                        if (n == -1) {
                        }
                        break block6;
                    }
                    catch (IOException ex) {
                        this.logger.error("Could not copy stream from the process to our own stream", (Throwable)ex);
                    }
                    break;
                }
                try {
                    this.outstream.write(buffer);
                }
                catch (IOException ex) {
                    this.logger.error("Could not copy stream from the process to our own stream", (Throwable)ex);
                    break;
                }
            }
        }
    }
}

