/*
 * Decompiled with CFR 0.152.
 */
package gate.lib.interaction.process.http;

import gate.lib.interaction.process.ProcessSimple;
import java.io.File;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import org.springframework.util.SocketUtils;

public class ProcessHttp {
    private String path = "/";
    private int port = 57117;
    private String host = "127.0.0.1";
    private ServerSocket socket = null;
    private String uri = "${host}:${port}${path}";
    private List<String> command;
    private ProcessState state = ProcessState.NOT_STARTED;
    private Map<String, String> env;
    private File workingDir = new File(".");
    private ProcessSimple process;

    public ProcessHttp setHost(String host) {
        this.host = host;
        return this;
    }

    private void ensure(ProcessState state) {
        if (this.state != state) {
            throw new RuntimeException("Method cannot be used unless in state " + (Object)((Object)state));
        }
    }

    public ProcessHttp setPort(int port) {
        this.ensure(ProcessState.NOT_STARTED);
        try {
            this.port = SocketUtils.findAvailableTcpPort((int)port, (int)port);
        }
        catch (Exception ex) {
            this.state = ProcessState.ENDED_OR_ABORTED;
            throw new RuntimeException("Port not available:" + port);
        }
        return this;
    }

    public ProcessHttp setWorkingDir(File dir) {
        this.ensure(ProcessState.NOT_STARTED);
        this.workingDir = dir;
        return this;
    }

    public ProcessHttp setPath(String path) {
        this.ensure(ProcessState.NOT_STARTED);
        this.path = path;
        return this;
    }

    public ProcessHttp setPort(int fromport, int toport) {
        this.ensure(ProcessState.NOT_STARTED);
        try {
            this.port = SocketUtils.findAvailableTcpPort((int)fromport, (int)toport);
        }
        catch (Exception ex) {
            this.state = ProcessState.ENDED_OR_ABORTED;
            throw new RuntimeException("Port not available from range:" + fromport + "-" + toport, ex);
        }
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public ProcessHttp setRunServerCmd(String command) {
        this.ensure(ProcessState.NOT_STARTED);
        this.command = Arrays.asList(command.split("\\s+", 0));
        return this;
    }

    public ProcessHttp setRunServerCmd(List<String> command) {
        this.ensure(ProcessState.NOT_STARTED);
        this.command = command;
        return this;
    }

    public ProcessHttp start() {
        this.ensure(ProcessState.NOT_STARTED);
        if (this.uri == null || this.command == null || this.command.isEmpty() || this.workingDir == null || this.env == null) {
            this.state = ProcessState.ENDED_OR_ABORTED;
            throw new RuntimeException("One of uri, command, workingDir or env is null or empty");
        }
        this.uri = this.uri.replaceAll("$\\{path\\}", this.path);
        this.uri = this.uri.replaceAll("$\\{port\\}", "" + this.port);
        this.uri = this.uri.replaceAll("$\\{host\\}", this.host);
        if (this.command != null) {
            for (int i = 0; i < this.command.size(); ++i) {
                this.command.set(i, this.command.get(i).replaceAll("$\\{path\\}", this.path));
                this.command.set(i, this.command.get(i).replaceAll("$\\{port\\}", "" + this.port));
                this.command.set(i, this.command.get(i).replaceAll("$\\{host\\}", this.host));
            }
            this.process = ProcessSimple.create(this.workingDir, this.env, this.command);
        }
        this.state = ProcessState.STARTED;
        return this;
    }

    public ProcessHttp stop() {
        this.ensure(ProcessState.STARTED);
        if (this.command != null) {
            this.process.stop();
        }
        this.state = ProcessState.ENDED_OR_ABORTED;
        Unirest.shutDown();
        return this;
    }

    public String processString(String toProcess, String command, Map<String, String> parms) {
        try {
            HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)this.uri).header("accept", "text/plain")).header("content-type", "text/plain")).body(command).asString();
            return (String)response.getBody();
        }
        catch (UnirestException ex) {
            throw new RuntimeException("Exception when connecting to the server", ex);
        }
    }

    public static enum ProcessState {
        NOT_STARTED,
        STARTED,
        ENDED_OR_ABORTED;

    }
}

